/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.mapper;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.sql.SqlJsonColumnReader;
import io.micronaut.data.runtime.mapper.sql.SqlJsonValueMapper;
import io.micronaut.data.runtime.operations.internal.sql.SqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.json.JsonMapper;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonBinaryObjectMapper;
import io.micronaut.serde.oracle.jdbc.json.OracleJdbcJsonTextObjectMapper;
import io.r2dbc.spi.Row;
import jakarta.inject.Singleton;
import java.io.IOException;
import oracle.sql.json.OracleJsonParser;

@Singleton
@Requires(classes={OracleJdbcJsonBinaryObjectMapper.class, OracleJdbcJsonTextObjectMapper.class})
@Internal
class OracleR2dbcJsonColumnMapper
implements SqlJsonColumnReader<Row>,
SqlJsonValueMapper {
    private final OracleJdbcJsonBinaryObjectMapper binaryObjectMapper;
    private final OracleJdbcJsonTextObjectMapper textObjectMapper;

    public OracleR2dbcJsonColumnMapper(OracleJdbcJsonBinaryObjectMapper binaryObjectMapper, OracleJdbcJsonTextObjectMapper textObjectMapper) {
        this.binaryObjectMapper = binaryObjectMapper;
        this.textObjectMapper = textObjectMapper;
    }

    public <T> T readJsonColumn(ResultReader<Row, String> resultReader, Row resultSet, String columnName, JsonDataType jsonDataType, Argument<T> argument) {
        try {
            switch (jsonDataType) {
                case DEFAULT: {
                    OracleJsonParser jsonParser = (OracleJsonParser)resultSet.get(columnName, OracleJsonParser.class);
                    if (jsonParser == null) {
                        return null;
                    }
                    return (T)this.binaryObjectMapper.readValue(jsonParser, argument);
                }
                case BLOB: {
                    byte[] bytes = (byte[])resultSet.get(columnName, byte[].class);
                    if (bytes == null) {
                        return null;
                    }
                    return (T)this.binaryObjectMapper.readValue(bytes, argument);
                }
                case STRING: {
                    String data = resultReader.readString((Object)resultSet, (Object)columnName);
                    if (StringUtils.isEmpty((CharSequence)data) || data.equals("null")) {
                        return null;
                    }
                    if (argument.getType().equals(String.class)) {
                        return (T)data;
                    }
                    return (T)this.textObjectMapper.readValue(data, argument);
                }
            }
            throw new DataAccessException("Unexpected json type " + jsonDataType + " for JSON field [" + columnName + "]");
        }
        catch (Exception e) {
            throw new DataAccessException("Failed to read from JSON field [" + columnName + "].", (Throwable)e);
        }
    }

    @NonNull
    public JsonMapper getJsonMapper() {
        return this.textObjectMapper;
    }

    public boolean supportsRead(SqlPreparedQuery<?, ?> sqlPreparedQuery) {
        return sqlPreparedQuery.getDialect() == Dialect.ORACLE;
    }

    public boolean supportsResultSetType(Class<Row> resultSetType) {
        return Row.class.isAssignableFrom(resultSetType);
    }

    public Object mapValue(Object object, JsonDataType jsonDataType) throws IOException {
        if (jsonDataType == JsonDataType.STRING) {
            return this.textObjectMapper.writeValueAsString(object);
        }
        return this.binaryObjectMapper.writeValueAsBytes(object);
    }

    public boolean supportsMapValue(SqlStoredQuery<?, ?> sqlStoredQuery, JsonDataType jsonDataType) {
        return sqlStoredQuery.getDialect() == Dialect.ORACLE;
    }
}

