/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.operations;

import io.micronaut.aop.InvocationContext;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.NonUniqueResultException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.EntityOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedDataOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.operations.reactive.BlockingExecutorReactorRepositoryOperations;
import io.micronaut.data.r2dbc.config.DataR2dbcConfiguration;
import io.micronaut.data.r2dbc.convert.R2dbcConversionContext;
import io.micronaut.data.r2dbc.mapper.ColumnIndexR2dbcResultReader;
import io.micronaut.data.r2dbc.mapper.ColumnNameExistenceAwareR2dbcResultSetReader;
import io.micronaut.data.r2dbc.mapper.ColumnNameR2dbcResultReader;
import io.micronaut.data.r2dbc.mapper.R2dbcQueryStatement;
import io.micronaut.data.r2dbc.mapper.RowTupleMapper;
import io.micronaut.data.r2dbc.operations.R2dbcExceptionMapper;
import io.micronaut.data.r2dbc.operations.R2dbcOperations;
import io.micronaut.data.r2dbc.operations.R2dbcRepositoryOperations;
import io.micronaut.data.r2dbc.operations.R2dbcSchemaHandler;
import io.micronaut.data.r2dbc.operations.ReactorReactiveRepositoryOperations;
import io.micronaut.data.r2dbc.transaction.R2dbcReactorTransactionOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.convert.RuntimePersistentPropertyConversionContext;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.sql.SqlResultEntityTypeMapper;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import io.micronaut.data.runtime.multitenancy.SchemaTenantResolver;
import io.micronaut.data.runtime.operations.ReactorToAsyncOperationsAdaptor;
import io.micronaut.data.runtime.operations.internal.AbstractReactiveEntitiesOperations;
import io.micronaut.data.runtime.operations.internal.AbstractReactiveEntityOperations;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import io.micronaut.data.runtime.operations.internal.ReactiveCascadeOperations;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersStoredQuery;
import io.micronaut.data.runtime.operations.internal.sql.AbstractSqlRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.sql.SqlJsonColumnMapperProvider;
import io.micronaut.data.runtime.operations.internal.sql.SqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.data.runtime.support.AbstractConversionContext;
import io.micronaut.json.JsonMapper;
import io.micronaut.transaction.exceptions.TransactionSystemException;
import io.micronaut.transaction.reactive.ReactiveTransactionOperations;
import io.micronaut.transaction.reactive.ReactiveTransactionStatus;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Parameters;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcType;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.Type;
import jakarta.inject.Named;
import jakarta.persistence.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@EachBean(value=ConnectionFactory.class)
@Internal
final class DefaultR2dbcRepositoryOperations
extends AbstractSqlRepositoryOperations<Row, Statement, RuntimeException>
implements BlockingExecutorReactorRepositoryOperations,
R2dbcRepositoryOperations,
R2dbcOperations,
ReactiveCascadeOperations.ReactiveCascadeOperationsHelper<R2dbcOperationContext> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultR2dbcRepositoryOperations.class);
    private final ConnectionFactory connectionFactory;
    private final ReactorReactiveRepositoryOperations reactiveOperations;
    private final String dataSourceName;
    private ExecutorService ioExecutorService;
    private AsyncRepositoryOperations asyncRepositoryOperations;
    private final ReactiveCascadeOperations<R2dbcOperationContext> cascadeOperations;
    private final R2dbcReactorTransactionOperations transactionOperations;
    private final ReactorConnectionOperations<Connection> connectionOperations;
    @Nullable
    private final SchemaTenantResolver schemaTenantResolver;
    private final R2dbcSchemaHandler schemaHandler;
    private final DataR2dbcConfiguration configuration;
    private final Map<Dialect, List<R2dbcExceptionMapper>> r2dbcExceptionMappers = new EnumMap<Dialect, List<R2dbcExceptionMapper>>(Dialect.class);

    @Internal
    DefaultR2dbcRepositoryOperations(@Parameter String dataSourceName, ConnectionFactory connectionFactory, @NonNull DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, ApplicationContext applicationContext, @Nullable @Named(value="io") ExecutorService executorService, DataConversionService conversionService, AttributeConverterRegistry attributeConverterRegistry, @Nullable SchemaTenantResolver schemaTenantResolver, R2dbcSchemaHandler schemaHandler, @Parameter DataR2dbcConfiguration configuration, @Nullable JsonMapper jsonMapper, SqlJsonColumnMapperProvider<Row> sqlJsonColumnMapperProvider, List<R2dbcExceptionMapper> r2dbcExceptionMapperList, @Parameter R2dbcReactorTransactionOperations transactionOperations, @Parameter ReactorConnectionOperations<Connection> connectionOperations) {
        super(dataSourceName, (ResultReader)new ColumnNameR2dbcResultReader(conversionService), (ResultReader)new ColumnIndexR2dbcResultReader(conversionService), (QueryStatement)new R2dbcQueryStatement(conversionService), dateTimeProvider, runtimeEntityRegistry, (BeanContext)applicationContext, conversionService, attributeConverterRegistry, jsonMapper, sqlJsonColumnMapperProvider);
        this.connectionFactory = connectionFactory;
        this.ioExecutorService = executorService;
        this.schemaTenantResolver = schemaTenantResolver;
        this.schemaHandler = schemaHandler;
        this.configuration = configuration;
        this.transactionOperations = transactionOperations;
        this.connectionOperations = connectionOperations;
        this.reactiveOperations = new DefaultR2dbcReactiveRepositoryOperations();
        this.dataSourceName = dataSourceName;
        this.cascadeOperations = new ReactiveCascadeOperations((ConversionService)conversionService, (ReactiveCascadeOperations.ReactiveCascadeOperationsHelper)this);
        String name = dataSourceName;
        if (name == null) {
            name = "default";
        }
        if (CollectionUtils.isNotEmpty(r2dbcExceptionMapperList)) {
            for (R2dbcExceptionMapper r2dbcExceptionMapper : r2dbcExceptionMapperList) {
                Dialect dialect = r2dbcExceptionMapper.getDialect();
                List<R2dbcExceptionMapper> dialectR2dbcExceptionMapperList = this.r2dbcExceptionMappers.get(dialect);
                if (dialectR2dbcExceptionMapperList == null) {
                    dialectR2dbcExceptionMapperList = new ArrayList<R2dbcExceptionMapper>();
                }
                dialectR2dbcExceptionMapperList.add(r2dbcExceptionMapper);
                this.r2dbcExceptionMappers.put(dialect, dialectR2dbcExceptionMapperList);
            }
        }
    }

    protected ResultReader<Row, String> createColumnNameResultSetReaderWithColumnExistenceAware() {
        return new ColumnNameExistenceAwareR2dbcResultSetReader();
    }

    protected SqlTypeMapper<Row, Tuple> createTupleMapper() {
        return new RowTupleMapper((ConversionService)this.conversionService);
    }

    protected Integer getFirstResultSetIndex() {
        return 0;
    }

    public <T> T block(Function<io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations, Mono<T>> supplier) {
        PropagatedContext propagatedContext = PropagatedContext.getOrEmpty();
        return (T)Mono.defer(() -> ((Mono)supplier.apply(this.reactive())).contextWrite((ContextView)ReactorPropagation.addPropagatedContext((Context)Context.empty(), (PropagatedContext)propagatedContext))).block();
    }

    public <T> Optional<T> blockOptional(Function<io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations, Mono<T>> supplier) {
        PropagatedContext propagatedContext = PropagatedContext.getOrEmpty();
        return Mono.defer(() -> ((Mono)supplier.apply(this.reactive())).contextWrite((ContextView)ReactorPropagation.addPropagatedContext((Context)Context.empty(), (PropagatedContext)propagatedContext))).blockOptional();
    }

    public <T> Mono<T> persistOne(R2dbcOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        SqlStoredQuery storedQuery = this.resolveEntityInsert(ctx.annotationMetadata, ctx.repositoryType, value.getClass(), persistentEntity);
        R2dbcEntityOperations<T> op = new R2dbcEntityOperations<T>(ctx, storedQuery, persistentEntity, value, true);
        op.persist();
        return op.getEntity();
    }

    public <T> Flux<T> persistBatch(R2dbcOperationContext ctx, Iterable<T> values, RuntimePersistentEntity<T> persistentEntity, Predicate<T> predicate) {
        SqlStoredQuery storedQuery = this.resolveEntityInsert(ctx.annotationMetadata, ctx.repositoryType, persistentEntity.getIntrospection().getBeanType(), persistentEntity);
        R2dbcEntitiesOperations<T> op = new R2dbcEntitiesOperations<T>(ctx, storedQuery, persistentEntity, values, true);
        if (predicate != null) {
            op.veto(predicate);
        }
        op.persist();
        return op.getEntities();
    }

    public <T> Mono<T> updateOne(R2dbcOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        SqlStoredQuery storedQuery = this.resolveEntityUpdate(ctx.annotationMetadata, ctx.repositoryType, value.getClass(), persistentEntity);
        R2dbcEntityOperations<T> op = new R2dbcEntityOperations<T>(ctx, persistentEntity, value, storedQuery);
        op.update();
        return op.getEntity();
    }

    public Mono<Void> persistManyAssociation(R2dbcOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        SqlStoredQuery storedQuery = this.resolveSqlInsertAssociation(ctx.repositoryType, runtimeAssociation, persistentEntity, value);
        R2dbcEntityOperations<Object> assocEntityOp = new R2dbcEntityOperations<Object>(ctx, childPersistentEntity, child, storedQuery);
        try {
            assocEntityOp.execute();
        }
        catch (Exception e1) {
            throw new DataAccessException("SQL error executing INSERT: " + e1.getMessage(), (Throwable)e1);
        }
        return assocEntityOp.getEntity().then();
    }

    public Mono<Void> persistManyAssociationBatch(R2dbcOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Iterable<Object> child, RuntimePersistentEntity<Object> childPersistentEntity, Predicate<Object> veto) {
        SqlStoredQuery storedQuery = this.resolveSqlInsertAssociation(ctx.repositoryType, runtimeAssociation, persistentEntity, value);
        R2dbcEntitiesOperations<Object> assocEntitiesOp = new R2dbcEntitiesOperations<Object>(ctx, childPersistentEntity, child, storedQuery);
        assocEntitiesOp.veto(veto);
        try {
            assocEntitiesOp.execute();
        }
        catch (Exception e1) {
            throw new DataAccessException("SQL error executing INSERT: " + e1.getMessage(), (Throwable)e1);
        }
        return assocEntitiesOp.getEntities().then();
    }

    private Mono<Number> sum(Stream<Mono<Number>> stream) {
        return stream.reduce((m1, m2) -> m1.zipWith(m2).map(t -> ((Number)t.getT1()).longValue() + ((Number)t.getT2()).longValue())).orElse((Mono<Number>)Mono.empty());
    }

    private <T> Flux<T> concatMono(Stream<Mono<T>> stream) {
        return Flux.concat(stream.toList());
    }

    @NonNull
    public ReactorReactiveRepositoryOperations reactive() {
        return this.reactiveOperations;
    }

    @NonNull
    public AsyncRepositoryOperations async() {
        if (this.asyncRepositoryOperations == null) {
            if (this.ioExecutorService == null) {
                this.ioExecutorService = Executors.newCachedThreadPool();
            }
            this.asyncRepositoryOperations = new ReactorToAsyncOperationsAdaptor((io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations)this.reactiveOperations, (Executor)this.ioExecutorService);
        }
        return this.asyncRepositoryOperations;
    }

    @Override
    @NonNull
    public ConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    @NonNull
    public <T> Flux<T> withConnection(@NonNull Function<Connection, Publisher<? extends T>> handler) {
        Objects.requireNonNull(handler, "Handler cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating a new Connection for DataSource: " + this.dataSourceName);
        }
        return Flux.usingWhen((Publisher)this.connectionFactory.create(), this.tenantAwareHandler(handler), connection -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing Connection for DataSource: " + this.dataSourceName);
            }
            return connection.close();
        });
    }

    private <K> Function<Connection, Publisher<? extends K>> tenantAwareHandler(Function<Connection, Publisher<? extends K>> handler) {
        Function<Connection, Object> theHandler = this.schemaTenantResolver == null ? handler : connection -> {
            String schemaName = this.schemaTenantResolver.resolveTenantSchemaName();
            if (schemaName != null) {
                return Mono.fromDirect(this.schemaHandler.useSchema((Connection)connection, this.configuration.getDialect(), schemaName)).thenReturn(connection).flatMapMany(handler::apply);
            }
            return (Publisher)handler.apply((Connection)connection);
        };
        return theHandler;
    }

    @Override
    @NonNull
    public <T> Publisher<T> withTransaction(@NonNull ReactiveTransactionStatus<Connection> status, @NonNull ReactiveTransactionOperations.TransactionalCallback<Connection, T> handler) {
        return this.transactionOperations.withTransaction(status, handler);
    }

    @Override
    public <T> Publisher<T> withTransaction(ReactiveTransactionOperations.TransactionalCallback<Connection, T> handler) {
        return this.transactionOperations.withTransaction(handler);
    }

    private static <R> Mono<R> toSingleResult(Flux<R> flux) {
        return Mono.fromDirect((Publisher)flux.collectList().flatMap(result -> {
            if (result.isEmpty()) {
                return Mono.empty();
            }
            if (result.size() > 1) {
                return Mono.error((Throwable)new NonUniqueResultException());
            }
            return Mono.just(result.get(0));
        }));
    }

    public boolean isSupportsBatchInsert(R2dbcOperationContext context, RuntimePersistentEntity<?> persistentEntity) {
        return this.isSupportsBatchInsert((PersistentEntity)persistentEntity, context.dialect);
    }

    @Nullable
    private DataAccessException mapR2dbcException(R2dbcException r2dbcException, Dialect dialect) {
        List dialectR2dbcExceptionMapperList = this.r2dbcExceptionMappers.getOrDefault(dialect, List.of());
        if (CollectionUtils.isNotEmpty(dialectR2dbcExceptionMapperList)) {
            for (R2dbcExceptionMapper dialectR2dbcExceptionMapper : dialectR2dbcExceptionMapperList) {
                DataAccessException dataAccessException = dialectR2dbcExceptionMapper.mapR2dbcException(r2dbcException);
                if (dataAccessException == null) continue;
                return dataAccessException;
            }
        }
        return null;
    }

    private static <T> Flux<T> executeAndMapEachRow(Statement statement, Function<Row, T> mapper) {
        return Flux.from((Publisher)statement.execute()).flatMap(result -> Flux.from((Publisher)result.map((row, rowMetadata) -> mapper.apply((Row)row))));
    }

    private static <T> Flux<T> executeAndMapEachReadable(Statement statement, Function<Readable, T> mapper) {
        return Flux.from((Publisher)statement.execute()).flatMap(result -> Flux.from((Publisher)result.map(mapper)));
    }

    private static <T> Flux<T> executeAndMapEachRowNullable(Statement statement, Function<Row, T> mapper) {
        return Flux.from((Publisher)statement.execute()).flatMap(result -> Flux.from((Publisher)result.map((row, metadata) -> Mono.justOrEmpty(mapper.apply((Row)row)))).flatMap(t -> t));
    }

    private <T> Flux<T> executeAndMapEachReadable(Statement statement, Dialect dialect, Function<Readable, T> mapper) {
        return DefaultR2dbcRepositoryOperations.executeAndMapEachReadable(statement, mapper).onErrorResume(this.errorHandler(dialect));
    }

    private Mono<Number> executeAndGetRowsUpdatedSingle(Statement statement, Dialect dialect) {
        return (Mono)DefaultR2dbcRepositoryOperations.executeAndGetRowsUpdated(statement).onErrorResume(this.errorHandler(dialect)).as(DefaultR2dbcRepositoryOperations::toSingleResult);
    }

    private static Flux<Number> executeAndGetRowsUpdated(Statement statement) {
        return Flux.from((Publisher)statement.execute()).flatMap(Result::getRowsUpdated).map(n -> n.longValue());
    }

    private <T> Function<? super Throwable, ? extends Publisher<? extends T>> errorHandler(Dialect dialect) {
        return throwable -> {
            R2dbcException r2dbcException;
            DataAccessException dataAccessException;
            if (throwable instanceof R2dbcException && (dataAccessException = this.mapR2dbcException(r2dbcException = (R2dbcException)throwable, dialect)) != null) {
                return Mono.error((Throwable)dataAccessException);
            }
            return Mono.error((Throwable)throwable);
        };
    }

    private final class DefaultR2dbcReactiveRepositoryOperations
    implements ReactorReactiveRepositoryOperations {
        private DefaultR2dbcReactiveRepositoryOperations() {
        }

        public <T> Mono<Boolean> exists(@NonNull PreparedQuery<T, Boolean> pq) {
            SqlPreparedQuery preparedQuery = DefaultR2dbcRepositoryOperations.this.getSqlPreparedQuery(pq);
            return this.executeReadMono((PreparedDataOperation<?>)preparedQuery, connection -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(arg_0 -> ((Connection)connection).createStatement(arg_0), (PreparedQuery)preparedQuery, false, true);
                preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder((Connection)connection, statement, (SqlStoredQuery<?, ?>)preparedQuery));
                return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, row -> true).collectList().map(records -> !records.isEmpty() && records.stream().allMatch(v -> v));
            });
        }

        @NonNull
        public <T, R> Mono<R> findOne(@NonNull PreparedQuery<T, R> pq) {
            SqlPreparedQuery preparedQuery = DefaultR2dbcRepositoryOperations.this.getSqlPreparedQuery(pq);
            return this.executeReadMono((PreparedDataOperation<?>)preparedQuery, connection -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(arg_0 -> ((Connection)connection).createStatement(arg_0), (PreparedQuery)preparedQuery, false, true);
                preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder((Connection)connection, statement, (SqlStoredQuery<?, ?>)preparedQuery));
                SqlTypeMapper mapper = DefaultR2dbcRepositoryOperations.this.createMapper((SqlStoredQuery)preparedQuery, Row.class);
                if (mapper instanceof SqlResultEntityTypeMapper) {
                    boolean hasJoins;
                    SqlResultEntityTypeMapper entityTypeMapper = (SqlResultEntityTypeMapper)mapper;
                    boolean bl = hasJoins = !preparedQuery.getJoinPaths().isEmpty();
                    if (!hasJoins) {
                        return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, arg_0 -> ((SqlResultEntityTypeMapper)entityTypeMapper).readEntity(arg_0));
                    }
                    SqlResultEntityTypeMapper.PushingMapper rowsMapper = entityTypeMapper.readOneMapper();
                    return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, row -> {
                        rowsMapper.processRow(row);
                        return "";
                    }).collectList().flatMap(ignore -> Mono.justOrEmpty((Object)rowsMapper.getResult()));
                }
                return DefaultR2dbcRepositoryOperations.executeAndMapEachRowNullable(statement, row -> mapper.map(row, preparedQuery.getResultType()));
            });
        }

        @NonNull
        public <T, R> Flux<R> findAll(@NonNull PreparedQuery<T, R> pq) {
            SqlPreparedQuery preparedQuery = DefaultR2dbcRepositoryOperations.this.getSqlPreparedQuery(pq);
            return this.executeReadFlux((PreparedDataOperation<?>)preparedQuery, connection -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(arg_0 -> ((Connection)connection).createStatement(arg_0), (PreparedQuery)preparedQuery, false, false);
                preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder((Connection)connection, statement, (SqlStoredQuery<?, ?>)preparedQuery));
                SqlTypeMapper mapper = DefaultR2dbcRepositoryOperations.this.createMapper((SqlStoredQuery)preparedQuery, Row.class);
                if (mapper instanceof SqlResultEntityTypeMapper) {
                    SqlResultEntityTypeMapper entityTypeMapper = (SqlResultEntityTypeMapper)mapper;
                    SqlResultEntityTypeMapper.PushingMapper rowsMapper = entityTypeMapper.readManyMapper();
                    return DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, row -> {
                        rowsMapper.processRow(row);
                        return "";
                    }).collectList().flatMapIterable(ignore -> (Iterable)rowsMapper.getResult());
                }
                return DefaultR2dbcRepositoryOperations.executeAndMapEachRowNullable(statement, row -> mapper.map(row, preparedQuery.getResultType()));
            });
        }

        @NonNull
        public Mono<Number> executeUpdate(@NonNull PreparedQuery<?, Number> pq) {
            SqlPreparedQuery preparedQuery = DefaultR2dbcRepositoryOperations.this.getSqlPreparedQuery(pq);
            return this.executeWriteMono((PreparedDataOperation<?>)preparedQuery, connection -> {
                Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(arg_0 -> ((Connection)connection).createStatement(arg_0), (PreparedQuery)preparedQuery, true, true);
                Dialect dialect = preparedQuery.getDialect();
                preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder((Connection)connection, statement, (SqlStoredQuery<?, ?>)preparedQuery));
                return DefaultR2dbcRepositoryOperations.this.executeAndGetRowsUpdatedSingle(statement, dialect).flatMap(rowsUpdated -> {
                    Argument argument;
                    if (QUERY_LOG.isTraceEnabled()) {
                        QUERY_LOG.trace("Update operation updated {} records", rowsUpdated);
                    }
                    if (preparedQuery.isOptimisticLock()) {
                        DefaultR2dbcRepositoryOperations.this.checkOptimisticLocking(1, rowsUpdated);
                    }
                    if ((argument = (Argument)preparedQuery.getResultArgument().getFirstTypeVariable().orElse(null)) != null) {
                        if (argument.isVoid() || argument.getType() == Void.class) {
                            return Mono.empty();
                        }
                        if (argument.getType().isInstance(rowsUpdated)) {
                            return Mono.just((Object)rowsUpdated);
                        }
                        return Mono.just((Object)((Number)DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.convertRequired(rowsUpdated, argument)));
                    }
                    return Mono.just((Object)rowsUpdated);
                });
            });
        }

        @NonNull
        public Mono<Number> executeDelete(@NonNull PreparedQuery<?, Number> preparedQuery) {
            return this.executeUpdate(preparedQuery);
        }

        @NonNull
        public <R> Flux<R> execute(@NonNull PreparedQuery<?, R> pq) {
            SqlPreparedQuery preparedQuery = DefaultR2dbcRepositoryOperations.this.getSqlPreparedQuery(pq);
            return this.executeWriteFlux((PreparedDataOperation<?>)preparedQuery, connection -> {
                if (preparedQuery.isProcedure()) {
                    int outIndex = preparedQuery.getQueryBindings().size();
                    Statement statement = (Statement)DefaultR2dbcRepositoryOperations.this.prepareStatement(arg_0 -> ((Connection)connection).createStatement(arg_0), (PreparedQuery)preparedQuery, true, true);
                    preparedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder((Connection)connection, statement, (SqlStoredQuery<?, ?>)preparedQuery));
                    if (!preparedQuery.getResultArgument().isVoid()) {
                        statement = statement.bind(outIndex, (Object)Parameters.out((Class)preparedQuery.getResultType()));
                    }
                    if (preparedQuery.getResultArgument().isVoid()) {
                        return DefaultR2dbcRepositoryOperations.executeAndGetRowsUpdated(statement).thenMany((Publisher)Flux.empty());
                    }
                    return DefaultR2dbcRepositoryOperations.this.executeAndMapEachReadable(statement, preparedQuery.getDialect(), readable -> readable.get(0, preparedQuery.getResultType()));
                }
                throw new IllegalStateException("Not implemented");
            });
        }

        @NonNull
        public <T> Mono<Number> delete(@NonNull DeleteOperation<T> operation) {
            return this.executeWriteMono((PreparedDataOperation<?>)operation, status -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)status, (SqlStoredQuery)storedQuery);
                R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, storedQuery.getPersistentEntity(), operation.getEntity(), storedQuery);
                op.delete();
                return op.getRowsUpdated();
            });
        }

        @NonNull
        public <T> Flux<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
            return this.executeWriteFlux((PreparedDataOperation<?>)operation, status -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                RuntimePersistentEntity persistentEntity = storedQuery.getPersistentEntity();
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)status, (SqlStoredQuery)storedQuery);
                if (!DefaultR2dbcRepositoryOperations.this.isSupportsBatchInsert((PersistentEntity)persistentEntity, storedQuery)) {
                    return DefaultR2dbcRepositoryOperations.this.concatMono(operation.split().stream().map(persistOp -> {
                        R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, storedQuery, persistentEntity, persistOp.getEntity(), true);
                        op.persist();
                        return op.getEntity();
                    }));
                }
                R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(ctx, storedQuery, persistentEntity, operation, true);
                op.persist();
                return op.getEntities();
            });
        }

        @NonNull
        public <T, R> Mono<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
            return this.findOne(preparedQuery);
        }

        @NonNull
        public <T> Mono<T> persist(@NonNull InsertOperation<T> operation) {
            return this.executeWriteMono((PreparedDataOperation<?>)operation, status -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)status, (SqlStoredQuery)storedQuery);
                R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, storedQuery, storedQuery.getPersistentEntity(), operation.getEntity(), true);
                op.persist();
                return op.getEntity();
            });
        }

        @NonNull
        public <T> Mono<T> update(@NonNull UpdateOperation<T> operation) {
            return this.executeWriteMono((PreparedDataOperation<?>)operation, status -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)status, (SqlStoredQuery)storedQuery);
                R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, storedQuery.getPersistentEntity(), operation.getEntity(), storedQuery);
                op.update();
                return op.getEntity();
            });
        }

        private <R> Mono<R> executeWriteMono(@NonNull PreparedDataOperation<?> operation, @NonNull Function<Connection, Publisher<R>> entityOperation) {
            return this.withConnectionMono(operation, true, connection -> Mono.fromDirect((Publisher)((Publisher)entityOperation.apply((Connection)connection))));
        }

        private <R> Flux<R> executeWriteFlux(@NonNull PreparedDataOperation<?> operation, @NonNull Function<Connection, Flux<R>> entityOperation) {
            return this.withConnectionFlux(operation, true, entityOperation);
        }

        private <R> Mono<R> executeReadMono(@NonNull PreparedDataOperation<?> operation, @NonNull Function<Connection, Publisher<R>> entityOperation) {
            return this.withConnectionMono(operation, false, connection -> Mono.fromDirect((Publisher)((Publisher)entityOperation.apply((Connection)connection))));
        }

        private <R> Flux<R> executeReadFlux(@NonNull PreparedDataOperation<?> operation, @NonNull Function<Connection, Flux<R>> entityOperation) {
            return this.withConnectionFlux(operation, false, entityOperation);
        }

        private <R> Flux<R> withConnectionFlux(@NonNull PreparedDataOperation<?> operation, boolean isWrite, @NonNull Function<Connection, Flux<R>> callback) {
            ReactiveTransactionStatus tx = operation.getParameterInRole("tx-status", ReactiveTransactionStatus.class).orElse(null);
            if (tx != null) {
                try {
                    return Flux.deferContextual(contextView -> {
                        try (PropagatedContext.Scope ignore = ReactorPropagation.findPropagatedContext((ContextView)contextView).orElse(PropagatedContext.empty()).propagate();){
                            Publisher publisher = (Publisher)callback.apply((Connection)tx.getConnection());
                            return publisher;
                        }
                    });
                }
                catch (Exception e) {
                    return Flux.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                }
            }
            return DefaultR2dbcRepositoryOperations.this.connectionOperations.withConnectionFlux(isWrite ? ConnectionDefinition.DEFAULT : ConnectionDefinition.READ_ONLY, status -> Flux.deferContextual(contextView -> {
                try (PropagatedContext.Scope ignore = ReactorPropagation.findPropagatedContext((ContextView)contextView).orElse(PropagatedContext.empty()).propagate();){
                    Publisher publisher = (Publisher)callback.apply((Connection)status.getConnection());
                    return publisher;
                }
            }));
        }

        private <R> Mono<R> withConnectionMono(@NonNull PreparedDataOperation<?> operation, boolean isWrite, @NonNull Function<Connection, Mono<R>> callback) {
            ReactiveTransactionStatus tx = operation.getParameterInRole("tx-status", ReactiveTransactionStatus.class).orElse(null);
            if (tx != null) {
                try {
                    return Mono.deferContextual(contextView -> {
                        try (PropagatedContext.Scope ignore = ReactorPropagation.findPropagatedContext((ContextView)contextView).orElse(PropagatedContext.empty()).propagate();){
                            Mono mono = (Mono)callback.apply((Connection)tx.getConnection());
                            return mono;
                        }
                    });
                }
                catch (Exception e) {
                    return Mono.error((Throwable)new TransactionSystemException("Error invoking doInTransaction handler: " + e.getMessage(), (Throwable)e));
                }
            }
            return DefaultR2dbcRepositoryOperations.this.connectionOperations.withConnectionMono(isWrite ? ConnectionDefinition.DEFAULT : ConnectionDefinition.READ_ONLY, status -> Mono.deferContextual(contextView -> {
                try (PropagatedContext.Scope ignore = ReactorPropagation.findPropagatedContext((ContextView)contextView).orElse(PropagatedContext.empty()).propagate();){
                    Mono mono = (Mono)callback.apply((Connection)status.getConnection());
                    return mono;
                }
            }));
        }

        @NonNull
        public <T> Mono<Number> deleteAll(DeleteBatchOperation<T> operation) {
            return this.executeWriteMono((PreparedDataOperation<?>)operation, connection -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                RuntimePersistentEntity persistentEntity = storedQuery.getPersistentEntity();
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)connection, (SqlStoredQuery)storedQuery);
                if (DefaultR2dbcRepositoryOperations.this.isSupportsBatchDelete((PersistentEntity)persistentEntity, storedQuery.getDialect())) {
                    R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(ctx, persistentEntity, operation, storedQuery);
                    op.delete();
                    return op.getRowsUpdated();
                }
                return DefaultR2dbcRepositoryOperations.this.sum(operation.split().stream().map(deleteOp -> {
                    R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, persistentEntity, deleteOp.getEntity(), storedQuery);
                    op.delete();
                    return op.getRowsUpdated();
                }));
            });
        }

        @NonNull
        public <T> Flux<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
            return this.executeWriteFlux((PreparedDataOperation<?>)operation, connection -> {
                SqlStoredQuery storedQuery = DefaultR2dbcRepositoryOperations.this.getSqlStoredQuery(operation.getStoredQuery());
                R2dbcOperationContext ctx = this.createContext((EntityOperation)operation, (Connection)connection, (SqlStoredQuery)storedQuery);
                RuntimePersistentEntity persistentEntity = storedQuery.getPersistentEntity();
                if (!DefaultR2dbcRepositoryOperations.this.isSupportsBatchUpdate((PersistentEntity)persistentEntity, storedQuery)) {
                    return DefaultR2dbcRepositoryOperations.this.concatMono(operation.split().stream().map(updateOp -> {
                        R2dbcEntityOperations<Object> op = new R2dbcEntityOperations<Object>(ctx, persistentEntity, updateOp.getEntity(), storedQuery);
                        op.update();
                        return op.getEntity();
                    }));
                }
                R2dbcEntitiesOperations op = new R2dbcEntitiesOperations(ctx, persistentEntity, operation, storedQuery);
                op.update();
                return op.getEntities();
            });
        }

        private <T> R2dbcOperationContext createContext(EntityOperation<T> operation, Connection connection, SqlStoredQuery<T, ?> storedQuery) {
            return new R2dbcOperationContext(operation.getAnnotationMetadata(), operation.getInvocationContext(), operation.getRepositoryType(), storedQuery.getDialect(), connection);
        }

        @NonNull
        public <T> Mono<T> findOptional(@NonNull Class<T> type, @NonNull Object id) {
            throw new UnsupportedOperationException("The findOptional method by ID is not supported. Execute the SQL query directly");
        }

        @NonNull
        public <R> Mono<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
            throw new UnsupportedOperationException("The findPage method is not supported. Execute the SQL query directly");
        }

        @NonNull
        public <T> Mono<T> findOne(@NonNull Class<T> type, @NonNull Object id) {
            throw new UnsupportedOperationException("The findOne method by ID is not supported. Execute the SQL query directly");
        }

        @NonNull
        public <T> Mono<Long> count(PagedQuery<T> pagedQuery) {
            throw new UnsupportedOperationException("The count method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
        }

        @NonNull
        public <T> Flux<T> findAll(PagedQuery<T> pagedQuery) {
            throw new UnsupportedOperationException("The findAll method without an explicit query is not supported. Use findAll(PreparedQuery) instead");
        }

        public ConversionService getConversionService() {
            return DefaultR2dbcRepositoryOperations.this.conversionService;
        }
    }

    protected static class R2dbcOperationContext
    extends OperationContext {
        private final Connection connection;
        private final Dialect dialect;
        private final InvocationContext<?, ?> invocationContext;

        public R2dbcOperationContext(AnnotationMetadata annotationMetadata, InvocationContext<?, ?> invocationContext, Class<?> repositoryType, Dialect dialect, Connection connection) {
            super(annotationMetadata, repositoryType);
            this.dialect = dialect;
            this.connection = connection;
            this.invocationContext = invocationContext;
        }
    }

    private final class R2dbcEntityOperations<T>
    extends AbstractReactiveEntityOperations<R2dbcOperationContext, T, RuntimeException> {
        private final SqlStoredQuery<T, ?> storedQuery;

        private R2dbcEntityOperations(R2dbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, SqlStoredQuery<T, ?> storedQuery) {
            this(ctx, storedQuery, persistentEntity, entity, false);
        }

        private R2dbcEntityOperations(R2dbcOperationContext ctx, SqlStoredQuery<T, ?> storedQuery, RuntimePersistentEntity<T> persistentEntity, T entity, boolean insert) {
            super((OperationContext)ctx, DefaultR2dbcRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultR2dbcRepositoryOperations.this.conversionService, DefaultR2dbcRepositoryOperations.this.entityEventRegistry, persistentEntity, entity, insert);
            this.storedQuery = storedQuery;
        }

        protected void collectAutoPopulatedPreviousValues() {
            this.data = this.data.map(d -> {
                if (d.vetoed) {
                    return d;
                }
                d.previousValues = this.storedQuery.collectAutoPopulatedPreviousValues(d.entity);
                return d;
            });
        }

        private Statement prepare(Connection connection) throws RuntimeException {
            SqlStoredQuery<T, ?> sqlStoredQuery = this.storedQuery;
            if (sqlStoredQuery instanceof SqlPreparedQuery) {
                SqlPreparedQuery sqlPreparedQuery = (SqlPreparedQuery)sqlStoredQuery;
                this.data = this.data.map(d -> {
                    if (d.vetoed) {
                        return d;
                    }
                    sqlPreparedQuery.prepare(d.entity);
                    return d;
                });
            }
            LOG.debug(this.storedQuery.getQuery());
            Statement statement = connection.createStatement(this.storedQuery.getQuery());
            if (this.hasGeneratedId) {
                if (DefaultR2dbcRepositoryOperations.this.isJsonEntityGeneratedId(this.storedQuery, (PersistentEntity)this.persistentEntity)) {
                    return statement.bind(this.storedQuery.getQueryBindings().size(), (Object)Parameters.out((Type)R2dbcType.NUMERIC));
                }
                return statement.returnGeneratedValues(new String[]{this.persistentEntity.getIdentity().getPersistedName()});
            }
            return statement;
        }

        private void setParameters(Statement stmt, SqlStoredQuery<T, ?> storedQuery) {
            this.data = this.data.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                return Mono.deferContextual(contextView -> {
                    try (PropagatedContext.Scope ignore = ReactorPropagation.findPropagatedContext((ContextView)contextView).orElse(PropagatedContext.empty()).propagate();){
                        storedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder((R2dbcOperationContext)this.ctx, stmt, storedQuery), ((R2dbcOperationContext)this.ctx).invocationContext, d.entity, d.previousValues);
                    }
                    return Mono.just((Object)d);
                });
            });
        }

        private <T> Mono<T> executeAndMapEachRowSingle(Statement statement, Dialect dialect, Function<Row, T> mapper) {
            return (Mono)DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, mapper).onErrorResume(DefaultR2dbcRepositoryOperations.this.errorHandler(dialect)).as(DefaultR2dbcRepositoryOperations::toSingleResult);
        }

        protected void execute() throws RuntimeException {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL query: {}", (Object)this.storedQuery.getQuery());
            }
            Statement statement = this.prepare(((R2dbcOperationContext)this.ctx).connection);
            this.setParameters(statement, this.storedQuery);
            this.data = this.hasGeneratedId ? this.data.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                Function<Object, AbstractReactiveEntityOperations.Data> idMapper = id -> {
                    BeanProperty property = identity.getProperty();
                    d.entity = this.updateEntityId(property, d.entity, id);
                    return d;
                };
                if (DefaultR2dbcRepositoryOperations.this.isJsonEntityGeneratedId(this.storedQuery, (PersistentEntity)this.persistentEntity)) {
                    return Flux.from((Publisher)statement.execute()).flatMap(result -> Flux.from((Publisher)result.map(outParameters -> outParameters.get(0, Object.class)))).onErrorResume(DefaultR2dbcRepositoryOperations.this.errorHandler(((R2dbcOperationContext)this.ctx).dialect)).map(idMapper).last();
                }
                return this.executeAndMapEachRowSingle(statement, ((R2dbcOperationContext)this.ctx).dialect, row -> DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, identity.getDataType())).map(idMapper);
            }) : this.data.flatMap(d -> {
                if (d.vetoed) {
                    return Mono.just((Object)d);
                }
                return DefaultR2dbcRepositoryOperations.this.executeAndGetRowsUpdatedSingle(statement, ((R2dbcOperationContext)this.ctx).dialect).map(rowsUpdated -> {
                    d.rowsUpdated = rowsUpdated.longValue();
                    return d;
                });
            });
            if (this.storedQuery.isOptimisticLock()) {
                this.data = this.data.map(d -> {
                    this.checkOptimisticLocking(1L, d.rowsUpdated);
                    return d;
                });
            }
        }
    }

    private final class R2dbcEntitiesOperations<T>
    extends AbstractReactiveEntitiesOperations<R2dbcOperationContext, T, RuntimeException> {
        private final SqlStoredQuery<T, ?> storedQuery;

        private R2dbcEntitiesOperations(R2dbcOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, SqlStoredQuery storedQuery) {
            this(ctx, storedQuery, persistentEntity, entities, false);
        }

        private R2dbcEntitiesOperations(R2dbcOperationContext ctx, SqlStoredQuery storedQuery, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, boolean insert) {
            super((OperationContext)ctx, DefaultR2dbcRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultR2dbcRepositoryOperations.this.conversionService, DefaultR2dbcRepositoryOperations.this.entityEventRegistry, persistentEntity, entities, insert);
            this.storedQuery = storedQuery;
        }

        protected void collectAutoPopulatedPreviousValues() {
            this.entities = this.entities.map(list -> {
                for (AbstractReactiveEntitiesOperations.Data d : list) {
                    if (d.vetoed) continue;
                    d.previousValues = this.storedQuery.collectAutoPopulatedPreviousValues(d.entity);
                }
                return list;
            });
        }

        private void setParameters(Statement stmt, SqlStoredQuery<T, ?> storedQuery) {
            AtomicBoolean isFirst = new AtomicBoolean(true);
            this.entities = this.entities.map(list -> {
                for (AbstractReactiveEntitiesOperations.Data d : list) {
                    if (d.vetoed) continue;
                    if (isFirst.get()) {
                        isFirst.set(false);
                    } else {
                        stmt.add();
                    }
                    storedQuery.bindParameters((BindableParametersStoredQuery.Binder)new R2dbcParameterBinder((R2dbcOperationContext)this.ctx, stmt, storedQuery), ((R2dbcOperationContext)this.ctx).invocationContext, d.entity, d.previousValues);
                }
                return list;
            });
        }

        protected void execute() throws RuntimeException {
            Statement statement;
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing SQL query: {}", (Object)this.storedQuery.getQuery());
            }
            if (this.hasGeneratedId) {
                statement = ((R2dbcOperationContext)this.ctx).connection.createStatement(this.storedQuery.getQuery());
                if (DefaultR2dbcRepositoryOperations.this.isJsonEntityGeneratedId(this.storedQuery, (PersistentEntity)this.persistentEntity)) {
                    statement.bind(this.storedQuery.getQueryBindings().size(), (Object)Parameters.out((Type)R2dbcType.NUMERIC));
                } else {
                    statement.returnGeneratedValues(new String[]{this.persistentEntity.getIdentity().getPersistedName()});
                }
            } else {
                statement = ((R2dbcOperationContext)this.ctx).connection.createStatement(this.storedQuery.getQuery());
            }
            this.setParameters(statement, this.storedQuery);
            if (this.hasGeneratedId) {
                this.entities = this.entities.flatMap(list -> {
                    List<AbstractReactiveEntitiesOperations.Data> notVetoedEntities = list.stream().filter(x$0 -> this.notVetoed((AbstractReactiveEntitiesOperations.Data)x$0)).toList();
                    if (notVetoedEntities.isEmpty()) {
                        return Mono.just(notVetoedEntities);
                    }
                    Function<Row, Object> idMapper = DefaultR2dbcRepositoryOperations.this.isJsonEntityGeneratedId(this.storedQuery, (PersistentEntity)this.persistentEntity) ? row -> row.get(0, Object.class) : row -> DefaultR2dbcRepositoryOperations.this.columnIndexResultSetReader.readDynamic(row, (Object)0, this.persistentEntity.getIdentity().getDataType());
                    Mono ids = DefaultR2dbcRepositoryOperations.executeAndMapEachRow(statement, idMapper).collectList();
                    return ids.flatMap(idList -> {
                        Iterator iterator = idList.iterator();
                        ListIterator resultIterator = notVetoedEntities.listIterator();
                        RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                        while (resultIterator.hasNext()) {
                            AbstractReactiveEntitiesOperations.Data d = (AbstractReactiveEntitiesOperations.Data)resultIterator.next();
                            if (!iterator.hasNext()) {
                                throw new DataAccessException("Failed to generate ID for entity: " + d.entity);
                            }
                            Object id = iterator.next();
                            d.entity = this.updateEntityId(identity.getProperty(), d.entity, id);
                        }
                        return Mono.just((Object)list);
                    });
                });
            } else {
                Mono entitiesWithRowsUpdated = this.entities.flatMap(list -> {
                    List<AbstractReactiveEntitiesOperations.Data> notVetoedEntities = list.stream().filter(x$0 -> this.notVetoed((AbstractReactiveEntitiesOperations.Data)x$0)).toList();
                    if (notVetoedEntities.isEmpty()) {
                        return Mono.just((Object)Tuples.of((Object)list, (Object)0L));
                    }
                    return DefaultR2dbcRepositoryOperations.executeAndGetRowsUpdated(statement).onErrorResume(DefaultR2dbcRepositoryOperations.this.errorHandler(((R2dbcOperationContext)this.ctx).dialect)).map(Number::longValue).reduce((Object)0L, Long::sum).map(rowsUpdated -> {
                        if (this.storedQuery.isOptimisticLock()) {
                            this.checkOptimisticLocking(notVetoedEntities.size(), (long)rowsUpdated);
                        }
                        return Tuples.of((Object)list, (Object)rowsUpdated);
                    });
                }).cache();
                this.entities = entitiesWithRowsUpdated.flatMap(t -> Mono.just((Object)((List)t.getT1())));
                this.rowsUpdated = entitiesWithRowsUpdated.map(Tuple2::getT2);
            }
        }
    }

    private static class R2dbcConversionContextImpl
    extends AbstractConversionContext
    implements R2dbcConversionContext {
        private final Connection connection;

        public R2dbcConversionContextImpl(Connection connection) {
            this(ConversionContext.DEFAULT, connection);
        }

        public R2dbcConversionContextImpl(ConversionContext conversionContext, Connection connection) {
            super(conversionContext);
            this.connection = connection;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }
    }

    private static final class ArgumentR2dbcCC
    extends R2dbcConversionContextImpl
    implements ArgumentConversionContext<Object> {
        private final Argument argument;

        public ArgumentR2dbcCC(Connection connection, Argument argument) {
            super((ConversionContext)ConversionContext.of((Argument)argument), connection);
            this.argument = argument;
        }

        public Argument<Object> getArgument() {
            return this.argument;
        }
    }

    private static final class RuntimePersistentPropertyR2dbcCC
    extends R2dbcConversionContextImpl
    implements RuntimePersistentPropertyConversionContext {
        private final RuntimePersistentProperty<?> property;

        public RuntimePersistentPropertyR2dbcCC(Connection connection, RuntimePersistentProperty<?> property) {
            super((ConversionContext)ConversionContext.of((Argument)property.getArgument()), connection);
            this.property = property;
        }

        public RuntimePersistentProperty<?> getRuntimePersistentProperty() {
            return this.property;
        }
    }

    private final class R2dbcParameterBinder
    implements BindableParametersStoredQuery.Binder {
        private final Connection connection;
        private final Statement ps;
        private final SqlStoredQuery<?, ?> sqlStoredQuery;
        private int index = 0;

        private R2dbcParameterBinder(R2dbcOperationContext ctx, Statement ps, SqlStoredQuery<?, ?> sqlStoredQuery) {
            this(ctx.connection, ps, sqlStoredQuery);
        }

        private R2dbcParameterBinder(Connection connection, Statement ps, SqlStoredQuery<?, ?> sqlStoredQuery) {
            this.connection = connection;
            this.ps = ps;
            this.sqlStoredQuery = sqlStoredQuery;
        }

        public Object autoPopulateRuntimeProperty(RuntimePersistentProperty<?> persistentProperty, Object previousValue) {
            return DefaultR2dbcRepositoryOperations.this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
        }

        public Object convert(Object value, RuntimePersistentProperty<?> property) {
            if (property == null) {
                return value;
            }
            AttributeConverter converter = property.getConverter();
            if (converter != null) {
                return converter.convertToPersistedValue(value, this.createTypeConversionContext(property, property.getArgument()));
            }
            return value;
        }

        public Object convert(Class<?> converterClass, Object value, Argument<?> argument) {
            if (converterClass == null) {
                return value;
            }
            AttributeConverter converter = DefaultR2dbcRepositoryOperations.this.attributeConverterRegistry.getConverter(converterClass);
            ConversionContext conversionContext = this.createTypeConversionContext(null, argument);
            return converter.convertToPersistedValue(value, conversionContext);
        }

        private ConversionContext createTypeConversionContext(@Nullable RuntimePersistentProperty<?> property, @Nullable Argument<?> argument) {
            if (property != null) {
                return new RuntimePersistentPropertyR2dbcCC(this.connection, property);
            }
            if (argument != null) {
                return new ArgumentR2dbcCC(this.connection, argument);
            }
            return new R2dbcConversionContextImpl(this.connection);
        }

        public void bindOne(QueryParameterBinding binding, Object value) {
            JsonDataType jsonDataType = null;
            if (binding.getDataType() == DataType.JSON) {
                jsonDataType = binding.getJsonDataType();
            }
            DefaultR2dbcRepositoryOperations.this.setStatementParameter(this.ps, this.index, binding.getDataType(), jsonDataType, value, this.sqlStoredQuery);
            ++this.index;
        }

        public void bindMany(QueryParameterBinding binding, Collection<Object> values) {
            for (Object value : values) {
                this.bindOne(binding, value);
            }
        }

        public int currentIndex() {
            return this.index;
        }
    }
}

