/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.config;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.r2dbc.config.DataR2dbcConfiguration;
import io.micronaut.data.r2dbc.operations.R2dbcSchemaHandler;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.config.SchemaGenerate;
import io.r2dbc.spi.Connection;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Context
@Internal
public class R2dbcSchemaGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(R2dbcSchemaGenerator.class);
    private final List<DataR2dbcConfiguration> configurations;
    private final R2dbcSchemaHandler schemaHandler;

    public R2dbcSchemaGenerator(List<DataR2dbcConfiguration> configurations, R2dbcSchemaHandler schemaHandler) {
        this.configurations = configurations;
        this.schemaHandler = schemaHandler;
    }

    @PostConstruct
    protected void createSchema(BeanLocator beanLocator) {
        RuntimeEntityRegistry runtimeEntityRegistry = (RuntimeEntityRegistry)beanLocator.getBean(RuntimeEntityRegistry.class);
        for (DataR2dbcConfiguration configuration : this.configurations) {
            List<String> packages;
            Collection introspections;
            Object[] entities;
            SchemaGenerate schemaGenerate = configuration.getSchemaGenerate();
            if (schemaGenerate == null || schemaGenerate == SchemaGenerate.NONE || !ArrayUtils.isNotEmpty((Object[])(entities = (PersistentEntity[])(introspections = CollectionUtils.isNotEmpty(packages = configuration.getPackages()) ? BeanIntrospector.SHARED.findIntrospections(MappedEntity.class, packages.toArray(new String[0])) : BeanIntrospector.SHARED.findIntrospections(MappedEntity.class)).stream().filter(i -> !i.getBeanType().getName().contains("$")).filter(i -> !Modifier.isAbstract(i.getBeanType().getModifiers())).map(e -> runtimeEntityRegistry.getEntity(e.getBeanType())).toArray(PersistentEntity[]::new)))) continue;
            SqlQueryBuilder builder = new SqlQueryBuilder(configuration.getDialect());
            Mono.from((Publisher)configuration.getConnectionFactory().create()).flatMap(arg_0 -> this.lambda$createSchema$4(configuration, schemaGenerate, (PersistentEntity[])entities, builder, arg_0)).block();
        }
    }

    private Mono<Void> generate(Connection connection, SchemaGenerate schemaGenerate, PersistentEntity[] entities, SqlQueryBuilder builder) {
        List createStatements = Arrays.stream(entities).flatMap(entity -> Arrays.stream(builder.buildCreateTableStatements(entity))).collect(Collectors.toList());
        Flux createTablesFlow = Flux.fromIterable(createStatements).concatMap(sql -> {
            if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                DataSettings.QUERY_LOG.debug("Creating Table: \n{}", sql);
            }
            return this.execute(connection, (String)sql).onErrorResume(throwable -> {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Unable to create table :{}", (Object)throwable.getMessage());
                }
                return Mono.empty();
            });
        });
        switch (schemaGenerate) {
            case CREATE_DROP: {
                List dropStatements = Arrays.stream(entities).flatMap(entity -> Arrays.stream(builder.buildDropTableStatements(entity))).collect(Collectors.toList());
                return Flux.fromIterable(dropStatements).concatMap(sql -> {
                    if (DataSettings.QUERY_LOG.isDebugEnabled()) {
                        DataSettings.QUERY_LOG.debug("Dropping Table: \n{}", sql);
                    }
                    return this.execute(connection, (String)sql).onErrorResume(throwable -> Mono.empty());
                }).thenMany((Publisher)createTablesFlow).then();
            }
        }
        return createTablesFlow.then();
    }

    private Mono<Void> execute(Connection connection, String sql) {
        return Flux.from((Publisher)connection.createStatement(sql).execute()).flatMap(result -> Flux.from((Publisher)result.getRowsUpdated())).collectList().then();
    }

    private /* synthetic */ Mono lambda$createSchema$4(DataR2dbcConfiguration configuration, SchemaGenerate schemaGenerate, PersistentEntity[] entities, SqlQueryBuilder builder, Connection connection) {
        Dialect dialect = configuration.getDialect();
        if (configuration.getSchemaGenerateNames() != null && !configuration.getSchemaGenerateNames().isEmpty()) {
            Mono result = Mono.empty();
            for (String schemaName : configuration.getSchemaGenerateNames()) {
                result = result.then(Mono.from(this.schemaHandler.createSchema(connection, dialect, schemaName))).then(Mono.from(this.schemaHandler.useSchema(connection, dialect, schemaName))).then(this.generate(connection, schemaGenerate, entities, builder));
            }
            return result.then(Mono.from((Publisher)connection.close()));
        }
        Mono result = Mono.empty();
        if (configuration.getSchemaGenerateName() != null) {
            result = Mono.from(this.schemaHandler.createSchema(connection, dialect, configuration.getSchemaGenerateName())).then(Mono.from(this.schemaHandler.useSchema(connection, dialect, configuration.getSchemaGenerateName())));
        }
        return result.then(this.generate(connection, schemaGenerate, entities, builder)).then(Mono.from((Publisher)connection.close()));
    }
}

