/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.mapper;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.Row;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ColumnNameR2dbcResultReader
implements ResultReader<Row, String> {
    private final ConversionService<?> conversionService;

    public ColumnNameR2dbcResultReader() {
        this(null);
    }

    public ColumnNameR2dbcResultReader(DataConversionService<?> conversionService) {
        this.conversionService = conversionService == null ? ConversionService.SHARED : conversionService;
    }

    public ConversionService<?> getConversionService() {
        return this.conversionService;
    }

    @Nullable
    public Object readDynamic(@NonNull Row resultSet, @NonNull String index, @NonNull DataType dataType) {
        switch (dataType) {
            case UUID: {
                return this.readUUID(resultSet, index);
            }
            case STRING: 
            case JSON: {
                return this.readString(resultSet, index);
            }
            case LONG: {
                return resultSet.get(index, Long.class);
            }
            case INTEGER: {
                Object o = resultSet.get(index);
                if (o == null) {
                    return null;
                }
                if (o instanceof Integer) {
                    return o;
                }
                if (o instanceof Number) {
                    return ((Number)o).intValue();
                }
                return this.convertRequired(o, Integer.class);
            }
            case BOOLEAN: {
                return resultSet.get(index, Boolean.class);
            }
            case BYTE: {
                return resultSet.get(index, Byte.class);
            }
            case TIMESTAMP: {
                LocalDateTime value = (LocalDateTime)resultSet.get(index, LocalDateTime.class);
                if (value == null) {
                    return null;
                }
                return this.convertRequired(value, Timestamp.class);
            }
            case DATE: {
                LocalDate dateValue = (LocalDate)resultSet.get(index, LocalDate.class);
                if (dateValue == null) {
                    return null;
                }
                return this.convertRequired(dateValue, java.util.Date.class);
            }
            case CHARACTER: {
                return this.readDynamic(resultSet, index, Character.class);
            }
            case FLOAT: {
                return this.readDynamic(resultSet, index, Float.class);
            }
            case SHORT: {
                return this.readDynamic(resultSet, index, Short.class);
            }
            case DOUBLE: {
                return resultSet.get(index, Double.class);
            }
            case BYTE_ARRAY: {
                return this.readBlob(resultSet, index);
            }
            case BIGDECIMAL: {
                return resultSet.get(index, BigDecimal.class);
            }
        }
        return this.getRequiredValue(resultSet, index, Object.class);
    }

    private byte[] readBlob(@NonNull Row resultSet, @NonNull String index) {
        try {
            return (byte[])resultSet.get(index, byte[].class);
        }
        catch (Exception exception) {
            Object o = resultSet.get(index);
            if (o == null) {
                return null;
            }
            if (o instanceof byte[]) {
                return null;
            }
            if (o instanceof ByteBuffer) {
                return ((ByteBuffer)o).array();
            }
            if (o instanceof Blob) {
                return ((ByteBuffer)Mono.from((Publisher)((Blob)o).stream()).block()).array();
            }
            return (byte[])this.convertRequired(o, byte[].class);
        }
    }

    private <T> T readDynamic(@NonNull Row resultSet, @NonNull String index, Class<T> type) {
        Object o = resultSet.get(index);
        if (o == null) {
            return null;
        }
        if (type.isInstance(o)) {
            return (T)o;
        }
        return (T)this.convertRequired(o, type);
    }

    public long readLong(Row resultSet, String name) {
        Long l = (Long)resultSet.get(name, Long.class);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    public char readChar(Row resultSet, String name) {
        Character character = (Character)resultSet.get(name, Character.class);
        if (character != null) {
            return character.charValue();
        }
        return '\u0000';
    }

    public java.util.Date readDate(Row resultSet, String name) {
        LocalDate localDate = (LocalDate)resultSet.get(name, LocalDate.class);
        if (localDate != null) {
            return Date.valueOf(localDate);
        }
        return null;
    }

    public java.util.Date readTimestamp(Row resultSet, String index) {
        LocalDateTime localDateTime = (LocalDateTime)resultSet.get(index, LocalDateTime.class);
        if (localDateTime != null) {
            return java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    @Nullable
    public String readString(Row resultSet, String name) {
        Object o = resultSet.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Clob) {
            Clob clob = (Clob)o;
            CharSequence charSequence = (CharSequence)Mono.from((Publisher)clob.stream()).block();
            return charSequence == null ? null : charSequence.toString();
        }
        try {
            return (String)resultSet.get(name, String.class);
        }
        catch (Exception exception) {
            return (String)this.convertRequired(o, String.class);
        }
    }

    public int readInt(Row resultSet, String name) {
        Integer l = (Integer)resultSet.get(name, Integer.class);
        if (l != null) {
            return l;
        }
        return 0;
    }

    public boolean readBoolean(Row resultSet, String name) {
        Boolean l = (Boolean)resultSet.get(name, Boolean.class);
        if (l != null) {
            return l;
        }
        return false;
    }

    public float readFloat(Row resultSet, String name) {
        Float l = (Float)resultSet.get(name, Float.class);
        if (l != null) {
            return l.floatValue();
        }
        return 0.0f;
    }

    public byte readByte(Row resultSet, String name) {
        Byte l = (Byte)resultSet.get(name, Byte.class);
        if (l != null) {
            return l;
        }
        return 0;
    }

    public short readShort(Row resultSet, String name) {
        Short l = (Short)resultSet.get(name, Short.class);
        if (l != null) {
            return l;
        }
        return 0;
    }

    public double readDouble(Row resultSet, String name) {
        Double l = (Double)resultSet.get(name, Double.class);
        if (l != null) {
            return l;
        }
        return 0.0;
    }

    public BigDecimal readBigDecimal(Row resultSet, String name) {
        return (BigDecimal)resultSet.get(name, BigDecimal.class);
    }

    public byte[] readBytes(Row resultSet, String name) {
        return (byte[])resultSet.get(name, byte[].class);
    }

    @Nullable
    public <T> T getRequiredValue(Row resultSet, String name, Class<T> type) throws DataAccessException {
        try {
            return (T)resultSet.get(name, type);
        }
        catch (ConversionErrorException | IllegalArgumentException e) {
            try {
                return (T)this.conversionService.convertRequired(resultSet.get(name), type);
            }
            catch (Exception exception) {
                throw this.exceptionForColumn(name, (Exception)e);
            }
        }
    }

    public boolean next(Row resultSet) {
        return false;
    }

    private DataAccessException exceptionForColumn(String name, Exception e) {
        return new DataAccessException("Error reading object for name [" + name + "] from result set: " + e.getMessage(), (Throwable)e);
    }
}

