/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.DataAnnotationUtils;
import io.micronaut.data.annotation.Insert;
import io.micronaut.data.annotation.Save;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaInsert;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.impl.MethodMatchSourcePersistentEntityCriteriaBuilderImpl;
import io.micronaut.data.processor.visitors.MatchFailedException;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.ProcessingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SaveMethodMatcher
extends AbstractMethodMatcher {
    public SaveMethodMatcher() {
        super(MethodNameParser.builder().match(QueryMatchId.PREFIX, "save", "persist", "store", "insert").tryMatch(QueryMatchId.ALL_OR_ONE, ALL_OR_ONE).tryMatchLastOccurrencePrefixed(QueryMatchId.RETURNING, null, "Returning").takeRest(QueryMatchId.PROJECTION).build());
    }

    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext) {
        if (matchContext.getMethodElement().hasStereotype(Insert.class) || matchContext.getMethodElement().hasStereotype(Save.class)) {
            if (matchContext.getRootEntity() == null) {
                matchContext.findImplicitRootEntity();
            }
            if (matchContext.getRootEntity() == null) {
                throw new ProcessingException((Element)matchContext.getMethodElement(), "Repository does not have a well-defined primary entity type");
            }
            return this.match(matchContext, List.of());
        }
        return super.match(matchContext);
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, List<MethodNameParser.Match> matches) {
        MethodElement methodElement = matchContext.getMethodElement();
        boolean producesAnEntity = TypeUtils.doesMethodProducesAnEntityIterableOfAnEntity(methodElement);
        if (!(TypeUtils.doesReturnVoid(methodElement) || TypeUtils.doesMethodProducesANumber(methodElement) || producesAnEntity)) {
            ClassElement producingItem = TypeUtils.getMethodProducingItemType(methodElement);
            throw new ProcessingException((Element)methodElement, "Unsupported return type for a save method: " + producingItem.getName());
        }
        boolean isReturning = matches.stream().anyMatch(m -> m.id() == QueryMatchId.RETURNING);
        if (isReturning && !producesAnEntity) {
            throw new ProcessingException((Element)methodElement, "Save method with a returning clause supports only entity/entities as a return type");
        }
        ParameterElement[] parameters = matchContext.getParameters();
        if (parameters.length == 0) {
            throw new ProcessingException((Element)methodElement, "Save method requires parameters");
        }
        if (matchContext.getParametersNotInRole().stream().allMatch(p -> TypeUtils.isIterableOfEntity(p.getGenericType()) || TypeUtils.isEntity(p.getGenericType()))) {
            return SaveMethodMatcher.saveEntity(matchContext, isReturning ? DataMethod.OperationType.INSERT_RETURNING : DataMethod.OperationType.INSERT);
        }
        return this.saveProperties();
    }

    public static MethodMatcher.MethodMatch saveEntity(MethodMatchContext matchContext, DataMethod.OperationType operationType) {
        return mc -> {
            ParameterElement[] parameters = mc.getParameters();
            ParameterElement entityParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isEntity(p.getGenericType())).findFirst().orElse(null);
            ParameterElement entitiesParameter = Arrays.stream(parameters).filter(p -> TypeUtils.isIterableOfEntity(p.getGenericType())).findFirst().orElse(null);
            if (entityParameter == null && entitiesParameter == null) {
                throw new MatchFailedException("Cannot implement save method for specified arguments and return type", (Element)mc.getMethodElement());
            }
            FindersUtils.InterceptorMatch entry = FindersUtils.resolveInterceptorTypeByOperationType(entityParameter != null, entitiesParameter != null, operationType, mc);
            MethodMatchInfo methodMatchInfo = new MethodMatchInfo(operationType, (TypedElement)entry.returnType(), entry.interceptor());
            if (!mc.supportsImplicitQueries()) {
                AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{mc.getRepositoryClass().getAnnotationMetadata(), mc.getAnnotationMetadata()});
                boolean encodeEntityParameters = !DataAnnotationUtils.hasJsonEntityRepresentationAnnotation((AnnotationMetadata)mc.getAnnotationMetadata());
                MethodMatchSourcePersistentEntityCriteriaBuilderImpl criteriaBuilder = new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext);
                PersistentEntityCriteriaInsert criteriaInsert = criteriaBuilder.createCriteriaInsert(mc.getRootEntity());
                if (operationType == DataMethod.OperationType.INSERT_RETURNING) {
                    criteriaInsert.setReturning();
                }
                QueryResult queryResult = criteriaInsert.build((AnnotationMetadata)annotationMetadataHierarchy, mc.getQueryBuilder());
                methodMatchInfo.encodeEntityParameters(encodeEntityParameters).queryResult(queryResult);
            }
            if (entitiesParameter != null) {
                methodMatchInfo.addParameterRole(entitiesParameter, "entities");
            }
            if (entityParameter != null) {
                methodMatchInfo.addParameterRole(entityParameter, "entity");
            }
            return methodMatchInfo;
        };
    }

    private MethodMatcher.MethodMatch saveProperties() {
        return new MethodMatcher.MethodMatch(){

            @Override
            public MethodMatchInfo buildMatchInfo(MethodMatchContext matchContext) {
                Collection values;
                Set names;
                List<ParameterElement> parameters = matchContext.getParametersNotInRole();
                SourcePersistentEntity rootEntity = matchContext.getRootEntity();
                ClassElement returnType = matchContext.getReturnType();
                if (TypeUtils.isReactiveOrFuture(returnType)) {
                    returnType = returnType.getFirstTypeArgument().orElse(null);
                }
                if (returnType == null || !TypeUtils.isNumber(returnType) && !rootEntity.getName().equals(returnType.getName())) {
                    throw new MatchFailedException("The return type of the save method must be the same as the root entity type: " + rootEntity.getName());
                }
                Set requiredProps = rootEntity.getPersistentProperties().stream().filter(this::isRequiredProperty).map(PersistentProperty::getName).collect(Collectors.toSet());
                Object[] parameterElements = rootEntity.getClassElement().getPrimaryConstructor().map(MethodElement::getParameters).orElse(null);
                HashMap<String, Object> constructorArgs = new HashMap<String, Object>(10);
                if (ArrayUtils.isNotEmpty((Object[])parameterElements)) {
                    for (Object parameterElement : parameterElements) {
                        constructorArgs.put(SaveMethodMatcher.this.getParameterValue((ParameterElement)parameterElement), parameterElement);
                    }
                }
                for (ParameterElement parameter : parameters) {
                    String name = SaveMethodMatcher.this.getParameterValue(parameter);
                    ClassElement type = parameter.getGenericType();
                    SourcePersistentProperty prop = rootEntity.getPropertyByName(name);
                    ParameterElement constructorArg = (ParameterElement)constructorArgs.get(name);
                    if (prop == null && constructorArg == null) {
                        throw new MatchFailedException("Cannot save with non-existent property or constructor argument: " + name);
                    }
                    if (prop != null) {
                        String typeName = prop.getTypeName();
                        if (!type.isAssignable(typeName) && !typeName.equals(type.getName())) {
                            throw new MatchFailedException("Type mismatch. Found parameter of type [" + type.getName() + "]. Required property of type: " + typeName);
                        }
                        requiredProps.remove(name);
                    } else {
                        ClassElement argType = constructorArg.getGenericType();
                        String typeName = argType.getName();
                        if (!type.isAssignable(typeName) && !typeName.equals(type.getName())) {
                            throw new MatchFailedException("Type mismatch. Found parameter of type [" + type.getName() + "]. Required constructor argument of: " + typeName);
                        }
                    }
                    constructorArgs.remove(name);
                }
                if (!requiredProps.isEmpty()) {
                    throw new MatchFailedException("Save method missing required properties: " + String.valueOf(requiredProps));
                }
                if (!constructorArgs.isEmpty() && CollectionUtils.isNotEmpty(names = (values = constructorArgs.values()).stream().filter(pe -> {
                    SourcePersistentProperty prop = rootEntity.getPropertyByName(pe.getName());
                    return prop != null && prop.isRequired() && !prop.getType().isPrimitive();
                }).map(p -> SaveMethodMatcher.this.getParameterValue((ParameterElement)p)).collect(Collectors.toSet()))) {
                    throw new MatchFailedException("Save method missing required constructor arguments: " + String.valueOf(names));
                }
                AnnotationMetadataHierarchy annotationMetadataHierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{matchContext.getRepositoryClass().getAnnotationMetadata(), matchContext.getAnnotationMetadata()});
                MethodMatchSourcePersistentEntityCriteriaBuilderImpl criteriaBuilder = new MethodMatchSourcePersistentEntityCriteriaBuilderImpl(matchContext);
                FindersUtils.InterceptorMatch e = FindersUtils.pickSaveOneInterceptor(matchContext, matchContext.getReturnType());
                boolean encodeEntityParameters = !DataAnnotationUtils.hasJsonEntityRepresentationAnnotation((AnnotationMetadata)matchContext.getAnnotationMetadata());
                return new MethodMatchInfo(DataMethod.OperationType.INSERT, (TypedElement)e.returnType(), e.interceptor()).encodeEntityParameters(encodeEntityParameters).queryResult(criteriaBuilder.createCriteriaInsert(matchContext.getRootEntity()).build((AnnotationMetadata)annotationMetadataHierarchy, matchContext.getQueryBuilder()));
            }

            private boolean isRequiredProperty(SourcePersistentProperty pp) {
                return pp.isRequired() && ClassUtils.getPrimitiveType((String)pp.getTypeName()).isEmpty();
            }
        };
    }

    private String getParameterValue(ParameterElement p) {
        return p.stringValue(Parameter.class).orElseGet(() -> ((ParameterElement)p).getName());
    }
}

