/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Embeddable;
import io.micronaut.data.annotation.GenerateJakartaDataMetamodel;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.model.Association;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.PackageElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.PackageElementVisitor;
import io.micronaut.inject.visitor.TypeElementQuery;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

@Internal
public class GenerateJakartaDataMetamodelVisitor
implements TypeElementVisitor<GenerateJakartaDataMetamodel, Object>,
PackageElementVisitor<GenerateJakartaDataMetamodel> {
    public void visitPackage(@NonNull PackageElement element, @NonNull VisitorContext context) throws ProcessingException {
        for (ClassElement classElement : context.getClassElements(element)) {
            this.visitClass(classElement, context);
        }
    }

    public Set<String> getSupportedAnnotationNames() {
        return super.getSupportedAnnotationNames();
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!element.hasAnnotation(MappedEntity.class) && !element.hasAnnotation(Embeddable.class)) {
            return;
        }
        SourcePersistentEntity sourcePersistentEntity = new SourcePersistentEntity(element, new Function<ClassElement, SourcePersistentEntity>(this){

            @Override
            public SourcePersistentEntity apply(ClassElement classElement) {
                return new SourcePersistentEntity(classElement, this);
            }
        });
        String metamodelClassName = "_" + element.getSimpleName();
        String packageName = element.getPackageName();
        Optional generatedFileOpt = context.visitGeneratedSourceFile(packageName, metamodelClassName, new Element[]{element});
        if (generatedFileOpt.isEmpty()) {
            return;
        }
        GeneratedFile generatedFile = (GeneratedFile)generatedFileOpt.get();
        try (Writer writer = generatedFile.openWriter();){
            String fieldName;
            SourcePersistentProperty persistentProperty;
            writer.write("package " + packageName + ";\n\n");
            writer.write("import jakarta.data.metamodel.*;\n");
            writer.write("import jakarta.annotation.Generated;\n\n");
            writer.write("@Generated(\"Generated by Micronaut Data\")\n");
            writer.write("@StaticMetamodel(" + element.getSimpleName() + ".class)\n");
            writer.write("public class " + metamodelClassName + " {\n\n");
            for (String name : sourcePersistentEntity.getPersistentPropertyNames()) {
                persistentProperty = sourcePersistentEntity.getPropertyByName(name);
                fieldName = persistentProperty.getName().toUpperCase();
                writer.write("    public static final String " + fieldName + " = \"" + persistentProperty.getName() + "\";\n");
            }
            writer.write("\n");
            for (String name : sourcePersistentEntity.getPersistentPropertyNames()) {
                persistentProperty = sourcePersistentEntity.getPropertyByName(name);
                fieldName = persistentProperty.getName();
                ClassElement propertyType = persistentProperty.getType();
                if (persistentProperty instanceof Association) {
                    writer.write("    public static final NavigableAttribute<" + element.getSimpleName() + ", " + propertyType.getName() + "> " + fieldName + " = NavigableAttribute.of(" + element.getSimpleName() + ".class, " + fieldName.toUpperCase() + ", " + propertyType.getName() + ".class);\n");
                    continue;
                }
                String attributeDeclaration = this.getAttributeDeclaration(element, propertyType);
                String initializer = this.getAttributeInitializer(element, propertyType, fieldName.toUpperCase());
                writer.write("    public static final " + attributeDeclaration + " " + fieldName + " = " + initializer + ";\n");
            }
            writer.write("\n}\n");
        }
        catch (IOException e) {
            context.fail("Failed to generate metamodel class: " + e.getMessage(), (Element)element);
        }
        catch (Exception e) {
            context.fail("Failed to access generated file writer: " + e.getMessage(), (Element)element);
        }
    }

    private String getAttributeDeclaration(ClassElement entityElement, ClassElement propertyType) {
        String type;
        String entityName = entityElement.getSimpleName();
        if (propertyType.isArray()) {
            return "BasicAttribute<" + entityName + ", " + this.toTypeString(propertyType) + ">";
        }
        return switch (type = this.getBoxedType(propertyType)) {
            case "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.math.BigInteger", "java.math.BigDecimal" -> "NumericAttribute<" + entityName + ", " + type + ">";
            case "java.time.LocalDate", "java.time.LocalDateTime", "java.time.LocalTime", "java.time.Year", "java.time.Instant" -> "TemporalAttribute<" + entityName + ", " + type + ">";
            case "java.lang.String" -> "TextAttribute<" + entityName + ">";
            case "java.lang.Boolean", "java.util.UUID" -> "ComparableAttribute<" + entityName + ", " + type + ">";
            default -> propertyType.isEnum() ? "ComparableAttribute<" + entityName + ", " + type + ">" : "BasicAttribute<" + entityName + ", " + type + ">";
        };
    }

    private String getBoxedType(ClassElement propertyType) {
        String type = propertyType.getName();
        if (propertyType.isPrimitive()) {
            if (propertyType.equals((Object)PrimitiveElement.BOOLEAN)) {
                return Boolean.class.getName();
            }
            if (propertyType.equals((Object)PrimitiveElement.INT)) {
                return Integer.class.getName();
            }
            if (propertyType.equals((Object)PrimitiveElement.CHAR)) {
                return Character.class.getName();
            }
            if (propertyType.equals((Object)PrimitiveElement.LONG)) {
                return Long.class.getName();
            }
            if (propertyType.equals((Object)PrimitiveElement.FLOAT)) {
                return Float.class.getName();
            }
            if (propertyType.equals((Object)PrimitiveElement.DOUBLE)) {
                return Double.class.getName();
            }
            if (propertyType.equals((Object)PrimitiveElement.BYTE)) {
                return Byte.class.getName();
            }
            if (propertyType.equals((Object)PrimitiveElement.SHORT)) {
                return Short.class.getName();
            }
        }
        return type;
    }

    private String toTypeString(ClassElement classElement) {
        if (classElement.isArray()) {
            return this.toTypeString(classElement.fromArray()) + "[]";
        }
        return classElement.getName();
    }

    private String getAttributeInitializer(ClassElement entityElement, ClassElement propertyType, String fieldNameConstant) {
        String entityName = entityElement.getSimpleName();
        String type = this.getBoxedType(propertyType);
        if (propertyType.isArray()) {
            return "BasicAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", " + this.toTypeString(propertyType) + ".class)";
        }
        return switch (type) {
            case "java.lang.Boolean" -> "ComparableAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", Boolean.class)";
            case "java.lang.Byte" -> "NumericAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", Byte.class)";
            case "java.lang.Short" -> "NumericAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", Short.class)";
            case "java.lang.Integer" -> "NumericAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", Integer.class)";
            case "java.lang.Long" -> "NumericAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", Long.class)";
            case "java.lang.Float" -> "NumericAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", Float.class)";
            case "java.lang.Double" -> "NumericAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", Double.class)";
            case "java.lang.String" -> "TextAttribute.of(" + entityName + ".class, " + fieldNameConstant + ")";
            case "java.math.BigInteger" -> "NumericAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", java.math.BigInteger.class)";
            case "java.math.BigDecimal" -> "NumericAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", java.math.BigDecimal.class)";
            case "java.time.LocalDate" -> "TemporalAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", java.time.LocalDate.class)";
            case "java.time.LocalDateTime" -> "TemporalAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", java.time.LocalDateTime.class)";
            case "java.time.LocalTime" -> "TemporalAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", java.time.LocalTime.class)";
            case "java.time.Year" -> "TemporalAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", java.time.Year.class)";
            case "java.time.Instant" -> "TemporalAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", java.time.Instant.class)";
            case "java.util.UUID" -> "ComparableAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", java.util.UUID.class)";
            default -> propertyType.isEnum() ? "ComparableAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", " + type + ".class)" : "BasicAttribute.of(" + entityName + ".class, " + fieldNameConstant + ", " + type + ".class)";
        };
    }

    public int getOrder() {
        return -100;
    }

    public TypeElementQuery query() {
        return TypeElementQuery.onlyClass();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }
}

