/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.IdExpression;
import io.micronaut.data.model.jpa.criteria.impl.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitable;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.selection.AggregateExpression;
import io.micronaut.data.model.jpa.criteria.impl.selection.AliasedSelection;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.processor.model.SourceAssociation;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentPropertyPath;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;

@Internal
final class QueryResultAnalyzer
implements SelectionVisitor {
    private String queryResultTypeName;

    QueryResultAnalyzer() {
    }

    public String getQueryResultTypeName() {
        return this.queryResultTypeName;
    }

    public void visit(Predicate predicate) {
    }

    public void visit(PersistentPropertyPath<?> persistentPropertyPath) {
        PersistentProperty persistentProperty = persistentPropertyPath.getProperty();
        if (persistentProperty instanceof SourceAssociation) {
            SourceAssociation sourceAssociation = (SourceAssociation)persistentProperty;
            this.queryResultTypeName = sourceAssociation.getAssociatedEntity().getType().getName();
        } else {
            this.queryResultTypeName = ((SourcePersistentPropertyPath)persistentPropertyPath).getProperty().getType().getName();
        }
    }

    public void visit(AliasedSelection<?> aliasedSelection) {
        ((SelectionVisitable)aliasedSelection.getSelection()).accept((SelectionVisitor)this);
    }

    public void visit(PersistentEntityRoot<?> entityRoot) {
        this.queryResultTypeName = ((SourcePersistentEntity)entityRoot.getPersistentEntity()).getType().getName();
    }

    public void visit(AggregateExpression<?, ?> aggregateExpression) {
        switch (aggregateExpression.getType()) {
            case COUNT: 
            case COUNT_DISTINCT: {
                this.queryResultTypeName = Long.class.getName();
                break;
            }
            case MAX: 
            case MIN: {
                this.queryResultTypeName = CriteriaUtils.requireProperty((Expression)aggregateExpression.getExpression()).getProperty().getTypeName();
                break;
            }
            case SUM: 
            case AVG: {
                ClassElement type = ((SourcePersistentProperty)CriteriaUtils.requireProperty((Expression)aggregateExpression.getExpression()).getProperty()).getType();
                if (aggregateExpression.getExpressionType() != null) {
                    this.queryResultTypeName = aggregateExpression.getExpressionType().getName();
                }
                if (TypeUtils.isNumber(type)) {
                    this.queryResultTypeName = Number.class.getName();
                    break;
                }
                this.queryResultTypeName = type.getName();
                break;
            }
        }
    }

    public void visit(CompoundSelection<?> compoundSelection) {
        if (compoundSelection.getCompoundSelectionItems().size() == 1) {
            compoundSelection.getCompoundSelectionItems().forEach(s -> ((SelectionVisitable)s).accept((SelectionVisitor)this));
        }
    }

    public void visit(LiteralExpression<?> literalExpression) {
        this.queryResultTypeName = literalExpression.getValue().getClass().getName();
    }

    public void visit(IdExpression<?, ?> idExpression) {
        SourcePersistentEntity persistentEntity = (SourcePersistentEntity)idExpression.getRoot().getPersistentEntity();
        if (persistentEntity.hasCompositeIdentity()) {
            throw new IllegalStateException("IdClass is unknown!");
        }
        this.queryResultTypeName = persistentEntity.getIdentity().getType().getName();
    }
}

