/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.intercept.FindByIdInterceptor;
import io.micronaut.data.intercept.FindOneInterceptor;
import io.micronaut.data.intercept.async.FindByIdAsyncInterceptor;
import io.micronaut.data.intercept.async.FindOneAsyncInterceptor;
import io.micronaut.data.intercept.reactive.FindByIdReactiveInterceptor;
import io.micronaut.data.intercept.reactive.FindOneReactiveInterceptor;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaBuilder;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.MethodNameParser;
import io.micronaut.data.processor.visitors.finders.QueryMatchId;
import io.micronaut.data.processor.visitors.finders.criteria.QueryCriteriaMethodMatch;
import io.micronaut.inject.ast.ClassElement;
import java.util.List;

@Internal
public final class FindMethodMatcher
extends AbstractMethodMatcher {
    public FindMethodMatcher() {
        super(MethodNameParser.builder().match(QueryMatchId.PREFIX, "find", "list", "get", "query", "retrieve", "read", "search").tryMatch(QueryMatchId.ALL_OR_ONE, ALL_OR_ONE).tryMatchPrefixedNumber(QueryMatchId.LIMIT, TOP_OR_FIRST).tryMatch(QueryMatchId.DISTINCT, "Distinct").tryMatchLast(QueryMatchId.FOR_UPDATE, "ForUpdate").tryMatchLastOccurrencePrefixed(QueryMatchId.ORDER, "Order property not specified!", ORDER_VARIATIONS).tryMatchFirstOccurrencePrefixed(QueryMatchId.PREDICATE, "By").tryMatchExactly(QueryMatchId.FIRST, "First").takeRest(QueryMatchId.PROJECTION).build());
    }

    @Override
    public MethodMatcher.MethodMatch match(MethodMatchContext matchContext, List<MethodNameParser.Match> matches) {
        return new QueryCriteriaMethodMatch(matches){
            boolean hasIdMatch;

            @Override
            protected <T> void apply(MethodMatchContext matchContext, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, SourcePersistentEntityCriteriaBuilder cb) {
                super.apply(matchContext, root, query, cb);
                if (query instanceof AbstractPersistentEntityCriteriaQuery) {
                    this.hasIdMatch = ((AbstractPersistentEntityCriteriaQuery)query).hasOnlyIdRestriction();
                }
            }

            @Override
            protected FindersUtils.InterceptorMatch resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
                FindersUtils.InterceptorMatch e = super.resolveReturnTypeAndInterceptor(matchContext);
                ClassElement interceptorType = e.interceptor();
                ClassElement queryResultType = e.returnType();
                if (this.isFindByIdQuery(matchContext, queryResultType)) {
                    if (interceptorType.isAssignable(FindOneInterceptor.class)) {
                        interceptorType = (ClassElement)matchContext.getVisitorContext().getClassElement(FindByIdInterceptor.class).orElseThrow();
                    } else if (interceptorType.isAssignable(FindOneAsyncInterceptor.class)) {
                        interceptorType = (ClassElement)matchContext.getVisitorContext().getClassElement(FindByIdAsyncInterceptor.class).orElseThrow();
                    } else if (interceptorType.isAssignable(FindOneReactiveInterceptor.class)) {
                        interceptorType = (ClassElement)matchContext.getVisitorContext().getClassElement(FindByIdReactiveInterceptor.class).orElseThrow();
                    }
                    return new FindersUtils.InterceptorMatch(queryResultType, interceptorType);
                }
                return e;
            }

            private boolean isFindByIdQuery(@NonNull MethodMatchContext matchContext, @NonNull ClassElement queryResultType) {
                return this.hasIdMatch && matchContext.supportsImplicitQueries() && queryResultType.getName().equals(matchContext.getRootEntity().getName()) && this.hasNoWhereAndJoinDeclaration(matchContext);
            }
        };
    }
}

