/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.spec;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractSpecificationMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.regex.Matcher;

@Internal
public class FindAllSpecificationMethodMatcher
extends AbstractSpecificationMethodMatcher {
    public FindAllSpecificationMethodMatcher() {
        super("get", "find", "search", "query");
    }

    @Override
    public int getOrder() {
        return -300;
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        if (TypeUtils.doesMethodProducesIterable(matchContext.getMethodElement()) && this.isCorrectParameters(matchContext.getMethodElement())) {
            if (this.isFirstParameterMicronautDataQuerySpecification(matchContext.getMethodElement())) {
                FindersUtils.InterceptorMatch e = FindersUtils.pickFindAllSpecInterceptor(matchContext, matchContext.getReturnType());
                return mc -> new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)e.returnType(), e.interceptor());
            }
            if (this.isFirstParameterSpringJpaSpecification(matchContext.getMethodElement())) {
                return mc -> new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)mc.getReturnType(), this.getInterceptorElement(mc, "io.micronaut.data.spring.jpa.intercept.FindAllSpecificationInterceptor"));
            }
            return mc -> {
                ClassElement classElement = this.getInterceptorElement(mc, "io.micronaut.data.jpa.repository.intercept.FindAllSpecificationInterceptor");
                return new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)mc.getReturnType(), classElement);
            };
        }
        return null;
    }

    private boolean isCorrectParameters(@NonNull MethodElement methodElement) {
        ParameterElement[] parameters = methodElement.getParameters();
        int len = parameters.length;
        return switch (len) {
            case 1 -> true;
            case 2 -> {
                if (parameters[1].getType().isAssignable("org.springframework.data.domain.Sort") || parameters[1].getType().isAssignable("io.micronaut.data.model.Sort")) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    protected boolean isMatchesParameters(MethodMatchContext matchContext) {
        return super.isMatchesParameters(matchContext) || this.isFirstParameterMicronautDataQuerySpecification(matchContext.getMethodElement());
    }
}

