/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.BinaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.FunctionExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.IdExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.UnaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.selection.AliasedSelection;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import io.micronaut.data.processor.model.SourceAssociation;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentPropertyPath;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import jakarta.persistence.criteria.Expression;

@Internal
final class QueryResultAnalyzer
implements SelectionVisitor {
    private String queryResultTypeName;

    QueryResultAnalyzer() {
    }

    public String getQueryResultTypeName() {
        return this.queryResultTypeName;
    }

    public void visit(PersistentPropertyPath<?> persistentPropertyPath) {
        PersistentProperty persistentProperty = persistentPropertyPath.getProperty();
        if (persistentProperty instanceof SourceAssociation) {
            SourceAssociation sourceAssociation = (SourceAssociation)persistentProperty;
            this.queryResultTypeName = sourceAssociation.getAssociatedEntity().getType().getName();
        } else {
            this.queryResultTypeName = ((SourcePersistentPropertyPath)persistentPropertyPath).getProperty().getType().getName();
        }
    }

    public void visit(AliasedSelection<?> aliasedSelection) {
        aliasedSelection.getSelection().visitSelection((SelectionVisitor)this);
    }

    public void visit(PersistentEntityRoot<?> entityRoot) {
        this.queryResultTypeName = ((SourcePersistentEntity)entityRoot.getPersistentEntity()).getType().getName();
    }

    public void visit(PersistentEntitySubquery<?> subquery) {
    }

    public void visit(UnaryExpression<?> unaryExpression) {
        switch (unaryExpression.getType()) {
            case COUNT: 
            case COUNT_DISTINCT: {
                this.queryResultTypeName = Long.class.getName();
                break;
            }
            case MAX: 
            case MIN: 
            case LOWER: 
            case UPPER: {
                this.queryResultTypeName = CriteriaUtils.requireProperty((Expression)unaryExpression.getExpression()).getProperty().getTypeName();
                break;
            }
            case SUM: 
            case AVG: {
                Expression expression = unaryExpression.getExpression();
                this.queryResultTypeName = unaryExpression.getExpressionType().getName();
                this.analyzeExpression(expression);
                break;
            }
        }
    }

    private void analyzeExpression(Expression<?> expression) {
        ClassElement type = ((SourcePersistentProperty)CriteriaUtils.requireProperty(expression).getProperty()).getType();
        this.queryResultTypeName = TypeUtils.isNumber(type) ? Number.class.getName() : type.getName();
    }

    public void visit(CompoundSelection<?> compoundSelection) {
        if (compoundSelection.getCompoundSelectionItems().size() == 1) {
            compoundSelection.getCompoundSelectionItems().forEach(s -> ((ISelection)s).visitSelection((SelectionVisitor)this));
        }
    }

    public void visit(LiteralExpression<?> literalExpression) {
        this.queryResultTypeName = literalExpression.getValue().getClass().getName();
    }

    public void visit(IdExpression<?, ?> idExpression) {
        SourcePersistentEntity persistentEntity = (SourcePersistentEntity)idExpression.getRoot().getPersistentEntity();
        if (persistentEntity.hasCompositeIdentity()) {
            throw new IllegalStateException("IdClass is unknown!");
        }
        this.queryResultTypeName = persistentEntity.getIdentity().getType().getName();
    }

    public void visit(BinaryExpression<?> binaryExpression) {
        this.queryResultTypeName = binaryExpression.getJavaType().getName();
    }

    public void visit(FunctionExpression<?> functionExpression) {
        this.queryResultTypeName = functionExpression.getJavaType().getName();
    }
}

