/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.mappers.spring;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class SpringTransactionalMapper
implements NamedAnnotationMapper {
    public final String getName() {
        return "org.springframework.transaction.annotation.Transactional";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        AnnotationValueBuilder builder = AnnotationValue.builder((String)"io.micronaut.transaction.annotation.TransactionalAdvice");
        annotation.stringValue().ifPresent(s -> {
            builder.value(s);
            builder.member("transactionManager", s);
        });
        Stream.of("propagation", "isolation", "transactionManager").forEach(member -> annotation.stringValue(member).ifPresent(s -> builder.member(member, s)));
        Stream.of("rollbackForClassName", "noRollbackForClassName").forEach(member -> builder.member(member, annotation.stringValues(member)));
        Stream.of("rollbackFor", "noRollbackFor").forEach(member -> builder.member(member, annotation.annotationClassValues(member)));
        annotation.intValue("timeout").ifPresent(integer -> builder.member("timeout", integer));
        annotation.booleanValue("readOnly").ifPresent(bool -> builder.member("readOnly", bool.booleanValue()));
        return Collections.singletonList(builder.build());
    }
}

