/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.spec;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractSpecificationMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Map;
import java.util.regex.Matcher;

@Internal
public class FindAllSpecificationMethodMatcher
extends AbstractSpecificationMethodMatcher {
    public FindAllSpecificationMethodMatcher() {
        super("get", "find", "search", "query");
    }

    @Override
    public int getOrder() {
        return -300;
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        if (TypeUtils.isValidFindAllReturnType(matchContext) && this.isCorrectParameters(matchContext.getMethodElement())) {
            if (this.isFirstParameterMicronautDataQuerySpecification(matchContext.getMethodElement())) {
                Map.Entry<ClassElement, ClassElement> e = FindersUtils.pickFindAllSpecInterceptor(matchContext, matchContext.getReturnType());
                return mc -> new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)e.getKey(), (ClassElement)e.getValue());
            }
            if (this.isFirstParameterSpringJpaSpecification(matchContext.getMethodElement())) {
                return mc -> new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)mc.getReturnType(), this.getInterceptorElement(mc, "io.micronaut.data.spring.jpa.intercept.FindAllSpecificationInterceptor"));
            }
            return mc -> new MethodMatchInfo(DataMethod.OperationType.QUERY, (TypedElement)mc.getReturnType(), this.getInterceptorElement(mc, "io.micronaut.data.jpa.repository.intercept.FindAllSpecificationInterceptor"));
        }
        return null;
    }

    private boolean isCorrectParameters(@NonNull MethodElement methodElement) {
        ParameterElement[] parameters = methodElement.getParameters();
        int len = parameters.length;
        switch (len) {
            case 1: {
                return true;
            }
            case 2: {
                return parameters[1].getType().isAssignable("org.springframework.data.domain.Sort") || parameters[1].getType().isAssignable("io.micronaut.data.model.Sort");
            }
        }
        return false;
    }

    @Override
    protected boolean isMatchesParameters(MethodMatchContext matchContext) {
        return super.isMatchesParameters(matchContext) || this.isFirstParameterMicronautDataQuerySpecification(matchContext.getMethodElement());
    }
}

