/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaDelete;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.criteria.SourcePersistentEntityCriteriaDelete;
import io.micronaut.data.processor.model.criteria.impl.SourcePersistentEntityRoot;
import io.micronaut.inject.ast.ClassElement;
import java.util.function.Function;

@Internal
final class SourcePersistentEntityCriteriaDeleteImpl<T>
extends AbstractPersistentEntityCriteriaDelete<T>
implements SourcePersistentEntityCriteriaDelete<T> {
    private final Function<ClassElement, SourcePersistentEntity> entityResolver;

    public SourcePersistentEntityCriteriaDeleteImpl(Function<ClassElement, SourcePersistentEntity> entityResolver, Class<T> root) {
        this.entityResolver = entityResolver;
    }

    @Override
    public PersistentEntityRoot<T> from(ClassElement entityClassElement) {
        return this.from(new SourcePersistentEntity(entityClassElement, this.entityResolver));
    }

    public PersistentEntityRoot<T> from(Class<T> entityClass) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public PersistentEntityRoot<T> from(PersistentEntity persistentEntity) {
        SourcePersistentEntityRoot newEntityRoot;
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        this.entityRoot = newEntityRoot = new SourcePersistentEntityRoot((SourcePersistentEntity)persistentEntity);
        return newEntityRoot;
    }
}

