/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MethodMatchInfo {
    private final TypedElement resultType;
    private final ClassElement interceptor;
    private Map<String, String> parameterRoles = new HashMap<String, String>(2);
    private boolean dto;
    private boolean optimisticLock;
    private QueryResult queryResult;
    private QueryResult countQueryResult;
    private boolean isRawQuery;
    private boolean encodeEntityParameters;

    public MethodMatchInfo(@Nullable TypedElement resultType, @Nullable ClassElement interceptor) {
        this.interceptor = interceptor;
        this.resultType = resultType;
    }

    public boolean isDto() {
        return this.dto;
    }

    public boolean isOptimisticLock() {
        return this.optimisticLock;
    }

    public void setOptimisticLock(boolean optimisticLock) {
        this.optimisticLock = optimisticLock;
    }

    public void addParameterRole(CharSequence role, String name) {
        this.parameterRoles.put(role.toString(), name);
    }

    public Map<String, String> getParameterRoles() {
        return Collections.unmodifiableMap(this.parameterRoles);
    }

    @Nullable
    public TypedElement getResultType() {
        return this.resultType;
    }

    @Nullable
    public ClassElement getRuntimeInterceptor() {
        return this.interceptor;
    }

    public MethodMatchInfo dto(boolean dto) {
        this.dto = dto;
        return this;
    }

    public MethodMatchInfo queryResult(QueryResult queryResult) {
        this.queryResult = queryResult;
        return this;
    }

    public MethodMatchInfo countQueryResult(QueryResult countQueryResult) {
        this.countQueryResult = countQueryResult;
        return this;
    }

    public MethodMatchInfo isRawQuery(boolean isRawQuery) {
        this.isRawQuery = isRawQuery;
        return this;
    }

    public MethodMatchInfo encodeEntityParameters(boolean encodeEntityParameters) {
        this.encodeEntityParameters = encodeEntityParameters;
        return this;
    }

    public MethodMatchInfo optimisticLock(boolean optimisticLock) {
        this.optimisticLock = optimisticLock;
        return this;
    }

    public ClassElement getInterceptor() {
        return this.interceptor;
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public QueryResult getCountQueryResult() {
        return this.countQueryResult;
    }

    public boolean isRawQuery() {
        return this.isRawQuery;
    }

    public boolean isEncodeEntityParameters() {
        return this.encodeEntityParameters;
    }

    public static enum OperationType {
        QUERY,
        UPDATE,
        DELETE,
        INSERT;

    }
}

