/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternMethodMatcher;
import io.micronaut.data.processor.visitors.finders.FindersUtils;
import io.micronaut.data.processor.visitors.finders.MethodMatcher;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.data.processor.visitors.finders.criteria.QueryCriteriaMethodMatch;
import io.micronaut.inject.ast.ClassElement;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;
import java.util.Map;
import java.util.regex.Matcher;

@Internal
public final class CountMethodMatcher
extends AbstractPatternMethodMatcher {
    public CountMethodMatcher() {
        super(true, "count");
    }

    @Override
    protected MethodMatcher.MethodMatch match(MethodMatchContext matchContext, Matcher matcher) {
        if (TypeUtils.isValidCountReturnType(matchContext)) {
            return new QueryCriteriaMethodMatch(matcher){

                @Override
                protected <T> String applyProjections(String querySequence, PersistentEntityRoot<T> root, PersistentEntityCriteriaQuery<T> query, PersistentEntityCriteriaBuilder cb) {
                    boolean distinct = false;
                    if (querySequence.startsWith("Distinct")) {
                        distinct = true;
                        querySequence = querySequence.substring("Distinct".length());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)querySequence)) {
                        Expression<?> propertyPath = this.getProperty(root, querySequence);
                        Expression count = distinct ? cb.countDistinct(propertyPath) : cb.count(propertyPath);
                        query.multiselect(new Selection[]{count});
                    } else {
                        Expression count = distinct ? cb.count(root) : cb.count(root);
                        query.multiselect(new Selection[]{count});
                    }
                    return "";
                }

                @Override
                protected Map.Entry<ClassElement, Class<? extends DataInterceptor>> resolveReturnTypeAndInterceptor(MethodMatchContext matchContext) {
                    return FindersUtils.pickCountInterceptor(matchContext, matchContext.getReturnType());
                }
            };
        }
        return null;
    }
}

