/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors;

import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.data.annotation.Index;
import io.micronaut.data.annotation.Indexes;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategies;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.Utils;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MappedEntityVisitor
implements TypeElementVisitor<MappedEntity, Object> {
    public static final int POSITION = 100;
    private final Map<String, SourcePersistentEntity> entityMap = new HashMap<String, SourcePersistentEntity>(50);
    private final Function<ClassElement, SourcePersistentEntity> entityResolver = new Function<ClassElement, SourcePersistentEntity>(){

        @Override
        public SourcePersistentEntity apply(ClassElement classElement) {
            return MappedEntityVisitor.this.entityMap.computeIfAbsent(classElement.getName(), s -> new SourcePersistentEntity(classElement, this));
        }
    };
    private final boolean mappedEntity;

    public MappedEntityVisitor() {
        this.mappedEntity = true;
    }

    MappedEntityVisitor(boolean mappedEntity) {
        this.mappedEntity = mappedEntity;
    }

    public int getOrder() {
        return 100;
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        SourcePersistentProperty version;
        SourcePersistentProperty[] compositeIdentities;
        NamingStrategy namingStrategy = this.resolveNamingStrategy(element);
        Optional targetName = element.stringValue(MappedEntity.class);
        SourcePersistentEntity entity = this.entityResolver.apply(element);
        if (this.isMappedEntity() && !targetName.isPresent()) {
            element.annotate(MappedEntity.class, builder -> {
                String mappedName = namingStrategy.mappedName((PersistentEntity)entity);
                builder.value(mappedName);
            });
        }
        Map<String, DataType> dataTypes = Utils.getConfiguredDataTypes(element);
        Map<String, String> dataConverters = Utils.getConfiguredDataConverters(element);
        Collection properties = entity.getPersistentProperties();
        List indexes = properties.stream().filter(x -> x.findAnnotation(Indexes.class).isPresent()).map(prop -> prop.findAnnotation(Index.class)).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
        if (!indexes.isEmpty()) {
            element.annotate(Indexes.class, builder -> builder.values(indexes.toArray(new AnnotationValue[0])));
        }
        for (PersistentProperty property : properties) {
            this.computeMappingDefaults(namingStrategy, property, dataTypes, dataConverters, context);
        }
        SourcePersistentProperty identity = entity.getIdentity();
        if (identity != null) {
            this.computeMappingDefaults(namingStrategy, identity, dataTypes, dataConverters, context);
        }
        if ((compositeIdentities = entity.getCompositeIdentity()) != null) {
            for (SourcePersistentProperty compositeIdentity : compositeIdentities) {
                this.computeMappingDefaults(namingStrategy, compositeIdentity, dataTypes, dataConverters, context);
            }
        }
        if ((version = entity.getVersion()) != null) {
            this.computeMappingDefaults(namingStrategy, version, dataTypes, dataConverters, context);
        }
    }

    private boolean isMappedEntity() {
        return this.mappedEntity;
    }

    private void computeMappingDefaults(NamingStrategy namingStrategy, PersistentProperty property, Map<String, DataType> dataTypes, Map<String, String> dataConverters, VisitorContext context) {
        ClassElement type;
        AnnotationMetadata annotationMetadata = property.getAnnotationMetadata();
        SourcePersistentProperty spp = (SourcePersistentProperty)property;
        PropertyElement propertyElement = spp.getPropertyElement();
        boolean isRelation = propertyElement.hasStereotype(Relation.class);
        DataType dataType = annotationMetadata.getValue(TypeDef.class, "type", DataType.class).orElse(null);
        String converter = annotationMetadata.stringValue(MappedProperty.class, "converter").orElseGet(() -> annotationMetadata.stringValue(TypeDef.class, "converter").orElse(null));
        if (Objects.equals(converter, Object.class.getName())) {
            converter = null;
        }
        if (converter == null) {
            type = propertyElement.getGenericType();
            converter = TypeUtils.resolveDataConverter(type, dataConverters);
        }
        if (converter != null) {
            if (isRelation) {
                context.fail("Relation cannot have converter specified", (Element)propertyElement);
                return;
            }
            if (dataType == null && (dataType = this.getDataTypeFromConverter(propertyElement.getGenericType(), converter, dataTypes, context)) == null) {
                context.fail("Cannot recognize proper data type. Please use @TypeDef to specify one", (Element)propertyElement);
                return;
            }
        } else {
            if (dataType == null && spp.getType().isEnum() && (spp.getOwner().getAnnotationMetadata().hasAnnotation("javax.persistence.Entity") || spp.getOwner().getAnnotationMetadata().hasAnnotation("jakarta.persistence.Entity"))) {
                dataType = DataType.INTEGER;
            }
            if (dataType == null) {
                type = propertyElement.getGenericType();
                dataType = TypeUtils.resolveDataType(type, dataTypes);
            }
        }
        if (dataType == DataType.ENTITY && !isRelation) {
            propertyElement = (PropertyElement)propertyElement.annotate(Relation.class, builder -> builder.value((Enum)Relation.Kind.MANY_TO_ONE));
        } else if (isRelation) {
            Relation.Kind kind = propertyElement.enumValue(Relation.class, Relation.Kind.class).orElse(Relation.Kind.MANY_TO_ONE);
            if ((kind == Relation.Kind.EMBEDDED || kind == Relation.Kind.MANY_TO_ONE) && propertyElement.stringValue(Relation.class, "mappedBy").isPresent()) {
                context.fail("Relation " + kind + " doesn't support 'mappedBy'.", (Element)propertyElement);
            }
            if (kind == Relation.Kind.EMBEDDED) {
                SourcePersistentEntity embeddedEntity = this.entityResolver.apply(propertyElement.getType());
                Collection persistentProperties = embeddedEntity.getPersistentProperties();
                ArrayList<AnnotationValue> embeddedProperties = new ArrayList<AnnotationValue>(persistentProperties.size());
                for (SourcePersistentProperty embeddedProperty : persistentProperties) {
                    if (embeddedProperty instanceof Association) continue;
                    String mappedName = embeddedProperty.stringValue(MappedProperty.class).orElseGet(() -> namingStrategy.mappedName(property.getName() + embeddedProperty.getCapitilizedName()));
                    AnnotationValue av = AnnotationValue.builder(Property.class).value(mappedName).member("name", embeddedProperty.getName()).build();
                    embeddedProperties.add(av);
                }
                propertyElement.annotate(MappedProperty.class, builder -> builder.member("embeddedProperties", embeddedProperties.toArray(new AnnotationValue[0])));
            }
        }
        Optional mapping = annotationMetadata.stringValue(MappedProperty.class);
        if (this.mappedEntity && !mapping.isPresent()) {
            propertyElement.annotate(MappedProperty.class, builder -> builder.value(namingStrategy.mappedName((PersistentProperty)spp)));
        }
        if (dataType != DataType.OBJECT) {
            DataType finalDataType = dataType;
            propertyElement.annotate(MappedProperty.class, builder -> builder.member("type", (Enum)finalDataType));
        }
        if (converter != null) {
            String finalConverter = converter;
            propertyElement.annotate(MappedProperty.class, builder -> builder.member("converter", new AnnotationClassValue[]{new AnnotationClassValue(finalConverter)}));
        }
    }

    private NamingStrategy resolveNamingStrategy(ClassElement element) {
        return element.stringValue(MappedEntity.class, "namingStrategy").flatMap(new Function<String, Optional<NamingStrategy>>(){

            @Override
            public Optional<NamingStrategy> apply(String s) {
                Object o = InstantiationUtils.tryInstantiate((String)s, (ClassLoader)this.getClass().getClassLoader()).orElse(null);
                if (o instanceof NamingStrategy) {
                    return Optional.of(o);
                }
                return Optional.empty();
            }
        }).orElseGet(NamingStrategies.UnderScoreSeparatedLowerCase::new);
    }

    private DataType getDataTypeFromConverter(ClassElement type, String converter, Map<String, DataType> dataTypes, VisitorContext context) {
        Optional explicitType;
        ClassElement entityElement;
        ClassElement classElement = (ClassElement)context.getClassElement(converter).get();
        ClassElement genericType = classElement.getGenericType();
        Map typeArguments = genericType.getTypeArguments(AttributeConverter.class.getName());
        if (typeArguments.isEmpty()) {
            typeArguments = genericType.getTypeArguments("javax.persistence.AttributeConverter");
        }
        if (typeArguments.isEmpty()) {
            typeArguments = genericType.getTypeArguments("jakarta.persistence.AttributeConverter");
        }
        if ((entityElement = (ClassElement)typeArguments.get("X")) != null && (explicitType = entityElement.getValue(TypeDef.class, "type", DataType.class)).isPresent()) {
            return (DataType)explicitType.get();
        }
        explicitType = type.getValue(TypeDef.class, "type", DataType.class);
        if (explicitType.isPresent()) {
            return (DataType)explicitType.get();
        }
        ClassElement dataTypeClassElement = (ClassElement)typeArguments.get("Y");
        if (dataTypeClassElement != null) {
            DataType dataType = TypeUtils.resolveDataType(dataTypeClassElement, dataTypes);
            if (dataType == DataType.OBJECT) {
                dataType = null;
            }
            return dataType;
        }
        return null;
    }
}

