/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.mappers.jpa.jx;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Indexes;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.processor.mappers.jpa.jx.IndexAnnotationMapper;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class TableAnnotationMapper
implements NamedAnnotationMapper {
    @NonNull
    public String getName() {
        return "javax.persistence.Table";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        IndexAnnotationMapper mapper = new IndexAnnotationMapper();
        AnnotationValueBuilder builder = AnnotationValue.builder(MappedEntity.class);
        annotation.stringValue("name").ifPresent(arg_0 -> ((AnnotationValueBuilder)builder).value(arg_0));
        annotation.stringValue("catalog").ifPresent(catalog -> builder.member("catalog", catalog));
        annotation.stringValue("schema").ifPresent(catalog -> builder.member("schema", catalog));
        AnnotationValueBuilder idxBuilder = AnnotationValue.builder(Indexes.class);
        Optional.ofNullable((AnnotationValue[])annotation.getValues().get("indexes")).ifPresent(indexes -> {
            AnnotationValue[] annotationValues = (AnnotationValue[])Arrays.stream(indexes).map(a -> mapper.map((AnnotationValue<Annotation>)a, null).get(0)).toArray(AnnotationValue[]::new);
            idxBuilder.member("value", annotationValues);
        });
        return Arrays.asList(builder.build(), idxBuilder.build());
    }
}

