/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.specification;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.specification.AbstractSpecificationMethod;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Optional;

@Internal
public class FindOneSpecificationMethod
extends AbstractSpecificationMethod {
    public static final String[] PREFIXES = new String[]{"get", "find", "search", "query"};

    public FindOneSpecificationMethod() {
        super(PREFIXES);
    }

    @Override
    public boolean isMethodMatch(@NonNull MethodElement methodElement, @NonNull MatchContext matchContext) {
        ClassElement returnType = matchContext.getReturnType();
        if (returnType.isAssignable(Optional.class)) {
            returnType = returnType.getFirstTypeArgument().orElse(returnType);
        }
        return super.isMethodMatch(methodElement, matchContext) && returnType.hasStereotype(MappedEntity.class);
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        if (this.isFirstParameterSpringJpaSpecification(matchContext.getMethodElement())) {
            return new MethodMatchInfo((TypedElement)matchContext.getReturnType(), null, this.getInterceptorElement(matchContext, "io.micronaut.data.spring.jpa.intercept.FindOneSpecificationInterceptor"));
        }
        return new MethodMatchInfo((TypedElement)matchContext.getReturnType(), null, this.getInterceptorElement(matchContext, "io.micronaut.data.jpa.repository.intercept.FindOneSpecificationInterceptor"));
    }
}

