/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders.specification;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.specification.AbstractSpecificationMethod;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;

@Internal
public class CountSpecificationMethod
extends AbstractSpecificationMethod {
    public static final String[] PREFIXES = new String[]{"count"};

    public CountSpecificationMethod() {
        super(PREFIXES);
    }

    @Override
    public boolean isMethodMatch(@NonNull MethodElement methodElement, @NonNull MatchContext matchContext) {
        ClassElement returnType = matchContext.getReturnType();
        return super.isMethodMatch(methodElement, matchContext) && (returnType.isPrimitive() || returnType.isAssignable(Number.class));
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        if (this.isFirstParameterSpringJpaSpecification(matchContext.getMethodElement())) {
            return new MethodMatchInfo((TypedElement)matchContext.getReturnType(), null, this.getInterceptorElement(matchContext, "io.micronaut.data.spring.jpa.intercept.CountSpecificationInterceptor"));
        }
        return new MethodMatchInfo((TypedElement)matchContext.getReturnType(), null, this.getInterceptorElement(matchContext, "io.micronaut.data.jpa.repository.intercept.CountSpecificationInterceptor"));
    }
}

