/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.model;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Embeddable;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Transient;
import io.micronaut.data.annotation.Version;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.AbstractPersistentEntity;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.processor.model.SourceAssociation;
import io.micronaut.data.processor.model.SourceEmbedded;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Internal
public class SourcePersistentEntity
extends AbstractPersistentEntity
implements PersistentEntity,
TypedElement {
    private final ClassElement classElement;
    private final SourcePersistentProperty[] ids;
    private final SourcePersistentProperty version;
    private final Map<String, SourcePersistentProperty> persistentProperties;
    private final Map<String, SourcePersistentProperty> allPersistentProperties;
    private List<String> allPersistentPropertiesNames;
    private List<SourcePersistentProperty> persistentPropertiesValues;

    public SourcePersistentEntity(@NonNull ClassElement classElement, @NonNull Function<ClassElement, SourcePersistentEntity> entityResolver) {
        super((AnnotationMetadataProvider)classElement);
        this.classElement = classElement;
        List beanProperties = classElement.getBeanProperties();
        this.allPersistentProperties = new LinkedHashMap<String, SourcePersistentProperty>(beanProperties.size());
        this.persistentProperties = new LinkedHashMap<String, SourcePersistentProperty>(beanProperties.size());
        ArrayList<SourcePersistentProperty> ids = new ArrayList<SourcePersistentProperty>(2);
        SourcePersistentProperty version = null;
        for (PropertyElement propertyElement : beanProperties) {
            SourcePersistentProperty prop;
            if (propertyElement.getName().equals("metaClass") || propertyElement.hasStereotype(Transient.class)) continue;
            if (propertyElement.hasStereotype(Id.class)) {
                SourcePersistentProperty id = this.isEmbedded(propertyElement) ? new SourceEmbedded(this, propertyElement, entityResolver) : new SourcePersistentProperty(this, propertyElement);
                ids.add(id);
                this.allPersistentProperties.put(id.getName(), id);
                continue;
            }
            if (propertyElement.hasStereotype(Version.class)) {
                version = new SourcePersistentProperty(this, propertyElement);
                this.allPersistentProperties.put(version.getName(), version);
                continue;
            }
            if (propertyElement.hasAnnotation(Relation.class)) {
                if (this.isEmbedded(propertyElement)) {
                    if (!propertyElement.getType().hasStereotype(Embeddable.class)) {
                        throw new MappingException("Type [" + propertyElement.getType().getName() + "] of property [" + propertyElement.getName() + "] of entity [" + this.getName() + "] is missing @Embeddable annotation. @Embedded fields can only be applied to types annotated with @Embeddable");
                    }
                    prop = new SourceEmbedded(this, propertyElement, entityResolver);
                } else {
                    prop = new SourceAssociation(this, propertyElement, entityResolver);
                }
            } else {
                prop = new SourcePersistentProperty(this, propertyElement);
                if (prop.getDataType() == DataType.ENTITY) {
                    prop = new SourceAssociation(this, propertyElement, entityResolver);
                }
            }
            this.allPersistentProperties.put(prop.getName(), prop);
            this.persistentProperties.put(prop.getName(), prop);
        }
        this.ids = (SourcePersistentProperty[])ids.stream().toArray(SourcePersistentProperty[]::new);
        this.version = version;
    }

    @NonNull
    public String getName() {
        return this.classElement.getName();
    }

    public String getSimpleName() {
        return this.classElement.getSimpleName();
    }

    public boolean isProtected() {
        return this.classElement.isProtected();
    }

    public boolean isPublic() {
        return this.classElement.isPublic();
    }

    public Object getNativeType() {
        return this.classElement.getNativeType();
    }

    public boolean hasCompositeIdentity() {
        return this.ids.length > 1;
    }

    public boolean hasIdentity() {
        return this.ids.length == 1;
    }

    @Nullable
    public SourcePersistentProperty[] getCompositeIdentity() {
        return this.ids.length > 1 ? this.ids : null;
    }

    @Nullable
    public SourcePersistentProperty getIdentity() {
        return this.ids.length == 1 ? this.ids[0] : null;
    }

    @Nullable
    public SourcePersistentProperty getVersion() {
        return this.version;
    }

    @NonNull
    public List<SourcePersistentProperty> getPersistentProperties() {
        if (this.persistentPropertiesValues == null) {
            this.persistentPropertiesValues = Collections.unmodifiableList(new ArrayList<SourcePersistentProperty>(this.persistentProperties.values()));
        }
        return this.persistentPropertiesValues;
    }

    @Nullable
    public SourcePersistentProperty getPropertyByName(String name) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return this.allPersistentProperties.get(name);
        }
        return null;
    }

    @Nullable
    public SourcePersistentProperty getIdentityByName(String name) {
        return (SourcePersistentProperty)super.getIdentityByName(name);
    }

    public SourcePersistentProperty getIdOrVersionPropertyByName(String name) {
        SourcePersistentProperty persistentProp;
        if (ArrayUtils.isNotEmpty((Object[])this.ids) && (persistentProp = (SourcePersistentProperty)Arrays.stream(this.ids).filter(p -> p.getName().equals(name)).findFirst().orElse(null)) != null) {
            return persistentProp;
        }
        if (this.version != null && this.version.getName().equals(name)) {
            return this.version;
        }
        return null;
    }

    @NonNull
    public List<String> getPersistentPropertyNames() {
        if (this.allPersistentPropertiesNames == null) {
            this.allPersistentPropertiesNames = Collections.unmodifiableList(new ArrayList<String>(this.allPersistentProperties.keySet()));
        }
        return this.allPersistentPropertiesNames;
    }

    public boolean isOwningEntity(PersistentEntity owner) {
        return true;
    }

    @Nullable
    public PersistentEntity getParentEntity() {
        return null;
    }

    public ClassElement getClassElement() {
        return this.classElement;
    }

    @NonNull
    public ClassElement getType() {
        return this.classElement;
    }

    private boolean isEmbedded(PropertyElement bp) {
        return bp.enumValue(Relation.class, Relation.Kind.class).orElse(null) == Relation.Kind.EMBEDDED;
    }

    public String toString() {
        return this.getName();
    }
}

