/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.visitors.finders;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.data.annotation.Id;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.UpdateInterceptor;
import io.micronaut.data.intercept.async.UpdateAsyncInterceptor;
import io.micronaut.data.intercept.reactive.UpdateReactiveInterceptor;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.processor.model.SourcePersistentEntity;
import io.micronaut.data.processor.model.SourcePersistentProperty;
import io.micronaut.data.processor.visitors.MatchContext;
import io.micronaut.data.processor.visitors.MethodMatchContext;
import io.micronaut.data.processor.visitors.finders.AbstractPatternBasedMethod;
import io.micronaut.data.processor.visitors.finders.MethodMatchInfo;
import io.micronaut.data.processor.visitors.finders.TypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UpdateMethod
extends AbstractPatternBasedMethod {
    public UpdateMethod() {
        super(Pattern.compile("^update\\w*$"));
    }

    @Override
    @NonNull
    protected MethodMatchInfo.OperationType getOperationType() {
        return MethodMatchInfo.OperationType.UPDATE;
    }

    @Override
    public boolean isMethodMatch(MethodElement methodElement, MatchContext matchContext) {
        return super.isMethodMatch(methodElement, matchContext) && methodElement.getParameters().length > 1 && TypeUtils.isValidBatchUpdateReturnType(methodElement) && this.hasIdParameter(methodElement.getParameters());
    }

    private boolean hasIdParameter(ParameterElement[] parameters) {
        return Arrays.stream(parameters).anyMatch(p -> p.hasAnnotation(Id.class));
    }

    @Override
    @Nullable
    public MethodMatchInfo buildMatchInfo(@NonNull MethodMatchContext matchContext) {
        String idParameterType;
        ParameterElement[] parameters = matchContext.getMethodElement().getParameters();
        List remainingParameters = Arrays.stream(parameters).filter(p -> !p.hasAnnotation(Id.class)).collect(Collectors.toList());
        ParameterElement idParameter = Arrays.stream(parameters).filter(p -> p.hasAnnotation(Id.class)).findFirst().orElse(null);
        if (idParameter == null) {
            matchContext.fail("ID required for update method, but not specified");
            return null;
        }
        SourcePersistentEntity entity = matchContext.getRootEntity();
        SourcePersistentProperty identity = entity.getIdentity();
        if (identity == null) {
            matchContext.fail("Cannot update by ID for entity that has no ID");
            return null;
        }
        String idType = TypeUtils.getTypeName(identity.getType());
        if (!idType.equals(idParameterType = TypeUtils.getTypeName(idParameter.getType()))) {
            matchContext.fail("ID type of method [" + idParameterType + "] does not match ID type of entity: " + idType);
        }
        QueryModel query = QueryModel.from((PersistentEntity)entity);
        query.idEq(new QueryParameter(idParameter.getName()));
        ArrayList<String> properiesToUpdate = new ArrayList<String>(remainingParameters.size());
        for (ParameterElement parameter : remainingParameters) {
            String name = parameter.stringValue(Parameter.class).orElse(parameter.getName());
            SourcePersistentProperty prop = entity.getPropertyByName(name);
            if (prop == null) {
                matchContext.fail("Cannot update non-existent property: " + name);
                return null;
            }
            if (prop.isGenerated()) {
                matchContext.fail("Cannot update a generated property: " + name);
                return null;
            }
            properiesToUpdate.add(name);
        }
        Element element = matchContext.getParametersInRole().get("lastUpdatedProperty");
        if (element instanceof PropertyElement) {
            properiesToUpdate.add(element.getName());
        }
        ClassElement returnType = matchContext.getReturnType();
        Class<? extends DataInterceptor> interceptor = UpdateMethod.pickUpdateInterceptor(returnType);
        if (TypeUtils.isReactiveOrFuture(returnType)) {
            returnType = returnType.getGenericType().getFirstTypeArgument().orElse(returnType);
        }
        MethodMatchInfo info = new MethodMatchInfo((TypedElement)returnType, query, this.getInterceptorElement(matchContext, interceptor), MethodMatchInfo.OperationType.UPDATE, properiesToUpdate.toArray(new String[0]));
        info.addParameterRole("id", idParameter.getName());
        return info;
    }

    static Class<? extends DataInterceptor> pickUpdateInterceptor(ClassElement returnType) {
        Class interceptor = TypeUtils.isFutureType(returnType) ? UpdateAsyncInterceptor.class : (TypeUtils.isReactiveType(returnType) ? UpdateReactiveInterceptor.class : UpdateInterceptor.class);
        return interceptor;
    }
}

