/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.processor.mappers.spring;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class SpringTransactionalMapper
implements NamedAnnotationMapper {
    public final String getName() {
        return "org.springframework.transaction.annotation.Transactional";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        boolean springManagement = visitorContext.getClassElement("io.micronaut.spring.tx.annotation.Transactional").isPresent();
        AnnotationValueBuilder builder = AnnotationValue.builder((String)(springManagement ? "io.micronaut.spring.tx.annotation.Transactional" : "io.micronaut.transaction.annotation.TransactionalAdvice"));
        annotation.getValue(String.class).ifPresent(s -> {
            builder.value(s);
            builder.member("transactionManager", s);
        });
        Stream.of("propagation", "isolation", "transactionManager").forEach(member -> annotation.get((CharSequence)member, String.class).ifPresent(s -> builder.member(member, s)));
        Stream.of("rollbackForClassName", "noRollbackForClassName").forEach(member -> annotation.get((CharSequence)member, String[].class).ifPresent(s -> builder.member(member, s)));
        Stream.of("rollbackFor", "noRollbackFor").forEach(member -> annotation.get((CharSequence)member, AnnotationClassValue[].class).ifPresent(classValues -> {
            String[] names = new String[((AnnotationClassValue[])classValues).length];
            for (int i = 0; i < ((AnnotationClassValue[])classValues).length; ++i) {
                AnnotationClassValue classValue = classValues[i];
                names[i] = classValue.getName();
            }
            builder.member(member, names);
        }));
        annotation.get((CharSequence)"timeout", Integer.class).ifPresent(integer -> builder.member("timeout", integer.intValue()));
        annotation.get((CharSequence)"readOnly", Boolean.class).ifPresent(bool -> builder.member("readOnly", bool.booleanValue()));
        return Collections.singletonList(builder.build());
    }
}

