/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.serde;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.AbstractPropertyReferenceManager;
import io.micronaut.serde.reference.PropertyReference;
import io.micronaut.serde.reference.SerializationReference;
import org.jspecify.annotations.Nullable;

@Internal
class DefaultEncoderContext
extends AbstractPropertyReferenceManager
implements Serializer.EncoderContext {
    private final SerdeRegistry registry;

    DefaultEncoderContext(SerdeRegistry registry) {
        this.registry = registry;
    }

    public final <T, D extends Serializer<? extends T>> D findCustomSerializer(Class<? extends D> serializerClass) throws SerdeException {
        return (D)this.registry.findCustomSerializer(serializerClass);
    }

    public final <T> Serializer<? super T> findSerializer(Argument<? extends T> forType) throws SerdeException {
        return this.registry.findSerializer(forType);
    }

    public <D extends PropertyNamingStrategy> D findNamingStrategy(Class<? extends D> namingStrategyClass) throws SerdeException {
        return (D)this.registry.findNamingStrategy(namingStrategyClass);
    }

    public <B, P> @Nullable SerializationReference<B, P> resolveReference(SerializationReference<B, P> reference) {
        PropertyReference managedReference;
        Object value = reference.getReference();
        if (this.refs != null && (managedReference = (PropertyReference)this.refs.peekFirst()) != null && managedReference.getProperty().getName().equals(reference.getReferenceName()) && managedReference.getReference() == value) {
            return null;
        }
        return reference;
    }
}

