/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations.options;

import com.mongodb.CursorType;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.mongodb.annotation.MongoAggregateOptions;
import io.micronaut.data.mongodb.annotation.MongoCollation;
import io.micronaut.data.mongodb.annotation.MongoDeleteOptions;
import io.micronaut.data.mongodb.annotation.MongoUpdateOptions;
import io.micronaut.data.mongodb.operations.options.MongoAggregationOptions;
import io.micronaut.data.mongodb.operations.options.MongoFindOptions;
import java.util.Arrays;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.jspecify.annotations.Nullable;

@Internal
public final class MongoOptionsUtils {
    private MongoOptionsUtils() {
    }

    public static Optional<UpdateOptions> buildUpdateOptions(AnnotationMetadata annotationMetadata, boolean includeCollation) {
        AnnotationValue optionsAnn = annotationMetadata.getAnnotation(MongoUpdateOptions.class);
        if (optionsAnn == null) {
            return Optional.empty();
        }
        UpdateOptions options = new UpdateOptions();
        optionsAnn.booleanValue("upsert").ifPresent(arg_0 -> ((UpdateOptions)options).upsert(arg_0));
        optionsAnn.booleanValue("bypassDocumentValidation").ifPresent(arg_0 -> ((UpdateOptions)options).bypassDocumentValidation(arg_0));
        optionsAnn.stringValue("hint").map(BsonDocument::parse).ifPresent(arg_0 -> ((UpdateOptions)options).hint(arg_0));
        String[] arrayFilters = optionsAnn.stringValues("arrayFilters");
        if (arrayFilters.length > 0) {
            options.arrayFilters(Arrays.stream(arrayFilters).map(BsonDocument::parse).toList());
        }
        if (includeCollation) {
            annotationMetadata.stringValue(MongoCollation.class).map(BsonDocument::parse).ifPresent(bsonDocument -> options.collation(MongoOptionsUtils.bsonDocumentAsCollation(bsonDocument)));
        }
        return Optional.of(options);
    }

    public static Optional<ReplaceOptions> buildReplaceOptions(AnnotationMetadata annotationMetadata) {
        AnnotationValue optionsAnn = annotationMetadata.getAnnotation(MongoUpdateOptions.class);
        if (optionsAnn == null) {
            return Optional.empty();
        }
        ReplaceOptions options = new ReplaceOptions();
        optionsAnn.booleanValue("upsert").ifPresent(arg_0 -> ((ReplaceOptions)options).upsert(arg_0));
        optionsAnn.booleanValue("bypassDocumentValidation").ifPresent(arg_0 -> ((ReplaceOptions)options).bypassDocumentValidation(arg_0));
        optionsAnn.stringValue("hint").map(BsonDocument::parse).ifPresent(arg_0 -> ((ReplaceOptions)options).hint(arg_0));
        annotationMetadata.stringValue(MongoCollation.class).map(BsonDocument::parse).ifPresent(bsonDocument -> options.collation(MongoOptionsUtils.bsonDocumentAsCollation(bsonDocument)));
        return Optional.of(options);
    }

    public static Optional<InsertOneOptions> buildInsertOneOptions(AnnotationMetadata annotationMetadata) {
        return Optional.empty();
    }

    public static Optional<InsertManyOptions> buildInsertManyOptions(AnnotationMetadata annotationMetadata) {
        return Optional.empty();
    }

    public static Optional<MongoFindOptions> buildFindOptions(AnnotationMetadata annotationMetadata) {
        AnnotationValue optionsAnn = annotationMetadata.getAnnotation(io.micronaut.data.mongodb.annotation.MongoFindOptions.class);
        if (optionsAnn == null) {
            return Optional.empty();
        }
        MongoFindOptions options = new MongoFindOptions();
        optionsAnn.intValue("batchSize").ifPresent(options::batchSize);
        optionsAnn.intValue("skip").ifPresent(options::skip);
        optionsAnn.intValue("limit").ifPresent(options::limit);
        optionsAnn.longValue("maxTimeMS").ifPresent(options::maxTimeMS);
        optionsAnn.longValue("maxAwaitTimeMS").ifPresent(options::maxAwaitTimeMS);
        optionsAnn.enumValue("cursorType", CursorType.class).ifPresent(options::cursorType);
        optionsAnn.booleanValue("noCursorTimeout").ifPresent(options::noCursorTimeout);
        optionsAnn.booleanValue("partial").ifPresent(options::partial);
        optionsAnn.stringValue("comment").ifPresent(options::comment);
        optionsAnn.stringValue("hint").map(BsonDocument::parse).ifPresent(options::hint);
        optionsAnn.stringValue("max").map(BsonDocument::parse).ifPresent(options::max);
        optionsAnn.stringValue("min").map(BsonDocument::parse).ifPresent(options::min);
        optionsAnn.booleanValue("returnKey").ifPresent(options::returnKey);
        optionsAnn.booleanValue("showRecordId").ifPresent(options::showRecordId);
        optionsAnn.booleanValue("allowDiskUse").ifPresent(options::allowDiskUse);
        if (options.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(options);
    }

    public static Optional<MongoAggregationOptions> buildAggregateOptions(AnnotationMetadata annotationMetadata) {
        AnnotationValue optionsAnn = annotationMetadata.getAnnotation(MongoAggregateOptions.class);
        if (optionsAnn == null) {
            return Optional.empty();
        }
        MongoAggregationOptions options = new MongoAggregationOptions();
        optionsAnn.booleanValue("bypassDocumentValidation").ifPresent(options::bypassDocumentValidation);
        optionsAnn.longValue("maxTimeMS").ifPresent(options::maxTimeMS);
        optionsAnn.longValue("maxAwaitTimeMS").ifPresent(options::maxAwaitTimeMS);
        optionsAnn.stringValue("comment").ifPresent(options::comment);
        optionsAnn.stringValue("hint").map(BsonDocument::parse).ifPresent(options::hint);
        optionsAnn.booleanValue("allowDiskUse").ifPresent(options::allowDiskUse);
        if (options.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(options);
    }

    public static Optional<DeleteOptions> buildDeleteOptions(AnnotationMetadata annotationMetadata, boolean includeCollation) {
        AnnotationValue optionsAnn = annotationMetadata.getAnnotation(MongoDeleteOptions.class);
        if (optionsAnn == null) {
            return Optional.empty();
        }
        DeleteOptions options = new DeleteOptions();
        optionsAnn.stringValue("hint").map(BsonDocument::parse).ifPresent(arg_0 -> ((DeleteOptions)options).hint(arg_0));
        annotationMetadata.stringValue(MongoCollation.class).map(BsonDocument::parse).ifPresent(bsonDocument -> options.collation(MongoOptionsUtils.bsonDocumentAsCollation(bsonDocument)));
        return Optional.of(options);
    }

    public static @Nullable Collation bsonDocumentAsCollation(@Nullable BsonDocument collationDocument) {
        BsonValue backwards;
        BsonValue normalization;
        BsonValue maxVariable;
        BsonValue alternate;
        BsonValue numericOrdering;
        BsonValue strength;
        BsonValue caseFirst;
        BsonValue caseLevel;
        if (collationDocument == null) {
            return null;
        }
        Collation.Builder builder = Collation.builder();
        BsonValue locale = collationDocument.get((Object)"locale");
        if (locale != null) {
            builder.locale(locale.asString().getValue());
        }
        if ((caseLevel = collationDocument.get((Object)"caseLevel")) != null) {
            builder.caseLevel(Boolean.valueOf(caseLevel.asBoolean().getValue()));
        }
        if ((caseFirst = collationDocument.get((Object)"caseFirst")) != null) {
            builder.collationCaseFirst(CollationCaseFirst.valueOf((String)caseFirst.asString().getValue()));
        }
        if ((strength = collationDocument.get((Object)"strength")) != null) {
            builder.collationStrength(CollationStrength.valueOf((String)strength.asString().getValue()));
        }
        if ((numericOrdering = collationDocument.get((Object)"numericOrdering")) != null) {
            builder.numericOrdering(Boolean.valueOf(numericOrdering.asBoolean().getValue()));
        }
        if ((alternate = collationDocument.get((Object)"alternate")) != null) {
            builder.collationAlternate(CollationAlternate.valueOf((String)alternate.asString().getValue()));
        }
        if ((maxVariable = collationDocument.get((Object)"maxVariable")) != null) {
            builder.collationMaxVariable(CollationMaxVariable.valueOf((String)maxVariable.asString().getValue()));
        }
        if ((normalization = collationDocument.get((Object)"normalization")) != null) {
            builder.normalization(Boolean.valueOf(normalization.asBoolean().getValue()));
        }
        if ((backwards = collationDocument.get((Object)"backwards")) != null) {
            builder.backwards(Boolean.valueOf(backwards.asBoolean().getValue()));
        }
        return builder.build();
    }
}

