/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations.options;

import com.mongodb.CursorType;
import com.mongodb.client.model.Collation;
import org.bson.conversions.Bson;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

@NullUnmarked
public final class MongoFindOptions {
    private Bson filter;
    private Integer batchSize;
    private Integer limit;
    private Bson projection;
    private Long maxTimeMS;
    private Long maxAwaitTimeMS;
    private Integer skip;
    private Bson sort;
    private CursorType cursorType;
    private Boolean noCursorTimeout;
    private Boolean partial;
    private Collation collation;
    private String comment;
    private Bson hint;
    private Bson max;
    private Bson min;
    private Boolean returnKey;
    private Boolean showRecordId;
    private Boolean allowDiskUse;

    public MongoFindOptions() {
    }

    public MongoFindOptions(MongoFindOptions options) {
        this.filter = options.filter;
        this.batchSize = options.batchSize;
        this.limit = options.limit;
        this.projection = options.projection;
        this.maxTimeMS = options.maxTimeMS;
        this.maxAwaitTimeMS = options.maxAwaitTimeMS;
        this.skip = options.skip;
        this.sort = options.sort;
        this.cursorType = options.cursorType;
        this.noCursorTimeout = options.noCursorTimeout;
        this.partial = options.partial;
        this.collation = options.collation;
        this.comment = options.comment;
        this.hint = options.hint;
        this.max = options.max;
        this.min = options.min;
        this.returnKey = options.returnKey;
        this.showRecordId = options.showRecordId;
        this.allowDiskUse = options.allowDiskUse;
    }

    public void copyNotNullFrom(MongoFindOptions options) {
        if (options.filter != null) {
            this.filter = options.filter;
        }
        if (options.batchSize != null) {
            this.batchSize = options.batchSize;
        }
        if (options.limit != null) {
            this.limit = options.limit;
        }
        if (options.projection != null) {
            this.projection = options.projection;
        }
        if (options.maxTimeMS != null) {
            this.maxTimeMS = options.maxTimeMS;
        }
        if (options.maxAwaitTimeMS != null) {
            this.maxAwaitTimeMS = options.maxAwaitTimeMS;
        }
        if (options.skip != null) {
            this.skip = options.skip;
        }
        if (options.sort != null) {
            this.sort = options.sort;
        }
        if (options.cursorType != null) {
            this.cursorType = options.cursorType;
        }
        if (options.noCursorTimeout != null) {
            this.noCursorTimeout = options.noCursorTimeout;
        }
        if (options.partial != null) {
            this.partial = options.partial;
        }
        if (options.collation != null) {
            this.collation = options.collation;
        }
        if (options.comment != null) {
            this.comment = options.comment;
        }
        if (options.hint != null) {
            this.hint = options.hint;
        }
        if (options.max != null) {
            this.max = options.max;
        }
        if (options.min != null) {
            this.min = options.min;
        }
        if (options.returnKey != null) {
            this.returnKey = options.returnKey;
        }
        if (options.showRecordId != null) {
            this.showRecordId = options.showRecordId;
        }
        if (options.allowDiskUse != null) {
            this.allowDiskUse = options.allowDiskUse;
        }
    }

    public boolean isEmpty() {
        if (this.filter != null) {
            return false;
        }
        if (this.batchSize != null) {
            return false;
        }
        if (this.limit != null) {
            return false;
        }
        if (this.projection != null) {
            return false;
        }
        if (this.maxTimeMS != null) {
            return false;
        }
        if (this.maxAwaitTimeMS != null) {
            return false;
        }
        if (this.skip != null) {
            return false;
        }
        if (this.sort != null) {
            return false;
        }
        if (this.cursorType != null) {
            return false;
        }
        if (this.noCursorTimeout != null) {
            return false;
        }
        if (this.partial != null) {
            return false;
        }
        if (this.collation != null) {
            return false;
        }
        if (this.comment != null) {
            return false;
        }
        if (this.hint != null) {
            return false;
        }
        if (this.max != null) {
            return false;
        }
        if (this.min != null) {
            return false;
        }
        if (this.returnKey != null) {
            return false;
        }
        if (this.showRecordId != null) {
            return false;
        }
        return this.allowDiskUse == null;
    }

    public @Nullable Bson getFilter() {
        return this.filter;
    }

    public MongoFindOptions filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    public @Nullable Integer getBatchSize() {
        return this.batchSize;
    }

    public MongoFindOptions batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public @Nullable Integer getLimit() {
        return this.limit;
    }

    public MongoFindOptions limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public @Nullable Bson getProjection() {
        return this.projection;
    }

    public MongoFindOptions projection(Bson projection) {
        this.projection = projection;
        return this;
    }

    public @Nullable Long getMaxTimeMS() {
        return this.maxTimeMS;
    }

    public MongoFindOptions maxTimeMS(Long maxTimeMS) {
        this.maxTimeMS = maxTimeMS;
        return this;
    }

    public @Nullable Long getMaxAwaitTimeMS() {
        return this.maxAwaitTimeMS;
    }

    public MongoFindOptions maxAwaitTimeMS(Long maxAwaitTimeMS) {
        this.maxAwaitTimeMS = maxAwaitTimeMS;
        return this;
    }

    public @Nullable Integer getSkip() {
        return this.skip;
    }

    public MongoFindOptions skip(Integer skip) {
        this.skip = skip;
        return this;
    }

    public @Nullable Bson getSort() {
        return this.sort;
    }

    public MongoFindOptions sort(Bson sort) {
        this.sort = sort;
        return this;
    }

    public @Nullable CursorType getCursorType() {
        return this.cursorType;
    }

    public MongoFindOptions cursorType(CursorType cursorType) {
        this.cursorType = cursorType;
        return this;
    }

    public @Nullable Boolean getNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public MongoFindOptions noCursorTimeout(Boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public @Nullable Boolean getPartial() {
        return this.partial;
    }

    public MongoFindOptions partial(Boolean partial) {
        this.partial = partial;
        return this;
    }

    public @Nullable Collation getCollation() {
        return this.collation;
    }

    public MongoFindOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public @Nullable String getComment() {
        return this.comment;
    }

    public MongoFindOptions comment(String comment) {
        this.comment = comment;
        return this;
    }

    public @Nullable Bson getHint() {
        return this.hint;
    }

    public MongoFindOptions hint(Bson hint) {
        this.hint = hint;
        return this;
    }

    public @Nullable Bson getMax() {
        return this.max;
    }

    public MongoFindOptions max(Bson max) {
        this.max = max;
        return this;
    }

    public @Nullable Bson getMin() {
        return this.min;
    }

    public MongoFindOptions min(Bson min) {
        this.min = min;
        return this;
    }

    public @Nullable Boolean getReturnKey() {
        return this.returnKey;
    }

    public MongoFindOptions returnKey(Boolean returnKey) {
        this.returnKey = returnKey;
        return this;
    }

    public @Nullable Boolean getShowRecordId() {
        return this.showRecordId;
    }

    public MongoFindOptions showRecordId(Boolean showRecordId) {
        this.showRecordId = showRecordId;
        return this;
    }

    public @Nullable Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public MongoFindOptions allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }
}

