/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import com.mongodb.client.model.Sorts;
import io.micronaut.aop.InvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.Limit;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.mongodb.operations.MongoAggregation;
import io.micronaut.data.mongodb.operations.MongoDelete;
import io.micronaut.data.mongodb.operations.MongoFind;
import io.micronaut.data.mongodb.operations.MongoPreparedQuery;
import io.micronaut.data.mongodb.operations.MongoStoredQuery;
import io.micronaut.data.mongodb.operations.MongoUpdate;
import io.micronaut.data.mongodb.operations.options.MongoFindOptions;
import io.micronaut.data.runtime.operations.internal.query.DefaultBindableParametersPreparedQuery;
import io.micronaut.data.runtime.query.internal.DefaultPreparedQuery;
import io.micronaut.data.runtime.query.internal.DelegatePreparedQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

@Internal
final class DefaultMongoPreparedQuery<E, R>
extends DefaultBindableParametersPreparedQuery<E, R>
implements DelegatePreparedQuery<E, R>,
MongoPreparedQuery<E, R> {
    private final DefaultPreparedQuery<E, R> defaultPreparedQuery;
    private final MongoStoredQuery<E, R> mongoStoredQuery;

    public DefaultMongoPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        super(preparedQuery);
        this.defaultPreparedQuery = (DefaultPreparedQuery)preparedQuery;
        this.mongoStoredQuery = (MongoStoredQuery)((DelegateStoredQuery)preparedQuery).getStoredQueryDelegate();
    }

    @Override
    public RuntimePersistentEntity<E> getPersistentEntity() {
        return this.mongoStoredQuery.getRuntimePersistentEntity();
    }

    @Override
    public boolean isAggregate() {
        return this.mongoStoredQuery.isAggregate();
    }

    public Limit getQueryLimit() {
        Limit queryLimit = super.getQueryLimit();
        if (queryLimit.isLimited()) {
            return queryLimit;
        }
        return this.getParameterInRole("querylimit", Limit.class).orElse(queryLimit);
    }

    public Sort getSort() {
        return super.getSort();
    }

    @Override
    public MongoAggregation getAggregation() {
        MongoAggregation aggregation = this.mongoStoredQuery.getAggregation((InvocationContext<?, ?>)this.defaultPreparedQuery.getContext());
        Pageable pageable = this.getPageable();
        if (!pageable.isUnpaged()) {
            ArrayList<Bson> pipeline = new ArrayList<Bson>(aggregation.getPipeline());
            this.applyPageable(pageable, pipeline);
            return new MongoAggregation(pipeline, aggregation.getOptions());
        }
        Limit limit = this.getQueryLimit();
        Sort sort = this.getSort();
        if (limit.isLimited() || sort.isSorted()) {
            ArrayList<Bson> pipeline = new ArrayList<Bson>(aggregation.getPipeline());
            this.applyPageable(limit, sort, pipeline);
            return new MongoAggregation(pipeline, aggregation.getOptions());
        }
        return aggregation;
    }

    @Override
    public MongoFind getFind() {
        MongoFind find = this.mongoStoredQuery.getFind((InvocationContext<?, ?>)this.defaultPreparedQuery.getContext());
        Pageable pageable = this.defaultPreparedQuery.getPageable();
        if (!pageable.isUnpaged()) {
            if (pageable.getMode() != Pageable.Mode.OFFSET) {
                throw new UnsupportedOperationException("Mode " + String.valueOf(pageable.getMode()) + " is not supported by the MongoDB implementation");
            }
            Limit limit = pageable.getLimit();
            Sort sort = pageable.getSort();
            return this.applyLimitAndSort(find, limit, sort);
        }
        Limit limit = this.getQueryLimit();
        Sort sort = this.getSort();
        if (limit.isLimited() || sort.isSorted()) {
            return this.applyLimitAndSort(find, limit, sort);
        }
        return find;
    }

    private MongoFind applyLimitAndSort(MongoFind find, Limit limit, Sort sort) {
        MongoFindOptions findOptions = find.getOptions();
        MongoFindOptions options = findOptions == null ? new MongoFindOptions() : new MongoFindOptions(findOptions);
        options.limit(limit.maxResults()).skip((int)limit.offset());
        if (sort.isSorted()) {
            Bson sortBson = this.getSort(sort);
            options.sort(sortBson);
        }
        return new MongoFind(options);
    }

    private Bson getSort(Sort sort) {
        RuntimePersistentEntity persistentEntity = this.getPersistentEntity();
        return sort.getOrderBy().stream().map(order -> {
            String property = order.getProperty();
            if (persistentEntity.hasIdentity() && persistentEntity.getIdentity().getName().contains(property)) {
                property = "_id";
            }
            return order.isAscending() ? Sorts.ascending((String[])new String[]{property}) : Sorts.descending((String[])new String[]{property});
        }).collect(Collectors.collectingAndThen(Collectors.toList(), Sorts::orderBy));
    }

    @Override
    public MongoUpdate getUpdateMany() {
        return this.mongoStoredQuery.getUpdateMany((InvocationContext<?, ?>)this.defaultPreparedQuery.getContext());
    }

    @Override
    public MongoDelete getDeleteMany() {
        return this.mongoStoredQuery.getDeleteMany((InvocationContext<?, ?>)this.defaultPreparedQuery.getContext());
    }

    public PreparedQuery<E, R> getPreparedQueryDelegate() {
        return this.defaultPreparedQuery;
    }

    private void applyPageable(Pageable pageable, List<Bson> pipeline) {
        if (pageable.getMode() != Pageable.Mode.OFFSET) {
            throw new UnsupportedOperationException("Mode " + String.valueOf(pageable.getMode()) + " is not supported by the MongoDB implementation");
        }
        this.applyPageable(pageable.getLimit(), pageable.getSort(), pipeline);
    }

    private void applyPageable(Limit queryLimit, Sort sort, List<Bson> pipeline) {
        if (sort.isSorted()) {
            BsonValue bsonValue;
            Bson p;
            BsonDocument sortBsonDocument;
            BsonDocument existingSortBson = null;
            Iterator<Bson> iterator = pipeline.iterator();
            while (iterator.hasNext() && ((sortBsonDocument = (p = iterator.next()).toBsonDocument()) == null || (bsonValue = sortBsonDocument.get((Object)"$sort")) == null || (existingSortBson = bsonValue.asDocument()) == null)) {
            }
            Bson sortBson = this.getSort(sort);
            if (existingSortBson != null) {
                existingSortBson.putAll((Map)sortBson.toBsonDocument());
            } else {
                BsonDocument sortStage = new BsonDocument().append("$sort", (BsonValue)sortBson.toBsonDocument());
                this.addStageToPipelineBefore(pipeline, sortStage, "$limit", "$skip");
            }
        }
        if (queryLimit.isLimited()) {
            int maxResults;
            int offset = (int)queryLimit.offset();
            if (offset > 0) {
                pipeline.add((Bson)new BsonDocument().append("$skip", (BsonValue)new BsonInt32(offset)));
            }
            if ((maxResults = queryLimit.maxResults()) > 0) {
                pipeline.add((Bson)new BsonDocument().append("$limit", (BsonValue)new BsonInt32(maxResults)));
            }
        }
    }

    private void addStageToPipelineBefore(List<Bson> pipeline, BsonDocument stageToAdd, String ... beforeStages) {
        int lastFoundIndex = -1;
        int index = 0;
        for (Bson stage : pipeline) {
            for (String beforeStageName : beforeStages) {
                if (!stage.toBsonDocument().containsKey((Object)beforeStageName)) continue;
                lastFoundIndex = index;
                break;
            }
            ++index;
        }
        if (lastFoundIndex > -1) {
            pipeline.add(lastFoundIndex, (Bson)stageToAdd);
        } else {
            pipeline.add((Bson)stageToAdd);
        }
    }
}

