/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.mongodb.annotation.MongoRepository;
import io.micronaut.data.mongodb.operations.MongoDatabaseNameProvider;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.data.runtime.multitenancy.SchemaTenantResolver;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@Internal
public final class DefaultMongoDatabaseNameProvider
implements MongoDatabaseNameProvider {
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private final Map<Class, String> repoDatabaseConfig;
    private final @Nullable String defaultDatabaseName;
    private final @Nullable SchemaTenantResolver tenantResolver;

    public DefaultMongoDatabaseNameProvider(BeanContext beanContext, @Nullable String server, RuntimeEntityRegistry runtimeEntityRegistry, @Nullable String defaultDatabaseName, @Nullable SchemaTenantResolver tenantResolver) {
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.defaultDatabaseName = defaultDatabaseName;
        this.tenantResolver = tenantResolver;
        Collection beanDefinitions = beanContext.getBeanDefinitions(GenericRepository.class, Qualifiers.byStereotype(MongoRepository.class));
        HashMap<Class, String> repoDatabaseConfig = new HashMap<Class, String>();
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String database;
            String targetSrv = beanDefinition.stringValue(Repository.class).orElse(null);
            if (targetSrv != null && !targetSrv.isEmpty() && !targetSrv.equalsIgnoreCase(server) || !StringUtils.isNotEmpty((CharSequence)(database = (String)beanDefinition.stringValue(MongoRepository.class, "databaseName").orElse(null)))) continue;
            repoDatabaseConfig.put(beanDefinition.getBeanType(), database);
        }
        this.repoDatabaseConfig = Collections.unmodifiableMap(repoDatabaseConfig);
    }

    @Override
    public String provide(Class<?> type) {
        return this.provide((PersistentEntity)this.runtimeEntityRegistry.getEntity(type));
    }

    @Override
    public String provide(PersistentEntity persistentEntity, @Nullable Class<?> repositoryClass) {
        String database;
        if (this.tenantResolver != null && (database = this.tenantResolver.resolveTenantSchemaName()) != null) {
            return database;
        }
        if (repositoryClass != null && (database = this.repoDatabaseConfig.get(repositoryClass)) != null) {
            return database;
        }
        if (this.defaultDatabaseName == null) {
            throw new DataAccessException("MongoDB database name is not specified in the url! You can specify it as '@MongoRepository(database: \"mydb\")' or in the connect url: 'mongodb://username:password@localhost:27017/mydb'.");
        }
        return this.defaultDatabaseName;
    }
}

