/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.conf;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.ReflectiveAccess;
import org.jspecify.annotations.NullUnmarked;

@ConfigurationProperties(value="micronaut.data.mongodb")
@ReflectiveAccess
@NullUnmarked
public final class MongoDataConfiguration {
    public static final String PREFIX = "micronaut.data.mongodb";
    public static final String CREATE_COLLECTIONS_PROPERTY = "micronaut.data.mongodb.create-collections";
    public static final String DRIVER_TYPE_PROPERTY = "micronaut.data.mongodb.driver-type";
    public static final String JSON_VIEWS_PROPERTY = "micronaut.data.mongodb.ignore-json-views";
    public static final String DRIVER_TYPE_SYNC = DriverType.SYNC.name();
    public static final String DRIVER_TYPE_REACTIVE = DriverType.REACTIVE.name();
    public static final String DATABASE_CONFIGURATION_ERROR_MESSAGE = "MongoDB database name is not specified in the url! You can specify it as '@MongoRepository(database: \"mydb\")' or in the connect url: 'mongodb://username:password@localhost:27017/mydb'.";
    private boolean createCollections;
    private DriverType driverType;
    private boolean ignoreJsonViews;

    public boolean isCreateCollections() {
        return this.createCollections;
    }

    public void setCreateCollections(boolean createCollections) {
        this.createCollections = createCollections;
    }

    public boolean isIgnoreJsonViews() {
        return this.ignoreJsonViews;
    }

    public void setIgnoreJsonViews(boolean ignoreJsonViews) {
        this.ignoreJsonViews = ignoreJsonViews;
    }

    public DriverType getDriverType() {
        return this.driverType;
    }

    public void setDriverType(DriverType driverType) {
        this.driverType = driverType;
    }

    public static enum DriverType {
        SYNC,
        REACTIVE;

    }

    public static final class NotSyncDriverSelectedCondition
    implements Condition {
        public boolean matches(ConditionContext context) {
            return ((MongoDataConfiguration)context.getBean(MongoDataConfiguration.class)).driverType != DriverType.SYNC;
        }
    }

    public static final class NotReactiveDriverSelectedCondition
    implements Condition {
        public boolean matches(ConditionContext context) {
            return ((MongoDataConfiguration)context.getBean(MongoDataConfiguration.class)).driverType != DriverType.REACTIVE;
        }
    }
}

