/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.serde;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import java.util.Map;
import org.bson.codecs.ByteArrayCodec;
import org.bson.codecs.Codec;

@Internal
final class CodecUtils {
    private CodecUtils() {
    }

    static <T> boolean shouldUseCodec(Codec<? extends T> codec) {
        if (codec instanceof ByteArrayCodec) {
            return true;
        }
        Class encoderClass = codec.getEncoderClass();
        return !ClassUtils.isJavaLangType((Class)encoderClass) && !Map.class.isAssignableFrom(encoderClass) && !Iterable.class.isAssignableFrom(encoderClass);
    }
}

