/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.mongodb.operations.MongoCollectionNameProvider;
import jakarta.inject.Singleton;
import org.jspecify.annotations.Nullable;

@Singleton
@Requires(missingBeans={MongoCollectionNameProvider.class})
@Internal
public final class DefaultMongoCollectionNameProvider
implements MongoCollectionNameProvider {
    private final @Nullable PropertyPlaceholderResolver propertyPlaceholderResolver;

    DefaultMongoCollectionNameProvider(@Nullable Environment environment) {
        this.propertyPlaceholderResolver = environment != null ? environment.getPlaceholderResolver() : null;
    }

    @Override
    public String provide(PersistentEntity persistentEntity) {
        String persistedName = persistentEntity.getPersistedName();
        if (this.propertyPlaceholderResolver != null && persistedName.contains(this.propertyPlaceholderResolver.getPrefix())) {
            persistedName = this.propertyPlaceholderResolver.resolveRequiredPlaceholders(persistedName);
        }
        return persistedName;
    }
}

