/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.transaction;

import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClient;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import io.micronaut.data.mongodb.conf.RequiresReactiveMongo;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.exceptions.TransactionUsageException;
import io.micronaut.transaction.support.AbstractReactorTransactionOperations;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RequiresReactiveMongo
@EachBean(value=MongoClient.class)
@Internal
final class DefaultMongoReactorTransactionOperations
extends AbstractReactorTransactionOperations<ClientSession> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMongoReactorTransactionOperations.class);
    private final String serverName;

    DefaultMongoReactorTransactionOperations(@Parameter String serverName, @Parameter ReactorConnectionOperations<ClientSession> connectionOperations) {
        super(connectionOperations);
        this.serverName = serverName;
    }

    protected Publisher<Void> beginTransaction(ConnectionStatus<ClientSession> connectionStatus, TransactionDefinition transactionDefinition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transaction begin for MongoDB connection: {} and configuration {}.", connectionStatus.getConnection(), (Object)this.serverName);
        }
        if (transactionDefinition.getIsolationLevel().isPresent()) {
            return Flux.error((Throwable)new TransactionUsageException("Isolation level not supported"));
        }
        if (transactionDefinition.getTimeout().isPresent()) {
            return Flux.error((Throwable)new TransactionUsageException("Timeout not supported"));
        }
        ((ClientSession)connectionStatus.getConnection()).startTransaction();
        return Mono.empty();
    }

    protected Publisher<Void> commitTransaction(ConnectionStatus<ClientSession> connectionStatus, TransactionDefinition transactionDefinition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Committing transaction for MongoDB connection: {} and configuration {}.", connectionStatus.getConnection(), (Object)this.serverName);
        }
        return ((ClientSession)connectionStatus.getConnection()).commitTransaction();
    }

    protected Publisher<Void> rollbackTransaction(ConnectionStatus<ClientSession> connectionStatus, TransactionDefinition transactionDefinition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rolling back transaction for MongoDB connection: {} and configuration {}.", connectionStatus.getConnection(), (Object)this.serverName);
        }
        return ((ClientSession)connectionStatus.getConnection()).abortTransaction();
    }
}

