/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.exceptions.jakarta.data;

import com.mongodb.MongoWriteException;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Order;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataDeleteExceptionConverter;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataExceptionConverter;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataInsertExceptionConverter;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataUpdateExceptionConverter;
import jakarta.data.exceptions.EntityExistsException;
import jakarta.data.exceptions.OptimisticLockingFailureException;
import jakarta.inject.Singleton;

@Order(value=-2147483648)
@Singleton
@Requires(classes={OptimisticLockingFailureException.class})
final class MongoJakartaDataExceptionConverter
implements JakartaDataExceptionConverter,
JakartaDataUpdateExceptionConverter,
JakartaDataDeleteExceptionConverter,
JakartaDataInsertExceptionConverter {
    MongoJakartaDataExceptionConverter() {
    }

    public Exception convert(Exception exception) {
        MongoWriteException e;
        Throwable throwable;
        if (exception instanceof DataAccessException && (throwable = exception.getCause()) instanceof MongoWriteException && (e = (MongoWriteException)throwable).getError().getCode() == 11000) {
            throw new EntityExistsException(exception.getMessage(), (Throwable)e);
        }
        return exception;
    }
}

