/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.serde;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.document.serde.IdPropertyNamingStrategy;
import io.micronaut.data.document.serde.IdSerializer;
import io.micronaut.data.document.serde.ManyRelationSerializer;
import io.micronaut.data.document.serde.OneRelationSerializer;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.mongodb.conf.MongoDataConfiguration;
import io.micronaut.data.mongodb.serde.DataDecoderContext;
import io.micronaut.data.mongodb.serde.DataEncoderContext;
import io.micronaut.data.mongodb.serde.DefaultDecoderContext;
import io.micronaut.data.mongodb.serde.DefaultEncoderContext;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.DefaultSerdeRegistry;
import io.micronaut.serde.support.deserializers.ObjectDeserializer;
import io.micronaut.serde.support.serializers.ObjectSerializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import org.bson.codecs.configuration.CodecRegistry;

@Singleton
@Order(value=0x7FFFFFFF)
@Internal
final class DataSerdeRegistry
implements SerdeRegistry {
    public static final IdPropertyNamingStrategy ID_PROPERTY_NAMING_STRATEGY = element -> "_id";
    private final DefaultSerdeRegistry defaultSerdeRegistry;
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private final AttributeConverterRegistry attributeConverterRegistry;
    private final MongoDataConfiguration mongoDataConfiguration;

    public DataSerdeRegistry(BeanContext beanContext, SerializationConfiguration serializationConfiguration, DeserializationConfiguration deserializationConfiguration, Serde<Object[]> objectArraySerde, SerdeIntrospections introspections, RuntimeEntityRegistry runtimeEntityRegistry, AttributeConverterRegistry attributeConverterRegistry, MongoDataConfiguration mongoDataConfiguration, ConversionService conversionService) {
        ObjectSerializer objectSerializer = new ObjectSerializer(introspections, serializationConfiguration, beanContext);
        ObjectDeserializer objectDeserializer = new ObjectDeserializer(introspections, deserializationConfiguration);
        this.defaultSerdeRegistry = new DefaultSerdeRegistry(beanContext, objectSerializer, objectDeserializer, objectArraySerde, introspections, conversionService);
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.attributeConverterRegistry = attributeConverterRegistry;
        this.mongoDataConfiguration = mongoDataConfiguration;
    }

    public Serializer.EncoderContext newEncoderContext(Class<?> view, Argument argument, RuntimePersistentEntity<?> runtimePersistentEntity, CodecRegistry codecRegistry) {
        return new DataEncoderContext(this.mongoDataConfiguration, this.attributeConverterRegistry, argument, runtimePersistentEntity, this.newEncoderContext(view), codecRegistry);
    }

    public Deserializer.DecoderContext newDecoderContext(Class<?> view, Argument argument, RuntimePersistentEntity<?> runtimePersistentEntity, CodecRegistry codecRegistry) {
        return new DataDecoderContext(this.mongoDataConfiguration, this.attributeConverterRegistry, argument, runtimePersistentEntity, this.newDecoderContext(view), codecRegistry);
    }

    public Serializer.EncoderContext newEncoderContext(final Class<?> view) {
        if (view != null) {
            return new DefaultEncoderContext(this){

                public boolean hasView(Class<?> ... views) {
                    for (Class<?> candidate : views) {
                        if (!candidate.isAssignableFrom(view)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new DefaultEncoderContext(this);
    }

    public Deserializer.DecoderContext newDecoderContext(final Class<?> view) {
        if (view != null) {
            return new DefaultDecoderContext(this){

                public boolean hasView(Class<?> ... views) {
                    for (Class<?> candidate : views) {
                        if (!candidate.isAssignableFrom(view)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new DefaultDecoderContext(this);
    }

    public <T, D extends Serializer<? extends T>> D findCustomSerializer(Class<? extends D> serializerClass) throws SerdeException {
        if (serializerClass == OneRelationSerializer.class) {
            OneRelationSerializer oneRelationSerializer = new OneRelationSerializer(){

                public Serializer<Object> createSpecific(Serializer.EncoderContext encoderContext, Argument<?> type) throws SerdeException {
                    RuntimePersistentEntity entity = DataSerdeRegistry.this.runtimeEntityRegistry.getEntity(type.getType());
                    if (entity.getIdentity() == null) {
                        throw new SerdeException("Cannot find ID of entity type: " + type);
                    }
                    final BeanProperty property = entity.getIdentity().getProperty();
                    final Argument idType = entity.getIdentity().getArgument();
                    final Serializer idSerializer = ((IdSerializer)encoderContext.findCustomSerializer(IdSerializer.class)).createSpecific(encoderContext, idType);
                    return new Serializer<Object>(){

                        public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) throws IOException {
                            Object id = property.get(value);
                            if (id == null) {
                                encoder.encodeNull();
                            } else {
                                Encoder en = encoder.encodeObject(type);
                                en.encodeKey("_id");
                                idSerializer.serialize(en, context, idType, id);
                                en.finishStructure();
                            }
                        }
                    };
                }

                public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Object> type, Object value) throws IOException {
                    throw new IllegalStateException("Create specific call is required!");
                }
            };
            return (D)oneRelationSerializer;
        }
        if (serializerClass == ManyRelationSerializer.class) {
            ManyRelationSerializer manyRelationSerializer = new ManyRelationSerializer(){

                public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) throws IOException {
                    encoder.encodeNull();
                }
            };
            return (D)manyRelationSerializer;
        }
        return (D)this.defaultSerdeRegistry.findCustomSerializer(serializerClass);
    }

    public <T> Serializer<? super T> findSerializer(Argument<? extends T> forType) throws SerdeException {
        return this.defaultSerdeRegistry.findSerializer(forType);
    }

    public <T, D extends Deserializer<? extends T>> D findCustomDeserializer(Class<? extends D> deserializerClass) throws SerdeException {
        return (D)this.defaultSerdeRegistry.findCustomDeserializer(deserializerClass);
    }

    public <T> Deserializer<? extends T> findDeserializer(Argument<? extends T> type) throws SerdeException {
        return this.defaultSerdeRegistry.findDeserializer(type);
    }

    public <T> Collection<BeanIntrospection<? extends T>> getDeserializableSubtypes(Class<T> superType) {
        return this.defaultSerdeRegistry.getDeserializableSubtypes(superType);
    }

    public <D extends PropertyNamingStrategy> D findNamingStrategy(Class<? extends D> namingStrategyClass) throws SerdeException {
        return (D)this.defaultSerdeRegistry.findNamingStrategy(namingStrategyClass);
    }

    public ConversionService getConversionService() {
        return this.defaultSerdeRegistry.getConversionService();
    }
}

