/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.transaction;

import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;

@Internal
final class MongoTransaction
implements AutoCloseable {
    private String name;
    private ClientSession clientSession;
    private boolean newClientSession;
    private boolean rollbackOnly = false;

    public MongoTransaction(ClientSession clientSession) {
        this.clientSession = clientSession;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasClientSession() {
        return this.clientSession != null;
    }

    public void setClientSessionHolder(ClientSession clientSession, boolean newClientSession) {
        this.clientSession = clientSession;
        this.newClientSession = newClientSession;
    }

    public void beginTransaction(TransactionOptions transactionOptions) {
        this.clientSession.startTransaction(transactionOptions);
    }

    public void commitTransaction() {
        this.clientSession.commitTransaction();
    }

    public void abortTransaction() {
        this.clientSession.abortTransaction();
    }

    public boolean hasActiveTransaction() {
        return this.clientSession != null && this.clientSession.hasActiveTransaction();
    }

    @Nullable
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public boolean isNewClientSession() {
        return this.newClientSession;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    @Override
    public void close() {
        if (this.newClientSession) {
            this.newClientSession = false;
            this.clientSession.close();
            this.clientSession = null;
        }
    }

    public String toString() {
        return this.name;
    }
}

