/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.session;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.support.AbstractConnectionOperations;
import io.micronaut.data.mongodb.session.MongoConnectionOperations;

@Internal
@EachBean(value=MongoClient.class)
final class MongoConnectionOperationsImpl
extends AbstractConnectionOperations<ClientSession>
implements MongoConnectionOperations {
    private final MongoClient mongoClient;

    MongoConnectionOperationsImpl(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    protected ClientSession openConnection(ConnectionDefinition definition) {
        return this.mongoClient.startSession();
    }

    protected void setupConnection(ConnectionStatus<ClientSession> connectionStatus) {
    }

    protected void closeConnection(ConnectionStatus<ClientSession> connectionStatus) {
        ((ClientSession)connectionStatus.getConnection()).close();
    }
}

