/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.database;

import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.mongodb.database.ReactiveMongoDatabaseFactory;

public final class SimpleReactiveMongoDatabaseFactory
implements ReactiveMongoDatabaseFactory {
    private final MongoClient mongoClient;
    private final String databaseName;

    public SimpleReactiveMongoDatabaseFactory(MongoClient mongoClient, String databaseName) {
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
    }

    @Override
    public MongoDatabase getDatabase(PersistentEntity persistentEntity) throws DataAccessException {
        return this.mongoClient.getDatabase(this.databaseName);
    }

    @Override
    public MongoDatabase getDatabase(Class<?> entityClass) throws DataAccessException {
        return this.mongoClient.getDatabase(this.databaseName);
    }
}

