/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.mongodb.database.MongoDatabaseFactory;
import io.micronaut.data.mongodb.operations.MongoRepositoryOperations;
import io.micronaut.data.mongodb.operations.MongoUtils;
import io.micronaut.data.mongodb.transaction.MongoSynchronousTransactionManager;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.data.runtime.operations.internal.AbstractRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSyncEntitiesOperations;
import io.micronaut.data.runtime.operations.internal.AbstractSyncEntityOperations;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import io.micronaut.data.runtime.operations.internal.SyncCascadeOperations;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Named;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonInt32;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;

@EachBean(value=MongoClient.class)
@Internal
public final class DefaultMongoRepositoryOperations
extends AbstractRepositoryOperations<ClientSession, Object>
implements MongoRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository,
SyncCascadeOperations.SyncCascadeOperationsHelper<MongoOperationContext> {
    private static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    private static final BsonDocument EMPTY = new BsonDocument();
    private final MongoClient mongoClient;
    private final SyncCascadeOperations<MongoOperationContext> cascadeOperations;
    private final MongoSynchronousTransactionManager transactionManager;
    private final MongoDatabaseFactory mongoDatabaseFactory;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;

    protected DefaultMongoRepositoryOperations(@Parameter String serverName, BeanContext beanContext, List<MediaTypeCodec> codecs, DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService<?> conversionService, AttributeConverterRegistry attributeConverterRegistry, MongoClient mongoClient, @Named(value="io") @Nullable ExecutorService executorService) {
        super(codecs, dateTimeProvider, runtimeEntityRegistry, conversionService, attributeConverterRegistry);
        this.mongoClient = mongoClient;
        this.cascadeOperations = new SyncCascadeOperations(conversionService, (SyncCascadeOperations.SyncCascadeOperationsHelper)this);
        boolean isPrimary = "Primary".equals(serverName);
        this.transactionManager = (MongoSynchronousTransactionManager)((Object)beanContext.getBean(MongoSynchronousTransactionManager.class, isPrimary ? null : Qualifiers.byName((String)serverName)));
        this.mongoDatabaseFactory = (MongoDatabaseFactory)beanContext.getBean(MongoDatabaseFactory.class, isPrimary ? null : Qualifiers.byName((String)serverName));
        this.executorService = executorService;
    }

    public <T> T findOne(Class<T> type, Serializable id) {
        return (T)this.withClientSession(clientSession -> {
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(type);
            MongoDatabase database = this.getDatabase((PersistentEntity)persistentEntity);
            MongoCollection collection = this.getCollection(database, persistentEntity, type);
            Bson filter = MongoUtils.filterById(this.conversionService, persistentEntity, id, collection.getCodecRegistry());
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'find' with filter: {}", (Object)filter.toBsonDocument().toJson());
            }
            return collection.find(clientSession, filter, type).first();
        });
    }

    public <T, R> R findOne(PreparedQuery<T, R> preparedQuery) {
        return (R)this.withClientSession(clientSession -> {
            BsonDocument filter;
            List<BsonDocument> pipeline;
            Class type = preparedQuery.getRootEntity();
            Class resultType = preparedQuery.getResultType();
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(type);
            MongoDatabase database = this.getDatabase((PersistentEntity)persistentEntity);
            String query = preparedQuery.getQuery();
            if (query.startsWith("[")) {
                pipeline = this.getPipeline(database.getCodecRegistry(), preparedQuery, persistentEntity);
                filter = EMPTY;
            } else {
                pipeline = null;
                filter = this.getFilter(database.getCodecRegistry(), preparedQuery, persistentEntity);
            }
            if (preparedQuery.isCount() || query.contains("$count")) {
                return this.getCount((ClientSession)clientSession, database, type, resultType, (RuntimePersistentEntity)persistentEntity, (Bson)filter, pipeline);
            }
            if (pipeline == null) {
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Mongo 'find' with filter: {}", (Object)filter.toBsonDocument().toJson());
                }
                return this.getCollection(database, persistentEntity, resultType).find(clientSession, (Bson)filter, resultType).limit(1).map(r -> {
                    if (type.isInstance(r)) {
                        return this.triggerPostLoad(preparedQuery.getAnnotationMetadata(), persistentEntity, type.cast(r));
                    }
                    return r;
                }).first();
            }
            return this.findOneAggregated((ClientSession)clientSession, preparedQuery, type, resultType, (RuntimePersistentEntity)persistentEntity, database, pipeline);
        });
    }

    private <R> R convertResult(MongoDatabase mongoDatabase, Class<R> resultType, BsonDocument result, boolean isDtoProjection) {
        BsonNull value;
        if (result == null) {
            value = BsonNull.VALUE;
        } else if (result.size() == 1) {
            value = ((BsonValue)result.values().iterator().next()).asNumber();
        } else if (result.size() == 2) {
            value = (BsonValue)result.entrySet().stream().filter(f -> !((String)f.getKey()).equals("_id")).findFirst().get().getValue();
        } else {
            if (isDtoProjection) {
                R dtoResult = MongoUtils.toValue(result.asDocument(), resultType, mongoDatabase.getCodecRegistry());
                if (resultType.isInstance(dtoResult)) {
                    return dtoResult;
                }
                return (R)this.conversionService.convertRequired(dtoResult, resultType);
            }
            throw new IllegalStateException("Unrecognized result: " + result);
        }
        return (R)this.conversionService.convertRequired(MongoUtils.toValue((BsonValue)value), resultType);
    }

    public <T> boolean exists(PreparedQuery<T, Boolean> preparedQuery) {
        return this.withClientSession(clientSession -> {
            Class type = preparedQuery.getRootEntity();
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(type);
            MongoDatabase database = this.getDatabase((PersistentEntity)persistentEntity);
            String query = preparedQuery.getQuery();
            if (query.startsWith("[")) {
                List<BsonDocument> pipeline = this.getPipeline(database.getCodecRegistry(), preparedQuery, persistentEntity);
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Mongo 'aggregate' with pipeline: {}", pipeline.stream().map(e -> e.toBsonDocument().toJson()).collect(Collectors.toList()));
                }
                return this.getCollection(database, persistentEntity, persistentEntity.getIntrospection().getBeanType()).aggregate(clientSession, pipeline).iterator().hasNext();
            }
            Bson filter = this.getFilter(database.getCodecRegistry(), preparedQuery, persistentEntity);
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing exists Mongo 'find' with filter: {}", (Object)filter.toBsonDocument().toJson());
            }
            return this.getCollection(database, persistentEntity, persistentEntity.getIntrospection().getBeanType()).find(clientSession, type).limit(1).filter(filter).iterator().hasNext();
        });
    }

    public <T> Iterable<T> findAll(PagedQuery<T> query) {
        throw new DataAccessException("Not supported!");
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        throw new DataAccessException("Not supported!");
    }

    public <T> Stream<T> findStream(PagedQuery<T> query) {
        throw new DataAccessException("Not supported!");
    }

    public <R> Page<R> findPage(PagedQuery<R> query) {
        throw new DataAccessException("Not supported!");
    }

    public <T, R> Iterable<R> findAll(PreparedQuery<T, R> preparedQuery) {
        return this.withClientSession(clientSession -> this.findAll((ClientSession)clientSession, preparedQuery, false));
    }

    private <T, R> Iterable<R> findAll(ClientSession clientSession, PreparedQuery<T, R> preparedQuery, boolean stream) {
        BsonDocument filter;
        List<BsonDocument> pipeline;
        Pageable pageable = preparedQuery.getPageable();
        Class type = preparedQuery.getRootEntity();
        Class resultType = preparedQuery.getResultType();
        RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(type);
        MongoDatabase database = this.getDatabase((PersistentEntity)persistentEntity);
        String query = preparedQuery.getQuery();
        if (query.startsWith("[")) {
            pipeline = this.getPipeline(database.getCodecRegistry(), preparedQuery, persistentEntity);
            filter = EMPTY;
        } else {
            pipeline = null;
            filter = this.getFilter(database.getCodecRegistry(), preparedQuery, persistentEntity);
        }
        if (preparedQuery.isCount() || query.contains("$count")) {
            return Collections.singletonList(this.getCount(clientSession, database, type, resultType, persistentEntity, (Bson)filter, pipeline));
        }
        if (pipeline == null) {
            return this.findAll(clientSession, database, pageable, resultType, persistentEntity, (Bson)filter, stream);
        }
        return this.findAllAggregated(clientSession, database, pageable, resultType, preparedQuery.isDtoProjection(), persistentEntity, pipeline, stream);
    }

    public <T, R> Stream<R> findStream(PreparedQuery<T, R> preparedQuery) {
        return this.withClientSession(clientSession -> {
            MongoIterable iterable = (MongoIterable)this.findAll((ClientSession)clientSession, preparedQuery, true);
            final MongoCursor iterator = iterable.iterator();
            Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 1040){

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (iterator.hasNext()) {
                        action.accept(iterator.next());
                        return true;
                    }
                    iterator.close();
                    return false;
                }
            };
            return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> ((MongoCursor)iterator).close());
        });
    }

    private <T, R> R findOneAggregated(ClientSession clientSession, PreparedQuery<T, R> preparedQuery, Class<T> type, Class<R> resultType, RuntimePersistentEntity<T> persistentEntity, MongoDatabase database, List<BsonDocument> pipeline) {
        boolean isProjection;
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'aggregate' with pipeline: {}", pipeline.stream().map(e -> e.toBsonDocument().toJson()).collect(Collectors.toList()));
        }
        if (isProjection = pipeline.stream().anyMatch(stage -> stage.containsKey((Object)"$group") || stage.containsKey((Object)"$project"))) {
            BsonDocument result = (BsonDocument)this.getCollection(database, persistentEntity, BsonDocument.class).aggregate(clientSession, pipeline, BsonDocument.class).first();
            return this.convertResult(database, resultType, result, preparedQuery.isDtoProjection());
        }
        return (R)this.getCollection(database, persistentEntity, resultType).aggregate(clientSession, pipeline).map(r -> {
            if (type.isInstance(r)) {
                return this.triggerPostLoad(preparedQuery.getAnnotationMetadata(), persistentEntity, type.cast(r));
            }
            return r;
        }).first();
    }

    private <T, R> Iterable<R> findAllAggregated(ClientSession clientSession, MongoDatabase database, Pageable pageable, Class<R> resultType, boolean isDtoProjection, RuntimePersistentEntity<T> persistentEntity, List<BsonDocument> pipeline, boolean stream) {
        boolean isProjection;
        int limit = 0;
        if (pageable != Pageable.UNPAGED) {
            int skip = (int)pageable.getOffset();
            limit = pageable.getSize();
            Sort pageableSort = pageable.getSort();
            if (pageableSort.isSorted()) {
                Bson sort = pageableSort.getOrderBy().stream().map(order -> order.isAscending() ? Sorts.ascending((String[])new String[]{order.getProperty()}) : Sorts.descending((String[])new String[]{order.getProperty()})).collect(Collectors.collectingAndThen(Collectors.toList(), Sorts::orderBy));
                BsonDocument sortStage = new BsonDocument().append("$sort", (BsonValue)sort.toBsonDocument());
                this.addStageToPipelineBefore(pipeline, sortStage, "$limit", "$skip");
            }
            if (skip > 0) {
                pipeline.add(new BsonDocument().append("$skip", (BsonValue)new BsonInt32(skip)));
            }
            if (limit > 0) {
                pipeline.add(new BsonDocument().append("$limit", (BsonValue)new BsonInt32(limit)));
            }
        }
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'aggregate' with pipeline: {}", pipeline.stream().map(e -> e.toBsonDocument().toJson()).collect(Collectors.toList()));
        }
        Object aggregate = (isProjection = pipeline.stream().anyMatch(stage -> stage.containsKey((Object)"$group") || stage.containsKey((Object)"$project"))) ? this.getCollection(database, persistentEntity, BsonDocument.class).aggregate(clientSession, pipeline, BsonDocument.class).map(result -> this.convertResult(database, resultType, (BsonDocument)result, isDtoProjection)) : this.getCollection(database, persistentEntity, resultType).aggregate(clientSession, pipeline, resultType);
        return stream ? aggregate : aggregate.into(new ArrayList(limit > 0 ? limit : 20));
    }

    private <T, R> Iterable<R> findAll(ClientSession clientSession, MongoDatabase database, Pageable pageable, Class<R> resultType, RuntimePersistentEntity<T> persistentEntity, Bson filter, boolean stream) {
        Bson sort = null;
        int skip = 0;
        int limit = 0;
        if (pageable != Pageable.UNPAGED) {
            skip = (int)pageable.getOffset();
            limit = pageable.getSize();
            Sort pageableSort = pageable.getSort();
            if (pageableSort.isSorted()) {
                sort = pageableSort.getOrderBy().stream().map(order -> order.isAscending() ? Sorts.ascending((String[])new String[]{order.getProperty()}) : Sorts.descending((String[])new String[]{order.getProperty()})).collect(Collectors.collectingAndThen(Collectors.toList(), Sorts::orderBy));
            }
        }
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'find' with filter: {} skip: {} limit: {}", new Object[]{filter.toBsonDocument().toJson(), skip, limit});
        }
        FindIterable findIterable = this.getCollection(database, persistentEntity, resultType).find(clientSession, filter, resultType).skip(skip).limit(Math.max(limit, 0)).sort(sort);
        return stream ? findIterable : findIterable.into(new ArrayList(limit > 0 ? limit : 20));
    }

    private <T, R> R getCount(ClientSession clientSession, MongoDatabase mongoDatabase, Class<T> type, Class<R> resultType, RuntimePersistentEntity<T> persistentEntity, Bson filter, List<BsonDocument> pipeline) {
        Object result;
        if (pipeline == null) {
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'countDocuments' with filter: {}", (Object)filter.toBsonDocument().toJson());
            }
            long count = this.getCollection(mongoDatabase, persistentEntity, BsonDocument.class).countDocuments(clientSession, filter);
            return (R)this.conversionService.convertRequired((Object)count, resultType);
        }
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'aggregate' with pipeline: {}", pipeline.stream().map(e -> e.toBsonDocument().toJson()).collect(Collectors.toList()));
        }
        if ((result = this.getCollection(mongoDatabase, persistentEntity, type).aggregate(clientSession, pipeline, BsonDocument.class).map(bsonDocument -> this.convertResult(mongoDatabase, resultType, (BsonDocument)bsonDocument, false)).first()) == null) {
            result = this.conversionService.convertRequired((Object)0, resultType);
        }
        return (R)result;
    }

    public <T> T persist(InsertOperation<T> operation) {
        return (T)this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            return this.persistOne(ctx, operation.getEntity(), this.runtimeEntityRegistry.getEntity(operation.getRootEntity()));
        });
    }

    public <T> Iterable<T> persistAll(InsertBatchOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            return this.persistBatch(ctx, (Iterable)operation, (RuntimePersistentEntity)this.runtimeEntityRegistry.getEntity(operation.getRootEntity()), null);
        });
    }

    public <T> T update(UpdateOperation<T> operation) {
        return (T)this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            return this.updateOne(ctx, operation.getEntity(), this.runtimeEntityRegistry.getEntity(operation.getRootEntity()));
        });
    }

    public <T> Iterable<T> updateAll(UpdateBatchOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            return this.updateBatch(ctx, (Iterable)operation, (RuntimePersistentEntity)this.runtimeEntityRegistry.getEntity(operation.getRootEntity()));
        });
    }

    public <T> int delete(DeleteOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(operation.getRootEntity());
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            MongoEntityOperation<Object> op = this.createMongoDeleteOneOperation(ctx, persistentEntity, operation.getEntity());
            op.delete();
            return (int)op.modifiedCount;
        });
    }

    public <T> Optional<Number> deleteAll(DeleteBatchOperation<T> operation) {
        return this.withClientSession(clientSession -> {
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(operation.getRootEntity());
            if (operation.all()) {
                MongoDatabase mongoDatabase = this.getDatabase((PersistentEntity)persistentEntity);
                long deletedCount = this.getCollection(mongoDatabase, persistentEntity, persistentEntity.getIntrospection().getBeanType()).deleteMany((Bson)EMPTY).getDeletedCount();
                return Optional.of(deletedCount);
            }
            MongoOperationContext ctx = new MongoOperationContext((ClientSession)clientSession, operation.getAnnotationMetadata(), operation.getRepositoryType());
            MongoEntitiesOperation op = this.createMongoDeleteManyOperation(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)operation);
            op.delete();
            return Optional.of(op.modifiedCount);
        });
    }

    public Optional<Number> executeUpdate(PreparedQuery<?, Number> preparedQuery) {
        return this.withClientSession(clientSession -> {
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(preparedQuery.getRootEntity());
            MongoDatabase database = this.getDatabase((PersistentEntity)persistentEntity);
            Bson update = this.getUpdate(database.getCodecRegistry(), preparedQuery, persistentEntity);
            Bson filter = this.getFilter(database.getCodecRegistry(), preparedQuery, persistentEntity);
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'updateMany' with filter: {} and update: {}", (Object)filter.toBsonDocument().toJson(), (Object)update.toBsonDocument().toJson());
            }
            UpdateResult updateResult = this.getCollection(database, persistentEntity, persistentEntity.getIntrospection().getBeanType()).updateMany(clientSession, filter, update);
            if (preparedQuery.isOptimisticLock()) {
                this.checkOptimisticLocking(1, (int)updateResult.getModifiedCount());
            }
            return Optional.of(updateResult.getModifiedCount());
        });
    }

    public Optional<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.withClientSession(clientSession -> {
            RuntimePersistentEntity persistentEntity = this.runtimeEntityRegistry.getEntity(preparedQuery.getRootEntity());
            MongoDatabase mongoDatabase = this.getDatabase((PersistentEntity)persistentEntity);
            Bson filter = this.getFilter(mongoDatabase.getCodecRegistry(), preparedQuery, persistentEntity);
            if (QUERY_LOG.isDebugEnabled()) {
                QUERY_LOG.debug("Executing Mongo 'deleteMany' with filter: {}", (Object)filter.toBsonDocument().toJson());
            }
            DeleteResult deleteResult = this.getCollection(mongoDatabase, persistentEntity, persistentEntity.getIntrospection().getBeanType()).deleteMany(clientSession, filter);
            if (preparedQuery.isOptimisticLock()) {
                this.checkOptimisticLocking(1, (int)deleteResult.getDeletedCount());
            }
            return Optional.of(deleteResult.getDeletedCount());
        });
    }

    private <K> K triggerPostLoad(AnnotationMetadata annotationMetadata, RuntimePersistentEntity<K> persistentEntity, K entity) {
        if (persistentEntity.hasPostLoadEventListeners()) {
            entity = this.triggerPostLoad(entity, persistentEntity, annotationMetadata);
        }
        block4: for (PersistentProperty pp : persistentEntity.getPersistentProperties()) {
            RuntimeAssociation runtimeAssociation;
            Object o;
            if (!(pp instanceof RuntimeAssociation) || (o = (runtimeAssociation = (RuntimeAssociation)pp).getProperty().get(entity)) == null) continue;
            RuntimePersistentEntity associatedEntity = runtimeAssociation.getAssociatedEntity();
            switch (runtimeAssociation.getKind()) {
                case MANY_TO_MANY: 
                case ONE_TO_MANY: {
                    if (!(o instanceof Iterable)) continue block4;
                    for (Object value : (Iterable)o) {
                        this.triggerPostLoad(value, associatedEntity, annotationMetadata);
                    }
                    continue block4;
                }
                case MANY_TO_ONE: 
                case ONE_TO_ONE: 
                case EMBEDDED: {
                    this.triggerPostLoad(o, associatedEntity, annotationMetadata);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unknown kind: " + runtimeAssociation.getKind());
        }
        return entity;
    }

    private void addStageToPipelineBefore(List<BsonDocument> pipeline, BsonDocument stageToAdd, String ... beforeStages) {
        int lastFoundIndex = -1;
        int index = 0;
        for (BsonDocument stage : pipeline) {
            for (String beforeStageName : beforeStages) {
                if (!stage.containsKey((Object)beforeStageName)) continue;
                lastFoundIndex = index;
                break;
            }
            ++index;
        }
        if (lastFoundIndex > -1) {
            pipeline.add(lastFoundIndex, stageToAdd);
        } else {
            pipeline.add(stageToAdd);
        }
    }

    private <T> Bson getUpdate(CodecRegistry codecRegistry, PreparedQuery<?, ?> preparedQuery, RuntimePersistentEntity<T> persistentEntity) {
        String query = preparedQuery.getUpdate();
        if (query == null) {
            throw new IllegalArgumentException("Update query is not provided!");
        }
        return this.getQuery(codecRegistry, preparedQuery, persistentEntity, query);
    }

    private <T> Bson getFilter(CodecRegistry codecRegistry, PreparedQuery<?, ?> preparedQuery, RuntimePersistentEntity<T> persistentEntity) {
        String query = preparedQuery.getQuery();
        return this.getQuery(codecRegistry, preparedQuery, persistentEntity, query);
    }

    private <T> List<BsonDocument> getPipeline(CodecRegistry codecRegistry, PreparedQuery<?, ?> preparedQuery, RuntimePersistentEntity<T> persistentEntity) {
        String query = preparedQuery.getQuery();
        BsonArray bsonArray = BsonArray.parse((String)query);
        bsonArray = (BsonArray)this.replaceQueryParameters(codecRegistry, preparedQuery, persistentEntity, (BsonValue)bsonArray);
        return bsonArray.stream().map(BsonValue::asDocument).collect(Collectors.toList());
    }

    private <T> BsonDocument getQuery(CodecRegistry codecRegistry, PreparedQuery<?, ?> preparedQuery, RuntimePersistentEntity<T> persistentEntity, String query) {
        if (StringUtils.isEmpty((CharSequence)query)) {
            return EMPTY;
        }
        BsonDocument bsonDocument = BsonDocument.parse((String)query);
        bsonDocument = (BsonDocument)this.replaceQueryParameters(codecRegistry, preparedQuery, persistentEntity, (BsonValue)bsonDocument);
        return bsonDocument;
    }

    private <T> BsonValue replaceQueryParameters(CodecRegistry codecRegistry, PreparedQuery<?, ?> preparedQuery, RuntimePersistentEntity<T> persistentEntity, BsonValue value) {
        if (value instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)value;
            BsonInt32 queryParameterIndex = bsonDocument.getInt32((Object)"$mn_qp", null);
            if (queryParameterIndex != null) {
                int index = queryParameterIndex.getValue();
                return this.getValue(index, (QueryParameterBinding)preparedQuery.getQueryBindings().get(index), preparedQuery, persistentEntity, codecRegistry);
            }
            for (Map.Entry entry : bsonDocument.entrySet()) {
                BsonValue newValue;
                BsonValue bsonValue = (BsonValue)entry.getValue();
                if (bsonValue == (newValue = this.replaceQueryParameters(codecRegistry, preparedQuery, persistentEntity, bsonValue))) continue;
                entry.setValue(newValue);
            }
            return bsonDocument;
        }
        if (value instanceof BsonArray) {
            BsonArray bsonArray = (BsonArray)value;
            for (int i = 0; i < bsonArray.size(); ++i) {
                BsonValue newValue;
                BsonValue bsonValue = bsonArray.get(i);
                if (bsonValue == (newValue = this.replaceQueryParameters(codecRegistry, preparedQuery, persistentEntity, bsonValue))) continue;
                if (newValue.isNull()) {
                    bsonArray.remove(i);
                    --i;
                    continue;
                }
                if (newValue.isArray()) {
                    bsonArray.remove(i);
                    List values = newValue.asArray().getValues();
                    bsonArray.addAll(i, (Collection)values);
                    i += values.size() - 1;
                    continue;
                }
                bsonArray.set(i, newValue);
            }
        }
        return value;
    }

    private <T> BsonValue getValue(int index, QueryParameterBinding queryParameterBinding, PreparedQuery<?, ?> preparedQuery, RuntimePersistentEntity<T> persistentEntity, CodecRegistry codecRegistry) {
        Object value;
        Class parameterConverter = queryParameterBinding.getParameterConverterClass();
        if (queryParameterBinding.getParameterIndex() != -1) {
            value = this.resolveParameterValue(queryParameterBinding, preparedQuery.getParameterArray());
        } else if (queryParameterBinding.isAutoPopulated()) {
            PersistentPropertyPath pp = this.getRequiredPropertyPath(queryParameterBinding, persistentEntity);
            RuntimePersistentProperty persistentProperty = (RuntimePersistentProperty)pp.getProperty();
            Object previousValue = null;
            QueryParameterBinding previousPopulatedValueParameter = queryParameterBinding.getPreviousPopulatedValueParameter();
            if (previousPopulatedValueParameter != null) {
                if (previousPopulatedValueParameter.getParameterIndex() == -1) {
                    throw new IllegalStateException("Previous value parameter cannot be bind!");
                }
                previousValue = this.resolveParameterValue(previousPopulatedValueParameter, preparedQuery.getParameterArray());
            }
            value = this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
            value = this.convert(value, persistentProperty);
            parameterConverter = null;
        } else {
            throw new IllegalStateException("Invalid query []. Unable to establish parameter value for parameter at position: " + (index + 1));
        }
        DataType dataType = queryParameterBinding.getDataType();
        List<Object> values = this.expandValue(value, dataType);
        if (values != null && values.isEmpty()) {
            value = null;
            values = null;
        }
        if (values == null) {
            if (parameterConverter != null) {
                int parameterIndex = queryParameterBinding.getParameterIndex();
                Argument argument = parameterIndex > -1 ? preparedQuery.getArguments()[parameterIndex] : null;
                value = this.convert(parameterConverter, value, argument);
            }
            if (value instanceof String) {
                RuntimeAssociation runtimeAssociation;
                RuntimePersistentProperty identity;
                PersistentPropertyPath pp = this.getRequiredPropertyPath(queryParameterBinding, persistentEntity);
                RuntimePersistentProperty persistentProperty = (RuntimePersistentProperty)pp.getProperty();
                if (persistentProperty instanceof RuntimeAssociation && (identity = (runtimeAssociation = (RuntimeAssociation)persistentProperty).getAssociatedEntity().getIdentity()) != null && identity.getType() == String.class && identity.isGenerated()) {
                    return new BsonObjectId(new ObjectId((String)value));
                }
                if (persistentProperty.getOwner().getIdentity() == persistentProperty && persistentProperty.getType() == String.class && persistentProperty.isGenerated()) {
                    return new BsonObjectId(new ObjectId((String)value));
                }
            }
            return MongoUtils.toBsonValue(this.conversionService, value, codecRegistry);
        }
        Class finalParameterConverter = parameterConverter;
        return new BsonArray(values.stream().map(val -> {
            if (finalParameterConverter != null) {
                int parameterIndex = queryParameterBinding.getParameterIndex();
                Argument argument = parameterIndex > -1 ? preparedQuery.getArguments()[parameterIndex] : null;
                val = this.convert(finalParameterConverter, val, argument);
            }
            return MongoUtils.toBsonValue(this.conversionService, val, codecRegistry);
        }).collect(Collectors.toList()));
    }

    private Object convert(Class<?> converterClass, Object value, @Nullable Argument<?> argument) {
        if (converterClass == null) {
            return value;
        }
        AttributeConverter converter = this.attributeConverterRegistry.getConverter(converterClass);
        ConversionContext conversionContext = this.createTypeConversionContext(null, null, argument);
        return converter.convertToPersistedValue(value, conversionContext);
    }

    private Object convert(Object value, RuntimePersistentProperty<?> property) {
        AttributeConverter converter = property.getConverter();
        if (converter != null) {
            return converter.convertToPersistedValue(value, this.createTypeConversionContext(null, property, property.getArgument()));
        }
        return value;
    }

    private <T> PersistentPropertyPath getRequiredPropertyPath(QueryParameterBinding queryParameterBinding, RuntimePersistentEntity<T> persistentEntity) {
        CharSequence[] propertyPath = queryParameterBinding.getRequiredPropertyPath();
        PersistentPropertyPath pp = persistentEntity.getPropertyPath((String[])propertyPath);
        if (pp == null) {
            throw new IllegalStateException("Cannot find auto populated property: " + String.join((CharSequence)".", propertyPath));
        }
        return pp;
    }

    private List<Object> expandValue(Object value, DataType dataType) {
        if (value == null || dataType != null && dataType.isArray() && dataType != DataType.BYTE_ARRAY || value instanceof byte[]) {
            return null;
        }
        if (value instanceof Iterable) {
            return CollectionUtils.iterableToList((Iterable)((Iterable)value));
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            if (len == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int j = 0; j < len; ++j) {
                Object o = Array.get(value, j);
                list.add(o);
            }
            return list;
        }
        return null;
    }

    private Object resolveParameterValue(QueryParameterBinding queryParameterBinding, Object[] parameterArray) {
        Object value = parameterArray[queryParameterBinding.getParameterIndex()];
        String[] parameterBindingPath = queryParameterBinding.getParameterBindingPath();
        if (parameterBindingPath != null) {
            for (String prop : parameterBindingPath) {
                if (value == null) {
                    return null;
                }
                Object finalValue = value;
                BeanProperty beanProperty = (BeanProperty)BeanIntrospection.getIntrospection(value.getClass()).getProperty(prop).orElseThrow(() -> new IntrospectionException("Cannot find a property: '" + prop + "' on bean: " + finalValue));
                value = beanProperty.get(value);
            }
        }
        return value;
    }

    protected ConversionContext createTypeConversionContext(ClientSession connection, RuntimePersistentProperty<?> property, Argument<?> argument) {
        if (argument != null) {
            return ConversionContext.of(argument);
        }
        return ConversionContext.DEFAULT;
    }

    public void setStatementParameter(Object preparedStatement, int index, DataType dataType, Object value, Dialect dialect) {
    }

    private <T, R> MongoCollection<R> getCollection(MongoDatabase database, RuntimePersistentEntity<T> persistentEntity, Class<R> resultType) {
        return database.getCollection(persistentEntity.getPersistedName(), resultType);
    }

    private MongoDatabase getDatabase(PersistentEntity persistentEntity) {
        return this.mongoDatabaseFactory.getDatabase(persistentEntity);
    }

    public <T> T persistOne(MongoOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        MongoEntityOperation<T> op = this.createMongoInsertOneOperation(ctx, persistentEntity, value);
        op.persist();
        return (T)op.getEntity();
    }

    public <T> List<T> persistBatch(MongoOperationContext ctx, Iterable<T> values, RuntimePersistentEntity<T> persistentEntity, Predicate<T> predicate) {
        MongoEntitiesOperation<T> op = this.createMongoInsertManyOperation(ctx, persistentEntity, values);
        if (predicate != null) {
            op.veto(predicate);
        }
        op.persist();
        return op.getEntities();
    }

    public <T> T updateOne(MongoOperationContext ctx, T value, RuntimePersistentEntity<T> persistentEntity) {
        MongoEntityOperation<T> op = this.createMongoReplaceOneOperation(ctx, persistentEntity, value);
        op.update();
        return (T)op.getEntity();
    }

    private <T> List<T> updateBatch(MongoOperationContext ctx, Iterable<T> values, RuntimePersistentEntity<T> persistentEntity) {
        MongoEntitiesOperation<T> op = this.createMongoReplaceManyOperation(ctx, persistentEntity, values);
        op.update();
        return op.getEntities();
    }

    public void persistManyAssociation(MongoOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        String joinCollectionName = runtimeAssociation.getOwner().getNamingStrategy().mappedName((Association)runtimeAssociation);
        MongoDatabase mongoDatabase = this.getDatabase((PersistentEntity)persistentEntity);
        MongoCollection collection = mongoDatabase.getCollection(joinCollectionName, BsonDocument.class);
        BsonDocument association = this.association((MongoCollection<BsonDocument>)collection, value, persistentEntity, child, childPersistentEntity);
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'insertOne' for collection: {} with document: {}", (Object)collection.getNamespace().getFullName(), (Object)association);
        }
        collection.insertOne(ctx.clientSession, (Object)association);
    }

    public void persistManyAssociationBatch(MongoOperationContext ctx, RuntimeAssociation runtimeAssociation, Object value, RuntimePersistentEntity<Object> persistentEntity, Iterable<Object> child, RuntimePersistentEntity<Object> childPersistentEntity) {
        String joinCollectionName = runtimeAssociation.getOwner().getNamingStrategy().mappedName((Association)runtimeAssociation);
        MongoCollection collection = this.getDatabase((PersistentEntity)persistentEntity).getCollection(joinCollectionName, BsonDocument.class);
        ArrayList<BsonDocument> associations = new ArrayList<BsonDocument>();
        for (Object c : child) {
            associations.add(this.association((MongoCollection<BsonDocument>)collection, value, persistentEntity, c, childPersistentEntity));
        }
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Mongo 'insertMany' for collection: {} with documents: {}", (Object)collection.getNamespace().getFullName(), associations);
        }
        collection.insertMany(ctx.clientSession, associations);
    }

    private BsonDocument association(MongoCollection<BsonDocument> collection, Object value, RuntimePersistentEntity<Object> persistentEntity, Object child, RuntimePersistentEntity<Object> childPersistentEntity) {
        BsonDocument document = new BsonDocument();
        document.put(persistentEntity.getPersistedName(), MongoUtils.entityIdValue(this.conversionService, persistentEntity, value, collection.getCodecRegistry()));
        document.put(childPersistentEntity.getPersistedName(), MongoUtils.entityIdValue(this.conversionService, childPersistentEntity, child, collection.getCodecRegistry()));
        return document;
    }

    private <T> T withClientSession(Function<ClientSession, T> function) {
        ClientSession clientSession = this.transactionManager.findClientSession();
        if (clientSession != null) {
            return function.apply(clientSession);
        }
        try (ClientSession cs = this.mongoClient.startSession();){
            T t = function.apply(cs);
            return t;
        }
    }

    private <T> MongoEntityOperation<T> createMongoInsertOneOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity) {
        return new MongoEntityOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Object)entity, true){

            protected void execute() throws RuntimeException {
                MongoDatabase mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity);
                MongoCollection collection = DefaultMongoRepositoryOperations.this.getCollection(mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType());
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Mongo 'insertOne' with entity: {}", this.entity);
                }
                InsertOneResult insertOneResult = collection.insertOne(((MongoOperationContext)this.ctx).clientSession, this.entity);
                BsonValue insertedId = insertOneResult.getInsertedId();
                BeanProperty property = this.persistentEntity.getIdentity().getProperty();
                if (property.get(this.entity) == null) {
                    this.entity = this.updateEntityId(property, this.entity, insertedId);
                }
            }
        };
    }

    private <T> MongoEntityOperation<T> createMongoReplaceOneOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity) {
        return new MongoEntityOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Object)entity, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<BsonDocument> collection;
            Bson filter;
            {
                this.mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity);
                this.collection = DefaultMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, BsonDocument.class);
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.filter = MongoUtils.filterByIdAndVersion(this.conversionService, this.persistentEntity, this.entity, this.collection.getCodecRegistry());
            }

            protected void execute() throws RuntimeException {
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Mongo 'replaceOne' with filter: {}", (Object)this.filter.toBsonDocument().toJson());
                }
                BsonDocument bsonDocument = BsonDocumentWrapper.asBsonDocument((Object)this.entity, (CodecRegistry)this.mongoDatabase.getCodecRegistry());
                bsonDocument.remove((Object)"_id");
                UpdateResult updateResult = this.collection.replaceOne(((MongoOperationContext)this.ctx).clientSession, this.filter, (Object)bsonDocument);
                this.modifiedCount = updateResult.getModifiedCount();
                if (this.persistentEntity.getVersion() != null) {
                    this.checkOptimisticLocking(1, (int)this.modifiedCount);
                }
            }
        };
    }

    private <T> MongoEntitiesOperation<T> createMongoReplaceManyOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
        return new MongoEntitiesOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)entities, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<BsonDocument> collection;
            Map<AbstractSyncEntitiesOperations.Data, Bson> filters;
            {
                this.mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity);
                this.collection = DefaultMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, BsonDocument.class);
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.filters = this.entities.stream().collect(Collectors.toMap(d -> d, d -> MongoUtils.filterByIdAndVersion(this.conversionService, this.persistentEntity, d.entity, this.collection.getCodecRegistry())));
            }

            protected void execute() throws RuntimeException {
                int expectedToBeUpdated = 0;
                for (AbstractSyncEntitiesOperations.Data d : this.entities) {
                    if (d.vetoed) continue;
                    ++expectedToBeUpdated;
                    Bson filter = this.filters.get(d);
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing Mongo 'replaceOne' with filter: {}", (Object)filter.toBsonDocument().toJson());
                    }
                    BsonDocument bsonDocument = BsonDocumentWrapper.asBsonDocument((Object)d.entity, (CodecRegistry)this.mongoDatabase.getCodecRegistry());
                    bsonDocument.remove((Object)"_id");
                    UpdateResult updateResult = this.collection.replaceOne(((MongoOperationContext)this.ctx).clientSession, filter, (Object)bsonDocument);
                    this.modifiedCount += updateResult.getModifiedCount();
                }
                if (this.persistentEntity.getVersion() != null) {
                    this.checkOptimisticLocking(expectedToBeUpdated, (int)this.modifiedCount);
                }
            }
        };
    }

    private <T> MongoEntityOperation<T> createMongoDeleteOneOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity) {
        return new MongoEntityOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Object)entity, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<T> collection;
            Bson filter;
            {
                this.mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity);
                this.collection = DefaultMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType());
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.filter = MongoUtils.filterByIdAndVersion(this.conversionService, this.persistentEntity, this.entity, this.collection.getCodecRegistry());
            }

            protected void execute() throws RuntimeException {
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Mongo 'deleteOne' with filter: {}", (Object)this.filter.toBsonDocument().toJson());
                }
                DeleteResult deleteResult = this.collection.deleteOne(((MongoOperationContext)this.ctx).clientSession, this.filter);
                this.modifiedCount = deleteResult.getDeletedCount();
                if (this.persistentEntity.getVersion() != null) {
                    this.checkOptimisticLocking(1, (int)this.modifiedCount);
                }
            }
        };
    }

    private <T> MongoEntitiesOperation<T> createMongoDeleteManyOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
        return new MongoEntitiesOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)entities, false){
            final MongoDatabase mongoDatabase;
            final MongoCollection<T> collection;
            Map<AbstractSyncEntitiesOperations.Data, Bson> filters;
            {
                this.mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity);
                this.collection = DefaultMongoRepositoryOperations.this.getCollection(this.mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType());
            }

            @Override
            protected void collectAutoPopulatedPreviousValues() {
                this.filters = this.entities.stream().collect(Collectors.toMap(d -> d, d -> MongoUtils.filterByIdAndVersion(this.conversionService, this.persistentEntity, d.entity, this.collection.getCodecRegistry())));
            }

            protected void execute() throws RuntimeException {
                List filters = this.entities.stream().filter(d -> !d.vetoed).map(d -> this.filters.get(d)).collect(Collectors.toList());
                if (!filters.isEmpty()) {
                    Bson filter = Filters.or(filters);
                    if (QUERY_LOG.isDebugEnabled()) {
                        QUERY_LOG.debug("Executing Mongo 'deleteMany' with filter: {}", (Object)filter.toBsonDocument().toJson());
                    }
                    DeleteResult deleteResult = this.collection.deleteMany(((MongoOperationContext)this.ctx).clientSession, filter);
                    this.modifiedCount = deleteResult.getDeletedCount();
                }
                if (this.persistentEntity.getVersion() != null) {
                    int expected = (int)this.entities.stream().filter(d -> !d.vetoed).count();
                    this.checkOptimisticLocking(expected, (int)this.modifiedCount);
                }
            }
        };
    }

    private <T> MongoEntitiesOperation<T> createMongoInsertManyOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities) {
        return new MongoEntitiesOperation<T>(ctx, (RuntimePersistentEntity)persistentEntity, (Iterable)entities, true){

            protected void execute() throws RuntimeException {
                List toInsert = this.entities.stream().filter(d -> !d.vetoed).map(d -> d.entity).collect(Collectors.toList());
                if (toInsert.isEmpty()) {
                    return;
                }
                if (QUERY_LOG.isDebugEnabled()) {
                    QUERY_LOG.debug("Executing Mongo 'insertMany' with entities: {}", toInsert);
                }
                MongoDatabase mongoDatabase = DefaultMongoRepositoryOperations.this.getDatabase((PersistentEntity)this.persistentEntity);
                InsertManyResult insertManyResult = DefaultMongoRepositoryOperations.this.getCollection(mongoDatabase, this.persistentEntity, this.persistentEntity.getIntrospection().getBeanType()).insertMany(((MongoOperationContext)this.ctx).clientSession, toInsert);
                if (this.hasGeneratedId) {
                    Map insertedIds = insertManyResult.getInsertedIds();
                    RuntimePersistentProperty identity = this.persistentEntity.getIdentity();
                    BeanProperty idProperty = identity.getProperty();
                    int index = 0;
                    for (AbstractSyncEntitiesOperations.Data d2 : this.entities) {
                        if (!d2.vetoed) {
                            BsonValue id = (BsonValue)insertedIds.get(index);
                            if (id == null) {
                                throw new DataAccessException("Failed to generate ID for entity: " + d2.entity);
                            }
                            d2.entity = this.updateEntityId(idProperty, d2.entity, id);
                        }
                        ++index;
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            DefaultMongoRepositoryOperations defaultMongoRepositoryOperations = this;
            synchronized (defaultMongoRepositoryOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        return new ExecutorReactiveOperations(this.async(), this.conversionService);
    }

    protected static class MongoOperationContext
    extends OperationContext {
        private final ClientSession clientSession;

        public MongoOperationContext(ClientSession clientSession, AnnotationMetadata annotationMetadata, Class<?> repositoryType) {
            super(annotationMetadata, repositoryType);
            this.clientSession = clientSession;
        }
    }

    private abstract class MongoEntitiesOperation<T>
    extends AbstractSyncEntitiesOperations<MongoOperationContext, T, RuntimeException> {
        protected long modifiedCount;

        protected MongoEntitiesOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, Iterable<T> entities, boolean insert) {
            super((OperationContext)ctx, DefaultMongoRepositoryOperations.this.cascadeOperations, (ConversionService)DefaultMongoRepositoryOperations.this.conversionService, DefaultMongoRepositoryOperations.this.entityEventRegistry, persistentEntity, entities, insert);
        }

        protected void collectAutoPopulatedPreviousValues() {
        }
    }

    private abstract class MongoEntityOperation<T>
    extends AbstractSyncEntityOperations<MongoOperationContext, T, RuntimeException> {
        protected long modifiedCount;

        protected MongoEntityOperation(MongoOperationContext ctx, RuntimePersistentEntity<T> persistentEntity, T entity, boolean insert) {
            super((OperationContext)ctx, DefaultMongoRepositoryOperations.this.cascadeOperations, DefaultMongoRepositoryOperations.this.entityEventRegistry, persistentEntity, (ConversionService)DefaultMongoRepositoryOperations.this.conversionService, entity, insert);
        }

        protected void collectAutoPopulatedPreviousValues() {
        }
    }
}

