/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.init;

import com.mongodb.client.MongoDatabase;
import io.micronaut.configuration.mongo.core.AbstractMongoConfiguration;
import io.micronaut.configuration.mongo.core.DefaultMongoConfiguration;
import io.micronaut.configuration.mongo.core.NamedMongoConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.mongodb.database.MongoDatabaseFactory;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context
@Internal
@Requires(property="micronaut.data.mongo.create-collections", value="true")
public final class MongoCollectionsCreator {
    private static final Logger LOG = LoggerFactory.getLogger(MongoCollectionsCreator.class);

    @PostConstruct
    void initialize(BeanLocator beanLocator, RuntimeEntityRegistry runtimeEntityRegistry, List<AbstractMongoConfiguration> mongoConfigurations) {
        for (AbstractMongoConfiguration mongoConfiguration : mongoConfigurations) {
            MongoDatabaseFactory mongoDatabaseFactory;
            Collection introspections = BeanIntrospector.SHARED.findIntrospections(MappedEntity.class);
            PersistentEntity[] entities = (PersistentEntity[])introspections.stream().filter(i -> !i.getBeanType().getName().contains("$")).filter(i -> !Modifier.isAbstract(i.getBeanType().getModifiers())).map(e -> runtimeEntityRegistry.getEntity(e.getBeanType())).toArray(PersistentEntity[]::new);
            if (mongoConfiguration instanceof DefaultMongoConfiguration) {
                mongoDatabaseFactory = (MongoDatabaseFactory)beanLocator.getBean(MongoDatabaseFactory.class);
            } else if (mongoConfiguration instanceof NamedMongoConfiguration) {
                Qualifier qualifier = Qualifiers.byName((String)((NamedMongoConfiguration)mongoConfiguration).getServerName());
                mongoDatabaseFactory = (MongoDatabaseFactory)beanLocator.getBean(MongoDatabaseFactory.class, qualifier);
            } else {
                throw new IllegalStateException("Cannot get Mongo client for unrecognized configuration: " + mongoConfiguration);
            }
            HashMap<String, Set> databaseCollections = new HashMap<String, Set>();
            for (PersistentEntity entity : entities) {
                String persistedName;
                MongoDatabase database = mongoDatabaseFactory.getDatabase(entity);
                Set collections = databaseCollections.computeIfAbsent(database.getName(), s -> (HashSet)database.listCollectionNames().into(new HashSet()));
                if (collections.add(persistedName = entity.getPersistedName())) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Creating collection: {} in database: {}", (Object)persistedName, (Object)database.getName());
                    }
                    database.createCollection(persistedName);
                }
                for (PersistentProperty persistentProperty : entity.getPersistentProperties()) {
                    if (!(persistentProperty instanceof Association)) continue;
                    Association association = (Association)persistentProperty;
                    Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
                    if (association.getKind() != Relation.Kind.MANY_TO_MANY && (!association.isForeignKey() || inverseSide.isPresent())) continue;
                    Association owningAssociation = inverseSide.orElse(association);
                    NamingStrategy namingStrategy = association.getOwner().getNamingStrategy();
                    String joinCollectionName = namingStrategy.mappedName(owningAssociation);
                    if (!collections.add(joinCollectionName)) continue;
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Creating collection: {} in database: {}", (Object)persistedName, (Object)database.getName());
                    }
                    database.createCollection(joinCollectionName);
                }
            }
        }
    }
}

