/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.repository.jpa.criteria;

import io.micronaut.data.repository.jpa.criteria.SpecificationComposition;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import org.jspecify.annotations.Nullable;

public interface PredicateSpecification<T> {
    public static final PredicateSpecification<?> ALL = (root, criteriaBuilder) -> null;

    public static <T> PredicateSpecification<T> where(@Nullable PredicateSpecification<T> spec) {
        if (spec == null) {
            return ALL;
        }
        return spec;
    }

    public static <T> PredicateSpecification<T> not(@Nullable PredicateSpecification<T> spec) {
        if (spec == null) {
            return ALL;
        }
        return (root, criteriaBuilder) -> criteriaBuilder.not((Expression)spec.toPredicate(root, criteriaBuilder));
    }

    default public PredicateSpecification<T> and(@Nullable PredicateSpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    default public PredicateSpecification<T> or(@Nullable PredicateSpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    public @Nullable Predicate toPredicate(Root<T> var1, CriteriaBuilder var2);
}

