/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations.reactive;

import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.reactive.ReactorReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Mono;

public interface BlockingExecutorReactorRepositoryOperations
extends RepositoryOperations,
ReactorReactiveCapableRepository {
    public <T> T block(Function<ReactorReactiveRepositoryOperations, Mono<T>> var1);

    public <T> Optional<T> blockOptional(Function<ReactorReactiveRepositoryOperations, Mono<T>> var1);

    @Override
    default public <T> @Nullable T findOne(Class<T> type, Object id) {
        return this.block(reactive -> reactive.findOne(type, id));
    }

    @Override
    default public <T, R> @Nullable R findOne(PreparedQuery<T, R> preparedQuery) {
        return (R)this.block(reactive -> reactive.findOne(preparedQuery));
    }

    @Override
    default public <T, R> Iterable<R> findAll(PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.block(reactive -> reactive.findAll(preparedQuery).collectList());
    }

    @Override
    default public <T, R> Stream<R> findStream(PreparedQuery<T, R> preparedQuery) {
        return ((List)this.block(reactive -> reactive.findAll(preparedQuery).collectList())).stream();
    }

    @Override
    default public <T> T persist(InsertOperation<T> operation) {
        return (T)this.blockOptional(reactive -> reactive.persist(operation)).orElseGet(operation::getEntity);
    }

    @Override
    default public <T> T update(UpdateOperation<T> operation) {
        return (T)this.blockOptional(reactive -> reactive.update(operation)).orElseGet(operation::getEntity);
    }

    @Override
    default public <T> Iterable<T> updateAll(UpdateBatchOperation<T> operation) {
        return this.blockOptional(reactive -> reactive.updateAll(operation).collectList().map(it -> it)).orElse(operation);
    }

    @Override
    default public <T> Iterable<T> persistAll(InsertBatchOperation<T> operation) {
        return this.blockOptional(reactive -> reactive.persistAll(operation).collectList().map(it -> it)).orElse(operation);
    }

    @Override
    default public Optional<Number> executeUpdate(PreparedQuery<?, Number> preparedQuery) {
        return this.blockOptional(reactive -> reactive.executeUpdate(preparedQuery));
    }

    @Override
    default public Optional<Number> executeDelete(PreparedQuery<?, Number> preparedQuery) {
        return this.blockOptional(reactive -> reactive.executeDelete(preparedQuery));
    }

    @Override
    default public <R> List<R> execute(PreparedQuery<?, R> preparedQuery) {
        return (List)this.block(reactive -> reactive.execute(preparedQuery).collectList());
    }

    @Override
    default public <T> int delete(DeleteOperation<T> operation) {
        return ((Number)this.blockOptional(reactive -> reactive.delete(operation)).orElse(0)).intValue();
    }

    @Override
    default public <T> Optional<Number> deleteAll(DeleteBatchOperation<T> operation) {
        return this.blockOptional(reactive -> reactive.deleteAll(operation));
    }

    @Override
    default public <T> boolean exists(PreparedQuery<T, Boolean> preparedQuery) {
        return this.blockOptional(reactive -> reactive.exists(preparedQuery)).orElse(false);
    }

    @Override
    default public <R> Page<R> findPage(PagedQuery<R> query) {
        return (Page)this.block(reactive -> reactive.findPage(query));
    }

    @Override
    default public <T> Iterable<T> findAll(PagedQuery<T> query) {
        return (Iterable)this.block(reactive -> reactive.findAll(query).collectList());
    }

    @Override
    default public <T> long count(PagedQuery<T> pagedQuery) {
        return this.blockOptional(reactive -> reactive.count(pagedQuery)).orElse(0L);
    }

    @Override
    default public <T> Stream<T> findStream(PagedQuery<T> query) {
        return ((List)this.block(reactive -> reactive.findAll(query).collectList())).stream();
    }
}

