/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.runtime;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.DefaultArgument;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@Internal
public final class BeanPropertyWithAnnotationMetadata<B, T>
implements BeanProperty<B, T> {
    private final String name;
    private final BeanProperty<B, T> delegate;
    private final Argument<T> argument;
    private final AnnotationMetadata annotationMetadata;

    public BeanPropertyWithAnnotationMetadata(BeanProperty<B, T> delegate, AnnotationMetadata annotationMetadata) {
        this(delegate.getName(), delegate, annotationMetadata);
    }

    public BeanPropertyWithAnnotationMetadata(String name, BeanProperty<B, T> delegate, AnnotationMetadata annotationMetadata) {
        this.name = name;
        this.delegate = delegate;
        this.annotationMetadata = annotationMetadata;
        Argument originalArgument = delegate.asArgument();
        this.argument = new DefaultArgument(originalArgument.getType(), originalArgument.getName(), annotationMetadata, originalArgument.getTypeVariables(), originalArgument.getTypeParameters());
    }

    public BeanIntrospection<B> getDeclaringBean() {
        return this.delegate.getDeclaringBean();
    }

    public @Nullable T get(B bean) {
        return (T)this.delegate.get(bean);
    }

    public <T2> Optional<T2> get(B bean, Class<T2> type) {
        return this.delegate.get(bean, type);
    }

    public <T2> Optional<T2> get(B bean, Argument<T2> argument) {
        return this.delegate.get(bean, argument);
    }

    public <T2> Optional<T2> get(B bean, ArgumentConversionContext<T2> conversionContext) {
        return this.delegate.get(bean, conversionContext);
    }

    public <T2> @Nullable T2 get(B bean, Class<T2> type, @Nullable T2 defaultValue) {
        return (T2)this.delegate.get(bean, type, defaultValue);
    }

    public boolean hasSetterOrConstructorArgument() {
        return this.delegate.hasSetterOrConstructorArgument();
    }

    public B withValue(B bean, @Nullable T value) {
        return (B)this.delegate.withValue(bean, value);
    }

    public void set(B bean, @Nullable T value) {
        this.delegate.set(bean, value);
    }

    public void convertAndSet(B bean, @Nullable Object value) {
        this.delegate.convertAndSet(bean, value);
    }

    public Class<T> getType() {
        return this.delegate.getType();
    }

    public Argument<T> asArgument() {
        return this.argument;
    }

    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    public boolean isWriteOnly() {
        return this.delegate.isWriteOnly();
    }

    public boolean isReadWrite() {
        return this.delegate.isReadWrite();
    }

    public Class<B> getDeclaringType() {
        return this.delegate.getDeclaringType();
    }

    public String getName() {
        return this.name;
    }

    public boolean isDeclaredNullable() {
        return this.delegate.isDeclaredNullable();
    }

    public boolean isNullable() {
        return this.delegate.isNullable();
    }

    public boolean isNonNull() {
        return this.delegate.isNonNull();
    }

    public boolean isDeclaredNonNull() {
        return this.delegate.isDeclaredNonNull();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }
}

