/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.annotation.Index;
import io.micronaut.data.annotation.Indexes;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilderUtils;
import io.micronaut.data.model.schema.sql.SqlColumnMapping;
import io.micronaut.data.model.schema.sql.SqlDbType;
import io.micronaut.data.model.schema.sql.SqlIndexMapping;
import io.micronaut.data.model.schema.sql.SqlSequenceMapping;
import io.micronaut.data.model.schema.sql.SqlTableMapping;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

@Internal
public final class SqlSchemaUtils {
    public static final String TABLE_TYPE = "TABLE";
    public static final String TABLE_CATALOG_COLUMN = "TABLE_CAT";
    public static final String TABLE_SCHEMA_COLUMN = "TABLE_SCHEM";
    public static final String TABLE_NAME_COLUMN = "TABLE_NAME";
    public static final String COLUMN_NAME_COLUMN = "COLUMN_NAME";
    public static final String DATA_TYPE_COLUMN = "DATA_TYPE";
    public static final String TYPE_NAME_COLUMN = "TYPE_NAME";
    public static final String COLUMN_SIZE_COLUMN = "COLUMN_SIZE";
    public static final String DECIMAL_DIGITS_COLUMN = "DECIMAL_DIGITS";
    public static final String NULLABLE_COLUMN = "NULLABLE";

    private SqlSchemaUtils() {
    }

    public static List<SqlTableMapping> getSqlTableMappings(PersistentEntity entity) {
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        String tableName = entity.getPersistedName();
        String schema = SqlQueryBuilderUtils.getSchemaName(entity);
        boolean escape = entity.getAnnotationMetadata().booleanValue(MappedEntity.class, "escape").orElse(true);
        ArrayList<SqlTableMapping> tables = new ArrayList<SqlTableMapping>();
        Collection<Association> foreignKeyAssociations = SqlQueryBuilderUtils.getJoinTableAssociations(entity);
        NamingStrategy namingStrategy = entity.getNamingStrategy();
        if (CollectionUtils.isNotEmpty(foreignKeyAssociations)) {
            for (Association association : foreignKeyAssociations) {
                String columnName;
                PersistentPropertyPath pp2;
                int i;
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                ArrayList<SqlColumnMapping> columns = new ArrayList<SqlColumnMapping>();
                Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
                Association owningAssociation = inverseSide.orElse(association);
                AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
                String joinTableName = annotationMetadata.stringValue("io.micronaut.data.annotation.sql.JoinTable", "name").orElseGet(() -> namingStrategy.mappedName(association));
                String joinTableSchema = annotationMetadata.stringValue("io.micronaut.data.annotation.sql.JoinTable", "schema").orElse(null);
                if (!StringUtils.isNotEmpty((CharSequence)joinTableSchema)) {
                    joinTableSchema = schema;
                }
                ArrayList leftProperties = new ArrayList();
                ArrayList rightProperties = new ArrayList();
                boolean isAssociationOwner = inverseSide.isEmpty();
                List<String> leftJoinTableColumns = SqlQueryBuilderUtils.resolveJoinTableJoinColumns(annotationMetadata, isAssociationOwner, entity, namingStrategy);
                List<String> rightJoinTableColumns = SqlQueryBuilderUtils.resolveJoinTableJoinColumns(annotationMetadata, !isAssociationOwner, association.getAssociatedEntity(), namingStrategy);
                PersistentProperty property2 = entity.getIdentity();
                PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), property2, (associations1, property3) -> leftProperties.add(PersistentPropertyPath.of(associations1, property3, "")));
                PersistentProperty property1 = associatedEntity.getIdentity();
                PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), property1, (associations, property) -> rightProperties.add(PersistentPropertyPath.of(associations, property, "")));
                if (leftJoinTableColumns.size() == leftProperties.size()) {
                    for (i = 0; i < leftJoinTableColumns.size(); ++i) {
                        pp2 = (PersistentPropertyPath)leftProperties.get(i);
                        columnName = leftJoinTableColumns.get(i);
                        columns.add(SqlSchemaUtils.getColumnDefinition(pp2.getProperty(), columnName, false, true, true));
                    }
                } else {
                    for (PersistentPropertyPath pp2 : leftProperties) {
                        columnName = namingStrategy.mappedJoinTableColumn(entity, pp2.getAssociations(), pp2.getProperty());
                        columns.add(SqlSchemaUtils.getColumnDefinition(pp2.getProperty(), columnName, false, true, true));
                    }
                }
                if (rightJoinTableColumns.size() == rightProperties.size()) {
                    for (i = 0; i < rightJoinTableColumns.size(); ++i) {
                        pp2 = (PersistentPropertyPath)rightProperties.get(i);
                        columnName = rightJoinTableColumns.get(i);
                        columns.add(SqlSchemaUtils.getColumnDefinition(pp2.getProperty(), columnName, false, true, true));
                    }
                } else {
                    for (PersistentPropertyPath pp2 : rightProperties) {
                        columnName = namingStrategy.mappedJoinTableColumn(entity, pp2.getAssociations(), pp2.getProperty());
                        columns.add(SqlSchemaUtils.getColumnDefinition(pp2.getProperty(), columnName, false, true, true));
                    }
                }
                SqlTableMapping joinTable = new SqlTableMapping(joinTableSchema, joinTableName, escape, SqlTableMapping.TableType.JOIN, null, columns);
                tables.add(joinTable);
            }
        }
        List<PersistentProperty> identities = entity.getIdentityProperties();
        List<SqlColumnMapping> primaryKeyColumns = SqlSchemaUtils.getPrimaryKeyColumns(identities, namingStrategy);
        ArrayList<SqlColumnMapping> columns = new ArrayList<SqlColumnMapping>();
        PersistentProperty version = entity.getVersion();
        if (version != null && !version.isGenerated()) {
            String columnName = namingStrategy.mappedName(Collections.emptyList(), version);
            SqlColumnMapping column = SqlSchemaUtils.getColumnDefinition(version, columnName, false, true, false);
            columns.add(column);
        }
        BiConsumer<List<Association>, PersistentProperty> addColumn = (associations, property) -> {
            String columnName = namingStrategy.mappedName((List<Association>)associations, (PersistentProperty)property);
            SqlColumnMapping column = SqlSchemaUtils.getColumnDefinition(property, columnName, false, SqlSchemaUtils.isRequired(associations, property), !SqlQueryBuilderUtils.isNotForeign(associations));
            columns.add(column);
        };
        for (PersistentProperty persistentProperty : entity.getPersistentProperties()) {
            PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), persistentProperty, addColumn);
        }
        List<SqlSequenceMapping> sequences = SqlSchemaUtils.getSqlSequenceMappings(identities);
        List<SqlIndexMapping> list = SqlSchemaUtils.getSqlIndexMappings(entity);
        SqlTableMapping table = new SqlTableMapping(schema, tableName, escape, SqlTableMapping.TableType.MAIN, primaryKeyColumns, columns, sequences, list);
        tables.add(table);
        return tables;
    }

    private static SqlColumnMapping getColumnDefinition(PersistentProperty prop, String column, boolean primaryKey, boolean required, boolean isForeign) {
        if (prop instanceof Association) {
            throw new IllegalStateException("Association is not supported here");
        }
        AnnotationMetadata annotationMetadata = prop.getAnnotationMetadata();
        String definition = annotationMetadata.stringValue(MappedProperty.class, "definition").orElse(null);
        DataType dataType = prop.getDataType();
        boolean autoGenerated = !isForeign && prop.isGenerated();
        GeneratedValue.Type generatedValueType = autoGenerated ? prop.getAnnotationMetadata().enumValue(GeneratedValue.class, GeneratedValue.Type.class).orElse(GeneratedValue.Type.AUTO) : null;
        OptionalInt optPrecision = SqlQueryBuilderUtils.findPersistenceColumnValue(annotationMetadata, "precision");
        OptionalInt optScale = SqlQueryBuilderUtils.findPersistenceColumnValue(annotationMetadata, "scale");
        SqlDbType dbType = SqlSchemaUtils.getDbType(prop);
        Integer precision = null;
        Integer scale = null;
        return switch (dataType) {
            case DataType.STRING -> {
                int stringLength = annotationMetadata.findAnnotation("jakarta.validation.constraints.Size$List").flatMap(v -> {
                    Optional value = v.getValue(AnnotationValue.class);
                    return value;
                }).map(v -> v.intValue("max")).orElseGet(() -> SqlQueryBuilderUtils.findPersistenceColumnValue(annotationMetadata, "length")).orElse(255);
                yield new SqlColumnMapping(column, dataType, dbType, primaryKey, stringLength, required, autoGenerated, generatedValueType, definition);
            }
            case DataType.UUID, DataType.BOOLEAN, DataType.TIMESTAMP, DataType.DATE, DataType.TIME, DataType.LONG, DataType.SHORT, DataType.BYTE, DataType.BYTE_ARRAY, DataType.STRING_ARRAY, DataType.CHARACTER_ARRAY, DataType.SHORT_ARRAY, DataType.INTEGER_ARRAY, DataType.LONG_ARRAY, DataType.FLOAT_ARRAY, DataType.DOUBLE_ARRAY, DataType.BOOLEAN_ARRAY -> new SqlColumnMapping(column, dataType, dbType, primaryKey, null, required, autoGenerated, generatedValueType, definition);
            case DataType.CHARACTER -> new SqlColumnMapping(column, dataType, dbType, primaryKey, 1, required, autoGenerated, generatedValueType, definition);
            case DataType.JSON -> new SqlColumnMapping(column, dataType, dbType, primaryKey, null, null, null, required, autoGenerated, generatedValueType, definition, prop.getJsonDataType());
            case DataType.INTEGER -> {
                if (optPrecision.isPresent()) {
                    precision = optPrecision.getAsInt();
                }
                yield new SqlColumnMapping(column, dataType, dbType, primaryKey, null, precision, required, autoGenerated, generatedValueType, definition);
            }
            case DataType.BIGDECIMAL, DataType.FLOAT, DataType.DOUBLE -> {
                if (optPrecision.isPresent()) {
                    precision = optPrecision.getAsInt();
                }
                if (optScale.isPresent()) {
                    scale = optScale.getAsInt();
                }
                yield new SqlColumnMapping(column, dataType, dbType, primaryKey, null, precision, scale, required, autoGenerated, generatedValueType, definition, null);
            }
            default -> {
                if (StringUtils.isNotEmpty((CharSequence)definition)) {
                    yield new SqlColumnMapping(column, dataType, dbType, primaryKey, null, required, autoGenerated, generatedValueType, definition);
                }
                throw new MappingException("Unable to create table column for property [" + prop.getName() + "] of entity [" + prop.getOwner().getName() + "] with unknown data type: " + String.valueOf((Object)dataType));
            }
        };
    }

    private static SqlDbType getDbType(PersistentProperty property) {
        DataType dataType = property.getDataType();
        return switch (dataType) {
            case DataType.STRING -> SqlDbType.VARCHAR;
            case DataType.UUID -> SqlDbType.UUID;
            case DataType.BOOLEAN -> SqlDbType.BOOLEAN;
            case DataType.TIMESTAMP -> SqlDbType.TIMESTAMP;
            case DataType.DATE -> SqlDbType.DATE;
            case DataType.TIME -> SqlDbType.TIME;
            case DataType.LONG -> SqlDbType.BIGINT;
            case DataType.CHARACTER -> SqlDbType.CHAR;
            case DataType.INTEGER -> SqlDbType.INTEGER;
            case DataType.BIGDECIMAL -> SqlDbType.NUMERIC;
            case DataType.FLOAT -> SqlDbType.FLOAT;
            case DataType.BYTE_ARRAY -> SqlDbType.BINARY;
            case DataType.DOUBLE -> SqlDbType.DOUBLE;
            case DataType.SHORT, DataType.BYTE -> SqlDbType.SMALLINT;
            case DataType.JSON -> SqlDbType.JSON;
            case DataType.STRING_ARRAY, DataType.CHARACTER_ARRAY, DataType.SHORT_ARRAY, DataType.INTEGER_ARRAY, DataType.LONG_ARRAY, DataType.FLOAT_ARRAY, DataType.DOUBLE_ARRAY, DataType.BOOLEAN_ARRAY -> SqlDbType.ARRAY;
            default -> {
                if (property.isEnum()) {
                    yield SqlDbType.ENUM;
                }
                if (property.isAssignable(Clob.class)) {
                    yield SqlDbType.CLOB;
                }
                if (property.isAssignable(Blob.class)) {
                    yield SqlDbType.BLOB;
                }
                throw new MappingException("Unable to create table column for property [" + property.getName() + "] of entity [" + property.getOwner().getName() + "] with unknown data type: " + String.valueOf((Object)dataType));
            }
        };
    }

    private static boolean isRequired(List<Association> associations, PersistentProperty property) {
        PersistentProperty foreignAssociation = null;
        for (Association association : associations) {
            if (!association.isRequired()) {
                return false;
            }
            if (association.getKind() == Relation.Kind.EMBEDDED || foreignAssociation != null) continue;
            foreignAssociation = association;
        }
        if (foreignAssociation != null) {
            return foreignAssociation.isRequired();
        }
        return property.isRequired();
    }

    private static List<SqlSequenceMapping> getSqlSequenceMappings(List<PersistentProperty> identities) {
        ArrayList<SqlSequenceMapping> sequences = new ArrayList<SqlSequenceMapping>();
        for (PersistentProperty identity : identities) {
            if (!identity.isGenerated()) continue;
            GeneratedValue.Type idGeneratorType = identity.getAnnotationMetadata().enumValue(GeneratedValue.class, GeneratedValue.Type.class).orElse(null);
            String generatedDefinition = identity.getAnnotationMetadata().stringValue(GeneratedValue.class, "definition").orElse(null);
            String definedSequenceName = identity.getAnnotationMetadata().stringValue(GeneratedValue.class, "ref").orElse(null);
            sequences.add(new SqlSequenceMapping(generatedDefinition, definedSequenceName, identity.getDataType(), Optional.ofNullable(idGeneratorType)));
        }
        return sequences;
    }

    private static List<SqlIndexMapping> getSqlIndexMappings(PersistentEntity entity) {
        ArrayList<SqlIndexMapping> indexMappings = new ArrayList<SqlIndexMapping>();
        Optional<List> indexes = entity.findAnnotation(Indexes.class).map(idxes -> idxes.getAnnotations("value", Index.class));
        Stream.of(indexes).flatMap(Optional::stream).flatMap(Collection::stream).forEach(index -> {
            String name = index.stringValue("name").orElse("");
            boolean unique = index.booleanValue("unique").orElse(false);
            String[] columns = index.stringValues("columns");
            indexMappings.add(new SqlIndexMapping(name, unique, columns));
        });
        return indexMappings;
    }

    private static List<SqlColumnMapping> getPrimaryKeyColumns(List<PersistentProperty> identities, NamingStrategy namingStrategy) {
        ArrayList<SqlColumnMapping> primaryKeyColumns = new ArrayList<SqlColumnMapping>(identities.size());
        for (PersistentProperty identity : identities) {
            ArrayList ids = new ArrayList();
            PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), identity, (associations, property) -> ids.add(PersistentPropertyPath.of(associations, property, "")));
            for (PersistentPropertyPath pp : ids) {
                String columnName = namingStrategy.mappedName(pp.getAssociations(), pp.getProperty());
                SqlColumnMapping column = SqlSchemaUtils.getColumnDefinition(pp.getProperty(), columnName, true, SqlSchemaUtils.isRequired(pp.getAssociations(), pp.getProperty()), !SqlQueryBuilderUtils.isNotForeign(pp.getAssociations()));
                primaryKeyColumns.add(column);
            }
        }
        return primaryKeyColumns;
    }
}

