/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.sql.JoinColumns;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

@Internal
final class SqlQueryBuilderUtils {
    static final String ANN_JOIN_TABLE = "io.micronaut.data.annotation.sql.JoinTable";
    static final String ANN_JOIN_COLUMNS = "io.micronaut.data.annotation.sql.JoinColumns";
    static final String SEQ_SUFFIX = "_seq";
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";

    private SqlQueryBuilderUtils() {
    }

    static String mapPersistedName(String persistedName, UnaryOperator<String> mapFunction) {
        if (StringUtils.isEmpty((CharSequence)persistedName)) {
            return persistedName;
        }
        StringBuilder sb = new StringBuilder();
        String value = persistedName;
        int i = value.indexOf(PREFIX);
        while (i > -1) {
            int suffixIdx;
            if (i > 0) {
                String rawSegment = value.substring(0, i);
                sb.append((String)mapFunction.apply(rawSegment));
            }
            if ((suffixIdx = (value = value.substring(i + PREFIX.length())).indexOf(SUFFIX)) <= -1) {
                throw new ConfigurationException("Incomplete placeholder definitions detected: " + persistedName);
            }
            String expr = value.substring(0, suffixIdx).trim();
            sb.append(PREFIX).append(expr).append(SUFFIX);
            value = value.substring(suffixIdx + SUFFIX.length());
            i = value.indexOf(PREFIX);
        }
        if (!value.isEmpty()) {
            sb.append((String)mapFunction.apply(value));
        }
        return sb.toString();
    }

    static boolean isNotForeign(List<Association> associations) {
        for (Association association : associations) {
            if (association.getKind() == Relation.Kind.EMBEDDED) continue;
            return false;
        }
        return true;
    }

    static List<String> getJoinedColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, String columnType) {
        AnnotationValue joinTable = annotationMetadata.getAnnotation(ANN_JOIN_TABLE);
        if (joinTable != null) {
            return joinTable.getAnnotations(associationOwner ? "joinColumns" : "inverseJoinColumns").stream().flatMap(ann -> ann.stringValue(columnType).stream()).toList();
        }
        return Collections.emptyList();
    }

    static List<String> resolveJoinTableJoinColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = SqlQueryBuilderUtils.getJoinedColumns(annotationMetadata, associationOwner, "name");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        ArrayList<String> columns = new ArrayList<String>();
        PersistentProperty property1 = entity.getIdentity();
        PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), property1, (associations, property) -> columns.add(namingStrategy.mappedJoinTableColumn(entity, (List<Association>)associations, (PersistentProperty)property)));
        return columns;
    }

    static Stream<? extends PersistentProperty> flatMapEmbedded(PersistentProperty pp) {
        if (pp instanceof Embedded) {
            Embedded embedded = (Embedded)pp;
            PersistentEntity embeddedEntity = embedded.getAssociatedEntity();
            return embeddedEntity.getPersistentProperties().stream().flatMap(SqlQueryBuilderUtils::flatMapEmbedded);
        }
        return Stream.of(pp);
    }

    static Collection<Association> getJoinTableAssociations(PersistentEntity persistentEntity) {
        return Stream.concat(Stream.of(persistentEntity.getIdentity()), persistentEntity.getPersistentProperties().stream()).flatMap(SqlQueryBuilderUtils::flatMapEmbedded).filter(p -> {
            if (p instanceof Association) {
                Association a = (Association)p;
                return SqlQueryBuilderUtils.isForeignKeyWithJoinTable(a);
            }
            return false;
        }).map(p -> (Association)p).toList();
    }

    static String getSchemaName(PersistentEntity entity) {
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElseGet(() -> entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElse(null));
    }

    static OptionalInt findPersistenceColumnValue(AnnotationMetadata annotationMetadata, String value) {
        String annotationName = "javax.persistence.Column";
        OptionalInt optionalInt = annotationMetadata.intValue(annotationName, value);
        if (optionalInt.isEmpty()) {
            annotationName = "jakarta.persistence.Column";
            optionalInt = annotationMetadata.intValue(annotationName, value);
        }
        return optionalInt;
    }

    static boolean isForeignKeyWithJoinTable(Association association) {
        if (!association.isForeignKey()) {
            return false;
        }
        if (association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").isPresent()) {
            return false;
        }
        AnnotationValue joinColumnsAnnotationValue = association.getAnnotationMetadata().getAnnotation(JoinColumns.class);
        return joinColumnsAnnotationValue == null || CollectionUtils.isEmpty((Collection)joinColumnsAnnotationValue.getAnnotations("value"));
    }

    static boolean isGeneratedProperty(PersistentProperty property, List<Association> associations) {
        Association last;
        PersistentEntity assocEntity;
        boolean generated = property.isGenerated();
        if (generated && generated && CollectionUtils.isNotEmpty(associations) && (assocEntity = (last = associations.get(associations.size() - 1)).getAssociatedEntity()) != null && assocEntity.getIdentityProperties().contains(property)) {
            generated = false;
        }
        return generated;
    }
}

