/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.jpa;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.PersistentAssociationPath;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.DefaultOrder;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.AbstractSqlLikeQueryBuilder;
import io.micronaut.data.model.query.builder.sql.Dialect;
import jakarta.persistence.criteria.Order;
import java.util.HashSet;
import java.util.List;

@Internal
public class JpaQueryBuilder
extends AbstractSqlLikeQueryBuilder {
    private static final NamingStrategy JPA_NAMING_STRATEGY = new NamingStrategy(){

        @Override
        public String mappedName(String name) {
            return name;
        }

        @Override
        public String mappedAssociatedName(String associatedName) {
            return associatedName;
        }

        @Override
        public String mappedName(Association association) {
            String providedName = association.getAnnotationMetadata().stringValue(MappedProperty.class).orElse(null);
            if (providedName != null) {
                return providedName;
            }
            return association.getName();
        }
    };

    @Override
    protected String quote(String persistedName) {
        return persistedName;
    }

    @Override
    public String getAliasName(PersistentEntity entity) {
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class, "alias").orElseGet(() -> entity.getDecapitalizedName() + "_");
    }

    @Override
    protected void buildJoin(String joinType, StringBuilder query, AbstractSqlLikeQueryBuilder.QueryState queryState, PersistentAssociationPath joinAssociation, PersistentEntity associationOwner, String currentJoinAlias, String lastJoinAlias) {
        query.append(joinType).append(lastJoinAlias).append('.').append(joinAssociation.getAssociation().getName()).append(' ').append(currentJoinAlias);
    }

    @Override
    protected String buildAdditionalWhereClause(AbstractSqlLikeQueryBuilder.QueryState queryState, AnnotationMetadata annotationMetadata) {
        StringBuilder additionalWhereBuff = new StringBuilder(this.buildAdditionalWhereString(queryState.getRootAlias(), queryState.getEntity(), annotationMetadata));
        List<JoinPath> joinPaths = queryState.getJoinPaths();
        if (CollectionUtils.isNotEmpty(joinPaths)) {
            HashSet<String> addedJoinPaths = new HashSet<String>();
            for (JoinPath joinPath : joinPaths) {
                String path = joinPath.getPath();
                if (addedJoinPaths.contains(path)) continue;
                addedJoinPaths.add(path);
                String joinAdditionalWhere = this.buildAdditionalWhereString(joinPath, annotationMetadata);
                if (!StringUtils.isNotEmpty((CharSequence)joinAdditionalWhere)) continue;
                if (!additionalWhereBuff.isEmpty()) {
                    additionalWhereBuff.append(' ').append("AND").append(' ');
                }
                additionalWhereBuff.append(joinAdditionalWhere);
            }
        }
        return additionalWhereBuff.toString();
    }

    @Override
    protected String getTableName(PersistentEntity entity) {
        return entity.getName();
    }

    @Override
    protected String getColumnName(PersistentProperty persistentProperty) {
        return persistentProperty.getName();
    }

    @Override
    protected AbstractSqlLikeQueryBuilder.SqlSelectionVisitor createSelectionVisitor(AnnotationMetadata annotationMetadata, AbstractSqlLikeQueryBuilder.QueryState queryState, boolean distinct) {
        return new AbstractSqlLikeQueryBuilder.SqlSelectionVisitor(this, queryState, annotationMetadata, distinct){

            @Override
            protected void selectAllColumnsAndJoined() {
                this.query.append(this.tableAlias);
            }

            @Override
            protected void selectAllColumns(AnnotationMetadata annotationMetadata, PersistentEntity persistentEntity, String tableAlias) {
                this.query.append(tableAlias);
            }

            @Override
            protected void appendRowCount(String logicalName) {
                this.query.append("COUNT").append('(').append(logicalName).append(')');
            }

            @Override
            protected void appendRowCountDistinct(String logicalName) {
                this.query.append("COUNT(DISTINCT").append('(').append(logicalName).append(')').append(')');
            }

            @Override
            protected void appendCompoundAssociationProjection(PersistentAssociationPath propertyPath) {
                String joinAlias = this.queryState.getJoinAlias(propertyPath.getPath());
                this.query.append(joinAlias).append(" AS ").append(this.columnAlias != null ? this.columnAlias : propertyPath.getProperty().getName());
            }

            @Override
            protected void appendCompoundPropertyProjection(PersistentPropertyPath propertyPath) {
                PersistentProperty property = propertyPath.getProperty();
                if (property instanceof Embedded) {
                    this.query.append(this.tableAlias).append('.').append(propertyPath.getPath());
                    if (this.columnAlias != null) {
                        this.query.append(" AS ").append(this.columnAlias);
                    }
                    return;
                }
                super.appendCompoundPropertyProjection(propertyPath);
            }
        };
    }

    @Override
    protected boolean computePropertyPaths() {
        return false;
    }

    @Override
    protected boolean isAliasForBatch(PersistentEntity persistentEntity, AnnotationMetadata annotationMetadata) {
        return true;
    }

    @Override
    protected AbstractSqlLikeQueryBuilder.Placeholder formatParameter(int index) {
        String n = "p" + index;
        return new AbstractSqlLikeQueryBuilder.Placeholder(":" + n, n);
    }

    @Override
    public String resolveJoinType(Join.Type jt) {
        return switch (jt) {
            case Join.Type.LEFT -> " LEFT JOIN ";
            case Join.Type.LEFT_FETCH -> " LEFT JOIN FETCH ";
            case Join.Type.RIGHT -> " RIGHT JOIN ";
            case Join.Type.RIGHT_FETCH -> " RIGHT JOIN FETCH ";
            case Join.Type.INNER, Join.Type.FETCH -> " JOIN FETCH ";
            default -> " JOIN ";
        };
    }

    @Override
    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, QueryBuilder.InsertQueryDefinition definition) {
        return null;
    }

    @Override
    protected StringBuilder appendDeleteClause(StringBuilder queryString) {
        return queryString.append("DELETE ");
    }

    @Override
    public String buildLimitAndOffset(long limit, long offset) {
        throw new UnsupportedOperationException("JPA-QL does not support pagination in query definitions");
    }

    @Override
    protected void appendLimitAndOffset(Dialect dialect, long limit, long offset, StringBuilder builder) {
    }

    @Override
    protected boolean supportsLimitQuery() {
        return false;
    }

    @Override
    protected void appendLimitAndOrder(AnnotationMetadata annotationMetadata, QueryBuilder.SelectQueryDefinition definition, boolean appendLimit, boolean appendOrder, AbstractSqlLikeQueryBuilder.QueryState queryState) {
        if (appendOrder) {
            this.appendOrder(annotationMetadata, definition.order(), queryState);
        }
    }

    @Override
    protected boolean shouldAppendOrder(QueryBuilder.SelectQueryDefinition definition) {
        for (Order order : definition.order()) {
            DefaultOrder defaultOrder;
            if (!(order instanceof DefaultOrder) || !(defaultOrder = (DefaultOrder)order).isIgnoreCase()) continue;
            return false;
        }
        return super.shouldAppendOrder(definition);
    }

    @Override
    protected NamingStrategy getNamingStrategy(PersistentEntity entity) {
        return JPA_NAMING_STRATEGY;
    }

    @Override
    protected NamingStrategy getNamingStrategy(PersistentPropertyPath propertyPath) {
        return JPA_NAMING_STRATEGY;
    }
}

