/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.DefaultOrder;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@Introspected
public interface QueryBuilder {
    public @Nullable QueryResult buildInsert(AnnotationMetadata var1, InsertQueryDefinition var2);

    public QueryResult buildSelect(AnnotationMetadata var1, SelectQueryDefinition var2);

    public QueryResult buildUpdate(AnnotationMetadata var1, UpdateQueryDefinition var2);

    public QueryResult buildDelete(AnnotationMetadata var1, DeleteQueryDefinition var2);

    public String buildLimitAndOffset(long var1, long var3);

    public static interface BaseQueryDefinition {
        public PersistentEntity persistentEntity();

        public @Nullable Predicate predicate();

        public Collection<JoinPath> getJoinPaths();

        public Optional<JoinPath> getJoinPath(String var1);

        default public int limit() {
            return -1;
        }

        default public int offset() {
            return -1;
        }
    }

    public static interface UpdateQueryDefinition
    extends BaseQueryDefinition {
        public Map<String, Object> propertiesToUpdate();

        public @Nullable Selection<?> returningSelection();
    }

    public static interface InsertQueryDefinition {
        public PersistentEntity persistentEntity();

        public @Nullable boolean returning();
    }

    public static interface DeleteQueryDefinition
    extends BaseQueryDefinition {
        public @Nullable Selection<?> returningSelection();
    }

    public static interface SelectQueryDefinition
    extends BaseQueryDefinition {
        public Root<?> root();

        public Selection<?> selection();

        public List<Order> order();

        default public Sort asSort() {
            List<Order> orders = this.order();
            if (orders == null || orders.isEmpty()) {
                return Sort.unsorted();
            }
            List<Sort.Order> sortOrders = orders.stream().map(o -> {
                PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty(o.getExpression());
                String name = propertyPath.getPathAsString();
                if (o instanceof DefaultOrder) {
                    DefaultOrder order = (DefaultOrder)o;
                    return new Sort.Order(name, order.isAscending() ? Sort.Order.Direction.ASC : Sort.Order.Direction.DESC, order.isIgnoreCase());
                }
                if (o.isAscending()) {
                    return Sort.Order.asc(name);
                }
                return Sort.Order.desc(name);
            }).toList();
            return Sort.of(sortOrders);
        }

        default public boolean isForUpdate() {
            return false;
        }

        default public boolean isDistinct() {
            return false;
        }

        default public Map<Integer, String> parametersInRole() {
            return Map.of();
        }
    }
}

