/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.AbstractExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.BinaryExpressionType;
import io.micronaut.data.model.jpa.criteria.impl.expression.ClassExpressionType;
import jakarta.persistence.criteria.Expression;
import org.jspecify.annotations.Nullable;

@Internal
public final class BinaryExpression<E>
extends AbstractExpression<E> {
    private final BinaryExpressionType type;
    private final Expression<?> left;
    private final Expression<?> right;

    public BinaryExpression(Expression<?> left, Expression<?> right, BinaryExpressionType type, @Nullable Class<E> expressionType) {
        super(expressionType == null ? ExpressionType.OBJECT : new ClassExpressionType<E>(expressionType));
        this.left = left;
        this.right = right;
        this.type = type;
    }

    public BinaryExpressionType getType() {
        return this.type;
    }

    public Expression<?> getLeft() {
        return this.left;
    }

    public Expression<?> getRight() {
        return this.right;
    }

    @Override
    public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "BinaryExpression{type=" + String.valueOf((Object)this.type) + ", left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "}";
    }
}

