/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.IParameterExpression;
import io.micronaut.data.model.jpa.criteria.impl.PropertyPathParameterBinding;
import io.micronaut.data.model.jpa.criteria.impl.SimpleParameterBinding;
import io.micronaut.data.model.jpa.criteria.impl.expression.ClassExpressionType;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;

@Internal
final class DefaultParameterExpression<T>
extends IParameterExpression<T> {
    private final Class<T> paramClass;
    private final @Nullable Object value;

    public DefaultParameterExpression(Class<T> paramClass, @Nullable String name, @Nullable Object value) {
        super(new ClassExpressionType<T>(paramClass), name);
        this.paramClass = paramClass;
        this.value = value;
    }

    @Override
    public QueryParameterBinding bind(BindingParameter.BindingContext bindingContext) {
        String name = bindingContext.getName() == null ? String.valueOf(bindingContext.getIndex()) : bindingContext.getName();
        PersistentPropertyPath outgoingQueryParameterProperty = bindingContext.getOutgoingQueryParameterProperty();
        if (outgoingQueryParameterProperty == null) {
            return new SimpleParameterBinding(name, DataType.forType(this.paramClass), bindingContext.isExpandable(), this.value);
        }
        Object theValue = this.value;
        PersistentPropertyPath incomingQueryParameterProperty = bindingContext.getIncomingMethodParameterProperty();
        if (incomingQueryParameterProperty != null && theValue != null) {
            List<PersistentProperty> inPath = incomingQueryParameterProperty.getPropertyPath();
            List<PersistentProperty> outPath = outgoingQueryParameterProperty.getPropertyPath();
            Iterator<PersistentProperty> inIterator = inPath.iterator();
            for (PersistentProperty outProp : outPath) {
                if (inIterator.hasNext()) {
                    PersistentProperty inProp = inIterator.next();
                    if (inProp.equals(outProp)) continue;
                    throw new IllegalStateException("OUT path: " + String.valueOf(outPath) + " should include IN path: " + String.valueOf(inPath));
                }
                theValue = ((RuntimePersistentProperty)outProp).getProperty().get(theValue);
                if (theValue != null) continue;
                break;
            }
        }
        return new PropertyPathParameterBinding(name, outgoingQueryParameterProperty, bindingContext.isExpandable(), theValue);
    }
}

