/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentCollectionAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCollectionJoin;
import io.micronaut.data.model.jpa.criteria.PersistentEntityFrom;
import io.micronaut.data.model.jpa.criteria.PersistentEntityJoin;
import io.micronaut.data.model.jpa.criteria.PersistentEntityListJoin;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySetJoin;
import io.micronaut.data.model.jpa.criteria.PersistentListAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentSetAssociationPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@Internal
public abstract class AbstractPersistentEntityFrom<J, E>
implements PersistentEntityFrom<J, E> {
    protected final Map<String, PersistentAssociationPath<E, ?>> joins = new LinkedHashMap();

    @Override
    public abstract PersistentEntity getPersistentEntity();

    protected abstract <Y> PersistentAssociationPath<E, Y> createJoinAssociation(Association var1, @Nullable Join.Type var2, @Nullable String var3);

    private <X, Y> PersistentAssociationPath<X, Y> getJoin(String attributeName) {
        return this.getJoin(attributeName, null, null);
    }

    private <X, Y> PersistentAssociationPath<X, Y> getJoin(String attributeName, Join.Type type) {
        return this.getJoin(attributeName, type, null);
    }

    private <X, Y> PersistentAssociationPath<X, Y> getJoin(String attributeName, Join.Type type, String alias) {
        PersistentProperty persistentProperty = this.getPersistentEntity().getPropertyByName(attributeName);
        if (persistentProperty == null && attributeName.contains(".")) {
            int periodIndex = attributeName.indexOf(".");
            String owner = attributeName.substring(0, periodIndex);
            PersistentAssociationPath<E, ?> existingJoin = this.joins.get(owner);
            PersistentEntityJoin<Object, Object> persistentAssociationPath = existingJoin != null ? existingJoin : this.join(owner, type);
            String remainingJoinPath = attributeName.substring(periodIndex + 1);
            return alias == null ? persistentAssociationPath.join(remainingJoinPath, type) : persistentAssociationPath.join(remainingJoinPath, type, alias);
        }
        if (!(persistentProperty instanceof Association)) {
            throw new IllegalStateException("Expected an association for attribute name: " + attributeName);
        }
        Association association = (Association)persistentProperty;
        PersistentAssociationPath path = this.joins.computeIfAbsent(attributeName, a -> this.createJoinAssociation(association, type, alias));
        if (type != null && type != Join.Type.DEFAULT) {
            path.setAssociationJoinType(type);
        }
        if (alias != null) {
            path.setAlias(alias);
        }
        return path;
    }

    private <Y> PersistentCollectionAssociationPath<E, Y> getCollectionJoin(String attributeName, Join.Type type) {
        PersistentAssociationPath join = this.getJoin(attributeName, type);
        if (!(join instanceof PersistentCollectionAssociationPath)) {
            throw new IllegalStateException("Join is not a Collection!");
        }
        PersistentCollectionAssociationPath persistentCollectionAssociationPath = (PersistentCollectionAssociationPath)join;
        return persistentCollectionAssociationPath;
    }

    private <Y> PersistentSetAssociationPath<E, Y> getSetJoin(String attributeName, Join.Type type) {
        PersistentAssociationPath join = this.getJoin(attributeName, type);
        if (!(join instanceof PersistentSetAssociationPath)) {
            throw new IllegalStateException("Join is not a Set!");
        }
        PersistentSetAssociationPath persistentSetAssociationPath = (PersistentSetAssociationPath)join;
        return persistentSetAssociationPath;
    }

    private <Y> PersistentListAssociationPath<E, Y> getListJoin(String attributeName, Join.Type type) {
        PersistentAssociationPath join = this.getJoin(attributeName, type);
        if (!(join instanceof PersistentListAssociationPath)) {
            throw new IllegalStateException("Join is not a List!");
        }
        PersistentListAssociationPath persistentListAssociationPath = (PersistentListAssociationPath)join;
        return persistentListAssociationPath;
    }

    @Override
    public <X, Y> PersistentAssociationPath<X, Y> join(String attributeName) {
        return this.getJoin(attributeName);
    }

    @Override
    public <X, Y> PersistentAssociationPath<X, Y> join(String attributeName, JoinType jt) {
        return this.getJoin(attributeName, this.convert(Objects.requireNonNull(jt)));
    }

    @Override
    public <X, Y> PersistentAssociationPath<X, Y> join(String attributeName, Join.Type type) {
        return this.getJoin(attributeName, type);
    }

    @Override
    public <X, Y> PersistentAssociationPath<X, Y> join(String attributeName, Join.Type type, String alias) {
        return this.getJoin(attributeName, type, Objects.requireNonNull(alias));
    }

    private @Nullable Join.Type convert(@Nullable JoinType joinType) {
        if (joinType == null) {
            return null;
        }
        return switch (joinType) {
            default -> throw new MatchException(null, null);
            case JoinType.LEFT -> Join.Type.LEFT_FETCH;
            case JoinType.RIGHT -> Join.Type.RIGHT_FETCH;
            case JoinType.INNER -> Join.Type.INNER;
        };
    }

    @Override
    public <Y> PersistentAssociationPath<E, Y> join(SingularAttribute<? super E, Y> attribute) {
        return this.getJoin(attribute.getName());
    }

    @Override
    public <Y> PersistentAssociationPath<E, Y> join(SingularAttribute<? super E, Y> attribute, JoinType jt) {
        return this.getJoin(attribute.getName(), this.convert(Objects.requireNonNull(jt)));
    }

    @Override
    public <Y> PersistentAssociationPath<E, Y> join(SingularAttribute<? super E, Y> attribute, Join.Type jt) {
        return this.getJoin(attribute.getName(), Objects.requireNonNull(jt));
    }

    @Override
    public <Y> PersistentEntityCollectionJoin<E, Y> join(CollectionAttribute<? super E, Y> collection, JoinType jt) {
        return this.getCollectionJoin(collection.getName(), this.convert(jt));
    }

    @Override
    public <Y> PersistentEntityCollectionJoin<E, Y> join(CollectionAttribute<? super E, Y> collection) {
        return this.getCollectionJoin(collection.getName(), null);
    }

    @Override
    public <Y> PersistentEntitySetJoin<E, Y> join(SetAttribute<? super E, Y> set) {
        return this.getSetJoin(set.getName(), null);
    }

    @Override
    public <Y> PersistentEntityListJoin<E, Y> join(ListAttribute<? super E, Y> list) {
        return this.getListJoin(list.getName(), null);
    }

    public <K, V> MapJoin<E, K, V> join(MapAttribute<? super E, K, V> map) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public <Y> PersistentEntitySetJoin<E, Y> join(SetAttribute<? super E, Y> set, JoinType jt) {
        return this.getSetJoin(set.getName(), this.convert(Objects.requireNonNull(jt)));
    }

    @Override
    public <Y> PersistentEntityListJoin<E, Y> join(ListAttribute<? super E, Y> list, JoinType jt) {
        return this.getListJoin(list.getName(), this.convert(Objects.requireNonNull(jt)));
    }

    public <K, V> MapJoin<E, K, V> join(MapAttribute<? super E, K, V> map, JoinType jt) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public <X, Y> PersistentEntityCollectionJoin<X, Y> joinCollection(String attributeName) {
        return this.getCollectionJoin(attributeName, null);
    }

    @Override
    public <X, Y> PersistentEntitySetJoin<X, Y> joinSet(String attributeName) {
        return this.getSetJoin(attributeName, null);
    }

    @Override
    public <X, Y> PersistentEntityListJoin<X, Y> joinList(String attributeName) {
        return this.getListJoin(attributeName, null);
    }

    public <X, K, V> MapJoin<X, K, V> joinMap(String attributeName) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public <X, Y> PersistentEntityCollectionJoin<X, Y> joinCollection(String attributeName, JoinType jt) {
        return this.getCollectionJoin(attributeName, null);
    }

    @Override
    public <X, Y> PersistentEntitySetJoin<X, Y> joinSet(String attributeName, JoinType jt) {
        return this.getSetJoin(attributeName, this.convert(Objects.requireNonNull(jt)));
    }

    @Override
    public <X, Y> PersistentEntityListJoin<X, Y> joinList(String attributeName, JoinType jt) {
        return this.getListJoin(attributeName, this.convert(Objects.requireNonNull(jt)));
    }

    public <X, K, V> MapJoin<X, K, V> joinMap(String attributeName, JoinType jt) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Set<Join<E, ?>> getJoins() {
        return this.joins.values().stream().collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Collection<PersistentAssociationPath<E, ?>> getPersistentJoins() {
        return this.joins.values().stream().toList();
    }

    public boolean isCorrelated() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public From<J, E> getCorrelationParent() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Set<Fetch<E, ?>> getFetches() {
        return this.joins.values().stream().filter(p -> p.getAssociationJoinType() != null && p.getAssociationJoinType().isFetch()).map(p -> (Fetch)p).collect(Collectors.toUnmodifiableSet());
    }

    public <Y> Fetch<E, Y> fetch(SingularAttribute<? super E, Y> attribute) {
        return (Fetch)this.join((SingularAttribute)attribute, Join.Type.FETCH);
    }

    public <Y> Fetch<E, Y> fetch(SingularAttribute<? super E, Y> attribute, JoinType jt) {
        return (Fetch)this.join((SingularAttribute)attribute, this.convertFetch(jt));
    }

    public <Y> Fetch<E, Y> fetch(PluralAttribute<? super E, ?, Y> attribute) {
        return (Fetch)this.join(attribute.getName(), Join.Type.FETCH);
    }

    public <Y> Fetch<E, Y> fetch(PluralAttribute<? super E, ?, Y> attribute, JoinType jt) {
        return (Fetch)this.join(attribute.getName(), this.convertFetch(jt));
    }

    public <X, Y> Fetch<X, Y> fetch(String attributeName) {
        return (Fetch)this.join(attributeName, Join.Type.FETCH);
    }

    public <X, Y> Fetch<X, Y> fetch(String attributeName, JoinType jt) {
        return (Fetch)this.join(attributeName, this.convertFetch(jt));
    }

    private @Nullable Join.Type convertFetch(@Nullable JoinType joinType) {
        if (joinType == null) {
            return null;
        }
        return switch (joinType) {
            default -> throw new MatchException(null, null);
            case JoinType.LEFT -> Join.Type.LEFT_FETCH;
            case JoinType.RIGHT -> Join.Type.RIGHT_FETCH;
            case JoinType.INNER -> Join.Type.INNER_FETCH;
        };
    }

    public Expression<Class<? extends E>> type() {
        throw CriteriaUtils.notSupportedOperation();
    }
}

