/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.DefaultOrder;
import io.micronaut.data.model.jpa.criteria.impl.DefaultParameterExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.BinaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.BinaryExpressionType;
import io.micronaut.data.model.jpa.criteria.impl.expression.FunctionExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.SubqueryExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.UnaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.UnaryExpressionType;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BetweenPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.DisjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ExistsSubqueryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.InPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.LikePredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.NegatedPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PredicateBinaryOp;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PredicateUnaryOp;
import io.micronaut.data.model.jpa.criteria.impl.predicate.UnaryPredicate;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CompoundSelection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.criteria.Subquery;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

@Internal
public abstract class AbstractCriteriaBuilder
implements PersistentEntityCriteriaBuilder {
    @NotNull
    private Predicate predicate(Expression<?> x, Expression<?> y, PredicateBinaryOp op) {
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        return new BinaryPredicate(x, y, op);
    }

    @NotNull
    private Predicate predicate(Expression<?> x, Object y, PredicateBinaryOp op) {
        Objects.requireNonNull(x);
        return new BinaryPredicate(x, this.literal(y), op);
    }

    @NotNull
    private Predicate comparable(Expression<?> x, Expression<?> y, PredicateBinaryOp op) {
        return new BinaryPredicate(x, y, op);
    }

    @NotNull
    private Predicate comparable(Expression<?> x, Object y, PredicateBinaryOp op) {
        return new BinaryPredicate(x, this.literal(Objects.requireNonNull(y)), op);
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> resultClass, Selection<?> ... selections) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Order asc(Expression<?> x) {
        return this.sort(x, true, false);
    }

    public Order desc(Expression<?> x) {
        return this.sort(x, false, false);
    }

    @Override
    public Order sort(Expression<?> x, boolean ascending, boolean ignoreCase) {
        return new DefaultOrder(x, ascending, ignoreCase);
    }

    public <N extends Number> Expression<Double> avg(Expression<N> x) {
        return new UnaryExpression<Double>(x, UnaryExpressionType.AVG);
    }

    public <N extends Number> Expression<N> sum(Expression<N> x) {
        return new UnaryExpression(x, UnaryExpressionType.SUM);
    }

    public Expression<Long> sumAsLong(Expression<Integer> x) {
        return new UnaryExpression<Long>(x, UnaryExpressionType.SUM, Long.class);
    }

    public Expression<Double> sumAsDouble(Expression<Float> x) {
        return new UnaryExpression<Double>(x, UnaryExpressionType.SUM, Double.class);
    }

    public <N extends Number> Expression<N> max(Expression<N> x) {
        return new UnaryExpression(x, UnaryExpressionType.MAX);
    }

    public <N extends Number> Expression<N> min(Expression<N> x) {
        return new UnaryExpression(x, UnaryExpressionType.MIN);
    }

    public <X extends Comparable<? super X>> Expression<X> greatest(Expression<X> x) {
        return new UnaryExpression(x, UnaryExpressionType.MAX);
    }

    public <X extends Comparable<? super X>> Expression<X> least(Expression<X> x) {
        return new UnaryExpression(x, UnaryExpressionType.MIN);
    }

    public Expression<Long> count(Expression<?> x) {
        return new UnaryExpression<Long>(x, UnaryExpressionType.COUNT, Long.class);
    }

    public Expression<Long> countDistinct(Expression<?> x) {
        return new UnaryExpression<Long>(x, UnaryExpressionType.COUNT_DISTINCT, Long.class);
    }

    public Predicate exists(Subquery<?> subquery) {
        return new ExistsSubqueryPredicate(CriteriaUtils.requirePersistentEntitySubquery(subquery));
    }

    public <Y> Expression<Y> all(Subquery<Y> subquery) {
        return new SubqueryExpression<Y>(SubqueryExpression.Type.ALL, CriteriaUtils.requirePersistentEntitySubquery(subquery));
    }

    public <Y> Expression<Y> some(Subquery<Y> subquery) {
        return new SubqueryExpression<Y>(SubqueryExpression.Type.SOME, CriteriaUtils.requirePersistentEntitySubquery(subquery));
    }

    public <Y> Expression<Y> any(Subquery<Y> subquery) {
        return new SubqueryExpression<Y>(SubqueryExpression.Type.ANY, CriteriaUtils.requirePersistentEntitySubquery(subquery));
    }

    public Predicate and(Expression<Boolean> x, Expression<Boolean> y) {
        return new ConjunctionPredicate(List.of(CriteriaUtils.requireBoolExpression(x), CriteriaUtils.requireBoolExpression(y)));
    }

    public Predicate and(Predicate ... restrictions) {
        return this.and(List.of(restrictions));
    }

    @Override
    public Predicate and(Iterable<Predicate> restrictions) {
        return new ConjunctionPredicate(CriteriaUtils.requireBoolExpressions(restrictions));
    }

    @Override
    public Predicate isEmptyString(Expression<String> expression) {
        return new UnaryPredicate(expression, PredicateUnaryOp.IS_EMPTY);
    }

    @Override
    public Predicate isNotEmptyString(Expression<String> expression) {
        return new UnaryPredicate(expression, PredicateUnaryOp.IS_NOT_EMPTY);
    }

    @Override
    public Predicate ilike(Expression<String> x, Expression<String> pattern) {
        return new LikePredicate(x, pattern, null, false, true);
    }

    @Override
    public Predicate endingWithString(Expression<String> x, Expression<String> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.ENDS_WITH);
    }

    @Override
    public Predicate startsWithString(Expression<String> x, Expression<String> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.STARTS_WITH);
    }

    @Override
    public Predicate containsString(Expression<String> x, Expression<String> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.CONTAINS);
    }

    @Override
    public Predicate containsStringIgnoreCase(Expression<String> x, Expression<String> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.CONTAINS_IGNORE_CASE);
    }

    @Override
    public Predicate equalStringIgnoreCase(Expression<String> x, String y) {
        return new BinaryPredicate(x, this.literal(y), PredicateBinaryOp.EQUALS_IGNORE_CASE);
    }

    @Override
    public Predicate equalStringIgnoreCase(Expression<String> x, Expression<String> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.EQUALS_IGNORE_CASE);
    }

    @Override
    public Predicate notEqualStringIgnoreCase(Expression<String> x, String y) {
        return new BinaryPredicate(x, this.literal(y), PredicateBinaryOp.NOT_EQUALS_IGNORE_CASE);
    }

    @Override
    public Predicate notEqualStringIgnoreCase(Expression<String> x, Expression<String> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.NOT_EQUALS_IGNORE_CASE);
    }

    @Override
    public Predicate startsWithStringIgnoreCase(Expression<String> x, Expression<String> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.STARTS_WITH_IGNORE_CASE);
    }

    @Override
    public Predicate endingWithStringIgnoreCase(Expression<String> x, Expression<String> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.ENDS_WITH_IGNORE_CASE);
    }

    public Predicate or(Expression<Boolean> x, Expression<Boolean> y) {
        return new DisjunctionPredicate(List.of(CriteriaUtils.requireBoolExpression(x), CriteriaUtils.requireBoolExpression(y)));
    }

    public Predicate or(Predicate ... restrictions) {
        return this.or(List.of(restrictions));
    }

    @Override
    public Predicate or(Iterable<Predicate> restrictions) {
        return new DisjunctionPredicate(CriteriaUtils.requireBoolExpressions(restrictions));
    }

    public Predicate not(Expression<Boolean> restriction) {
        return new NegatedPredicate(CriteriaUtils.requireBoolExpression(restriction));
    }

    public Predicate conjunction() {
        return new ConjunctionPredicate(Collections.emptyList());
    }

    public Predicate disjunction() {
        return new DisjunctionPredicate(Collections.emptyList());
    }

    public Predicate isTrue(Expression<Boolean> x) {
        return new UnaryPredicate(x, PredicateUnaryOp.IS_TRUE);
    }

    public Predicate isFalse(Expression<Boolean> x) {
        return new UnaryPredicate(x, PredicateUnaryOp.IS_FALSE);
    }

    public Predicate isNull(Expression<?> x) {
        return new UnaryPredicate(x, PredicateUnaryOp.IS_NULL);
    }

    public Predicate isNotNull(Expression<?> x) {
        return new UnaryPredicate(x, PredicateUnaryOp.IS_NON_NULL);
    }

    public Predicate equal(Expression<?> x, Expression<?> y) {
        return this.predicate(x, y, PredicateBinaryOp.EQUALS);
    }

    public Predicate equal(Expression<?> x, @Nullable Object y) {
        return this.predicate(x, y, PredicateBinaryOp.EQUALS);
    }

    public Predicate notEqual(Expression<?> x, Expression<?> y) {
        return this.predicate(x, y, PredicateBinaryOp.NOT_EQUALS);
    }

    public Predicate notEqual(Expression<?> x, @Nullable Object y) {
        return this.predicate(x, y, PredicateBinaryOp.NOT_EQUALS);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return this.comparable(x, y, PredicateBinaryOp.GREATER_THAN);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> x, Y y) {
        return this.comparable(x, y, PredicateBinaryOp.GREATER_THAN);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return this.comparable(x, y, PredicateBinaryOp.GREATER_THAN_OR_EQUALS);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return this.comparable(x, y, PredicateBinaryOp.GREATER_THAN_OR_EQUALS);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return this.comparable(x, y, PredicateBinaryOp.LESS_THAN);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> x, Y y) {
        return this.comparable(x, y, PredicateBinaryOp.LESS_THAN);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return this.comparable(x, y, PredicateBinaryOp.LESS_THAN_OR_EQUALS);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return this.comparable(x, y, PredicateBinaryOp.LESS_THAN_OR_EQUALS);
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> v, Expression<? extends Y> x, Expression<? extends Y> y) {
        return new BetweenPredicate(v, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> v, Y x, Y y) {
        return new BetweenPredicate(v, this.literal(Objects.requireNonNull(x)), this.literal(Objects.requireNonNull(y)));
    }

    public Predicate gt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.GREATER_THAN);
    }

    public Predicate gt(Expression<? extends Number> x, Number y) {
        return new BinaryPredicate(x, this.literal(Objects.requireNonNull(y)), PredicateBinaryOp.GREATER_THAN);
    }

    public Predicate ge(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.GREATER_THAN_OR_EQUALS);
    }

    public Predicate ge(Expression<? extends Number> x, Number y) {
        return new BinaryPredicate(x, this.literal(Objects.requireNonNull(y)), PredicateBinaryOp.GREATER_THAN_OR_EQUALS);
    }

    public Predicate lt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.LESS_THAN);
    }

    public Predicate lt(Expression<? extends Number> x, Number y) {
        return new BinaryPredicate(x, this.literal(Objects.requireNonNull(y)), PredicateBinaryOp.LESS_THAN);
    }

    public Predicate le(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new BinaryPredicate(x, y, PredicateBinaryOp.LESS_THAN_OR_EQUALS);
    }

    public Predicate le(Expression<? extends Number> x, Number y) {
        return new BinaryPredicate(x, this.literal(Objects.requireNonNull(y)), PredicateBinaryOp.LESS_THAN_OR_EQUALS);
    }

    public <N extends Number> Expression<N> neg(Expression<N> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <N extends Number> Expression<N> abs(Expression<N> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> x, Expression<? extends N> y) {
        return new BinaryExpression<Number>(x, y, BinaryExpressionType.SUM, Number.class);
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> x, N y) {
        return new BinaryExpression<Number>(x, this.literal(y), BinaryExpressionType.SUM, Number.class);
    }

    public <N extends Number> Expression<N> sum(N x, Expression<? extends N> y) {
        return new BinaryExpression<Number>(this.literal(x), y, BinaryExpressionType.SUM, Number.class);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> x, Expression<? extends N> y) {
        return new BinaryExpression<Number>(x, y, BinaryExpressionType.PROD, Number.class);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> x, N y) {
        return new BinaryExpression<Number>(x, this.literal(y), BinaryExpressionType.PROD, Number.class);
    }

    public <N extends Number> Expression<N> prod(N x, Expression<? extends N> y) {
        return new BinaryExpression<Number>(this.literal(x), y, BinaryExpressionType.PROD, Number.class);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> x, Expression<? extends N> y) {
        return new BinaryExpression<Number>(x, y, BinaryExpressionType.DIFF, Number.class);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> x, N y) {
        return new BinaryExpression<Number>(x, this.literal(y), BinaryExpressionType.DIFF, Number.class);
    }

    public <N extends Number> Expression<N> diff(N x, Expression<? extends N> y) {
        return new BinaryExpression<Number>(this.literal(y), y, BinaryExpressionType.DIFF, Number.class);
    }

    public Expression<Number> quot(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new BinaryExpression<Number>(x, y, BinaryExpressionType.QUOT, Number.class);
    }

    public Expression<Number> quot(Expression<? extends Number> x, Number y) {
        return new BinaryExpression<Number>(x, this.literal(y), BinaryExpressionType.QUOT, Number.class);
    }

    public Expression<Number> quot(Number x, Expression<? extends Number> y) {
        return new BinaryExpression<Number>(this.literal(x), y, BinaryExpressionType.QUOT, Number.class);
    }

    public Expression<Integer> mod(Expression<Integer> x, Expression<Integer> y) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Integer> mod(Expression<Integer> x, Integer y) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Integer> mod(Integer x, Expression<Integer> y) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Double> sqrt(Expression<? extends Number> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Long> toLong(Expression<? extends Number> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Integer> toInteger(Expression<? extends Number> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Float> toFloat(Expression<? extends Number> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Double> toDouble(Expression<? extends Number> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<BigDecimal> toBigDecimal(Expression<? extends Number> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<BigInteger> toBigInteger(Expression<? extends Number> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> toString(Expression<Character> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <T> Expression<T> literal(@Nullable T value) {
        if (value instanceof Expression) {
            Expression expression = (Expression)value;
            throw new IllegalArgumentException("An expression cannot be literal");
        }
        return new LiteralExpression<T>(value);
    }

    public <T> Expression<T> nullLiteral(Class<T> x) {
        return new LiteralExpression<Class<T>>(x);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass) {
        return this.parameter(paramClass, null, null);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return this.parameter(paramClass, name, null);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass, @Nullable String name, @Nullable Object value) {
        return new DefaultParameterExpression<T>(paramClass, name, value);
    }

    public <C extends Collection<?>> Predicate isEmpty(Expression<C> collection) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <C extends Collection<?>> Predicate isNotEmpty(Expression<C> collection) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <C extends Collection<?>> Expression<Integer> size(Expression<C> collection) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <C extends Collection<?>> Expression<Integer> size(C collection) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <E, C extends Collection<E>> Predicate isMember(Expression<E> elem, Expression<C> collection) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <E, C extends Collection<E>> Predicate isMember(E elem, Expression<C> collection) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <E, C extends Collection<E>> Predicate isNotMember(Expression<E> elem, Expression<C> collection) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E elem, Expression<C> collection) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <K, M extends Map<K, ?>> Expression<Set<K>> keys(M map) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public Predicate regex(Expression<String> x, Expression<String> pattern) {
        return new BinaryPredicate(x, pattern, PredicateBinaryOp.REGEX);
    }

    public Predicate like(Expression<String> x, Expression<String> pattern) {
        return new LikePredicate(x, pattern, null, false);
    }

    public Predicate like(Expression<String> x, String pattern) {
        return new LikePredicate(x, this.literal(pattern), null, false);
    }

    public Predicate like(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return new LikePredicate(x, pattern, escapeChar, false);
    }

    public Predicate like(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return new LikePredicate(x, pattern, this.literal(Character.valueOf(escapeChar)), false);
    }

    public Predicate like(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return new LikePredicate(x, this.literal(pattern), escapeChar, false);
    }

    public Predicate like(Expression<String> x, String pattern, char escapeChar) {
        return new LikePredicate(x, this.literal(pattern), this.literal(Character.valueOf(escapeChar)), false);
    }

    public Predicate notLike(Expression<String> x, Expression<String> pattern) {
        return new LikePredicate(x, pattern, null, true);
    }

    public Predicate notLike(Expression<String> x, String pattern) {
        return new LikePredicate(x, this.literal(pattern), null, true);
    }

    public Predicate notLike(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return new LikePredicate(x, pattern, escapeChar, true);
    }

    public Predicate notLike(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return new LikePredicate(x, pattern, this.literal(Character.valueOf(escapeChar)), true);
    }

    public Predicate notLike(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return new LikePredicate(x, this.literal(pattern), escapeChar, true);
    }

    public Predicate notLike(Expression<String> x, String pattern, char escapeChar) {
        return new LikePredicate(x, this.literal(pattern), this.literal(Character.valueOf(escapeChar)), true);
    }

    public Expression<String> concat(Expression<String> x, Expression<String> y) {
        return new BinaryExpression<String>(x, y, BinaryExpressionType.CONCAT, String.class);
    }

    public Expression<String> concat(Expression<String> x, String y) {
        return new BinaryExpression<String>(x, this.literal(y), BinaryExpressionType.CONCAT, String.class);
    }

    public Expression<String> concat(String x, Expression<String> y) {
        return new BinaryExpression<String>(this.literal(x), y, BinaryExpressionType.CONCAT, String.class);
    }

    public Expression<String> substring(Expression<String> x, Expression<Integer> from) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> substring(Expression<String> x, int from) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> substring(Expression<String> x, Expression<Integer> from, Expression<Integer> len) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> substring(Expression<String> x, int from, int len) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> trim(Expression<String> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec ts, Expression<String> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> trim(Expression<Character> t, Expression<String> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec ts, Expression<Character> t, Expression<String> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> trim(char t, Expression<String> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec ts, char t, Expression<String> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<String> lower(Expression<String> x) {
        return new UnaryExpression<String>(x, UnaryExpressionType.LOWER);
    }

    public Expression<String> upper(Expression<String> x) {
        return new UnaryExpression<String>(x, UnaryExpressionType.UPPER);
    }

    public Expression<Integer> length(Expression<String> x) {
        return new UnaryExpression<Integer>(x, UnaryExpressionType.LENGTH);
    }

    public Expression<Integer> locate(Expression<String> x, Expression<String> pattern) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Integer> locate(Expression<String> x, String pattern) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Integer> locate(Expression<String> x, Expression<String> pattern, Expression<Integer> from) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Integer> locate(Expression<String> x, String pattern, int from) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Date> currentDate() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Timestamp> currentTimestamp() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Time> currentTime() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <T> CriteriaBuilder.In<T> in(Expression<? extends T> expression) {
        return new InPredicate<T>(expression, this);
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> x, Expression<? extends Y> y) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> x, Y y) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <Y> Expression<Y> nullif(Expression<Y> x, Expression<?> y) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <Y> Expression<Y> nullif(Expression<Y> x, Y y) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(Expression<? extends C> expression) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <R> CriteriaBuilder.Case<R> selectCase() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <T> Expression<T> function(String name, Class<T> type, Expression<?> ... args) {
        return new FunctionExpression<T>(Objects.requireNonNull(name), List.of(args), Objects.requireNonNull(type));
    }

    public <X, T, V extends T> Join<X, V> treat(Join<X, T> join, Class<V> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <X, T, E extends T> CollectionJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <X, T, E extends T> SetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <X, T, E extends T> ListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <X, K, T, V extends T> MapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <X, T extends X> Path<T> treat(Path<X> path, Class<T> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <X, T extends X> Root<T> treat(Root<X> root, Class<T> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public Predicate arrayContains(Expression<?> x, Expression<?> y) {
        return this.predicate(x, y, PredicateBinaryOp.ARRAY_CONTAINS);
    }

    public Expression<LocalDate> localDate() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<LocalDateTime> localDateTime() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<LocalTime> localTime() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Integer> sign(Expression<? extends Number> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <N extends Number> Expression<N> ceiling(Expression<N> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <N extends Number> Expression<N> floor(Expression<N> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Double> exp(Expression<? extends Number> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Double> ln(Expression<? extends Number> x) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Double> power(Expression<? extends Number> x, Expression<? extends Number> y) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Expression<Double> power(Expression<? extends Number> x, Number y) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <T extends Number> Expression<T> round(Expression<T> x, Integer n) {
        throw CriteriaUtils.notSupportedOperation();
    }
}

