/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.DefaultSort;
import io.micronaut.serde.annotation.Serdeable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Serdeable
@DefaultImplementation(value=DefaultSort.class)
public interface Sort {
    public static final Sort UNSORTED = new DefaultSort();

    @JsonIgnore
    public boolean isSorted();

    public Sort order(String var1);

    public Sort order(Order var1);

    default public Sort orders(List<Order> orders) {
        Sort theSort = this;
        for (Order order : orders) {
            theSort = theSort.order(order);
        }
        return theSort;
    }

    public Sort order(String var1, Order.Direction var2);

    public List<Order> getOrderBy();

    public static Sort unsorted() {
        return UNSORTED;
    }

    @JsonCreator
    public static Sort of(@JsonProperty(value="orderBy") @Nullable List<Order> orderList) {
        if (CollectionUtils.isEmpty(orderList)) {
            return UNSORTED;
        }
        return new DefaultSort(orderList);
    }

    public static Sort of(Order ... orders) {
        if (ArrayUtils.isEmpty((Object[])orders)) {
            return UNSORTED;
        }
        return new DefaultSort(Arrays.asList(orders));
    }

    @Serdeable
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Order {
        private final String property;
        private final Direction direction;
        private final boolean ignoreCase;

        public Order(String property) {
            this(property, Direction.ASC, false);
        }

        @JsonCreator
        @Creator
        public Order(@JsonProperty(value="property") String property, @JsonProperty(value="direction") Direction direction, @JsonProperty(value="ignoreCase") boolean ignoreCase) {
            ArgumentUtils.requireNonNull((String)"direction", (Object)((Object)direction));
            ArgumentUtils.requireNonNull((String)"property", (Object)property);
            this.direction = direction;
            this.property = property;
            this.ignoreCase = ignoreCase;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getProperty() {
            return this.property;
        }

        public Order reverse() {
            return new Order(this.property, this.direction == Direction.ASC ? Direction.DESC : Direction.ASC, this.ignoreCase);
        }

        public static Order desc(String property) {
            return new Order(property, Direction.DESC, false);
        }

        public static Order asc(String property) {
            return new Order(property, Direction.ASC, false);
        }

        public static Order desc(String property, boolean ignoreCase) {
            return new Order(property, Direction.DESC, ignoreCase);
        }

        public static Order asc(String property, boolean ignoreCase) {
            return new Order(property, Direction.ASC, ignoreCase);
        }

        public static Order of(String property, boolean ignoreCase) {
            return new Order(property, Direction.ASC, ignoreCase);
        }

        public boolean isAscending() {
            return this.getDirection() == Direction.ASC;
        }

        public String toString() {
            return "SORT{" + this.property + (this.direction == Direction.ASC ? ", ASC" : ", DESC") + (this.ignoreCase ? ", ignoreCase" : "") + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Order order = (Order)o;
            return this.ignoreCase == order.ignoreCase && this.property.equals(order.property) && this.direction == order.direction;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.property, this.direction, this.ignoreCase});
        }

        public static enum Direction {
            ASC,
            DESC;

        }
    }
}

